/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.value;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.value.IValue;

public class ValueBandwidth
implements IValue {
    private final ByteSizeFormatter.Base base;
    private final long bytesPerSecond;

    public ValueBandwidth(ByteSizeFormatter.Base base, long bytesPerSecond) {
        this.base = base;
        this.bytesPerSecond = bytesPerSecond;
    }

    public ValueBandwidth(ByteSizeFormatter.Base base, long bytes, long ns) {
        this.base = base;
        double bytesPerNs = (double)bytes / (double)ns;
        this.bytesPerSecond = (long)(bytesPerNs * 1.0E9);
    }

    public long getBandwidth() {
        return this.bytesPerSecond;
    }

    @Override
    public String toString() {
        return new BandwidthFormatter(this.base).format(this.bytesPerSecond);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ValueBandwidth)) {
            return false;
        }
        return this.bytesPerSecond == ((ValueBandwidth)obj).bytesPerSecond;
    }

    @Override
    public double dsub(IValue a) {
        if (a instanceof ValueBandwidth) {
            long d = this.bytesPerSecond - ((ValueBandwidth)a).bytesPerSecond;
            return d;
        }
        return 0.0;
    }
}

