/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.analysis.AnalysisResultNVLink;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.InstantaneousMetricManager;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.ui.analysis.NVLinkConnection;
import com.nvidia.viper.ui.analysis.NodeFigure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TopologyCanvas
extends FigureCanvas
implements ControlListener {
    private Session activeSession;
    private AnalysisResultNVLink result;
    private List<NVLinkConnection> connections;
    private List<NVLinkConnection> currentLinks = null;
    public static String PROP_LINK_SELECTION = "prop.link.selection";
    public static String PROP_LINKS_SELECTION = "prop.links.selection";
    public static Font LABEL_FONT;
    private ListenerList propertyListeners = new ListenerList(1);
    private List<ChopboxAnchor> anchors;
    private NodeFigure[] gpuNodes;
    private ArrayList<NodeFigure> cpuNodes = new ArrayList();

    public TopologyCanvas(Composite parent, int style, Session session, AnalysisResultNVLink result) {
        super(parent, style);
        this.activeSession = session;
        this.connections = new ArrayList<NVLinkConnection>();
        this.result = result;
        this.addControlListener(this);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
    }

    public List<NVLinkConnection> getLinks() {
        return this.connections;
    }

    private CuptiActivityDevice getDeviceActivity(byte[] uuid) {
        ProfileDataModel pdm = this.activeSession.getTimelinePdms().get(0);
        for (CuptiActivityDevice device : pdm.devices) {
            if (!Arrays.equals(device.uuid, uuid)) continue;
            return device;
        }
        return null;
    }

    private ChopboxAnchor getAnchor(int typeDev, byte[] uuidDev, int domainNPU, List<ChopboxAnchor> anchors) {
        ChopboxAnchor anchor3;
        int id = -1;
        String name = "";
        if (typeDev == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode()) {
            id = domainNPU;
            for (ChopboxAnchor anchor2 : anchors) {
                NodeFigure device;
                IFigure figure = anchor2.getOwner();
                if (!(figure instanceof NodeFigure) || (device = (NodeFigure)figure).getId() != id || device.getDevType() != CuptiDevType.CUPTI_DEV_TYPE_NPU) continue;
                return anchor2;
            }
        } else {
            CuptiActivityDevice dev = this.getDeviceActivity(uuidDev);
            if (dev != null) {
                id = dev.id;
                TimelineDevice deviceTl = this.activeSession.getDeviceTimeline(dev.id);
                name = deviceTl != null && deviceTl.getCustomName() != null ? deviceTl.getCustomName() : dev.name;
            }
            for (ChopboxAnchor anchor3 : anchors) {
                NodeFigure device;
                IFigure figure = anchor3.getOwner();
                if (!(figure instanceof NodeFigure) || (device = (NodeFigure)figure).getId() != id || device.getDevType() != CuptiDevType.CUPTI_DEV_TYPE_GPU) continue;
                return anchor3;
            }
        }
        NodeFigure deviceFigure = new NodeFigure(name, id, CuptiDevType.values()[typeDev]);
        deviceFigure.addListener((EventListener)((Object)this));
        anchor3 = new ChopboxAnchor((IFigure)deviceFigure);
        anchors.add(anchor3);
        return anchor3;
    }

    private int getNpuIdFromGpu(byte[] gpuUuid, List<CuptiActivityNvLink> linkRecords) {
        for (CuptiActivityNvLink link : linkRecords) {
            if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() && Arrays.equals(link.uuidDev1, gpuUuid)) {
                return link.domainNPU0;
            }
            if (link.typeDev1 != CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() || !Arrays.equals(link.uuidDev0, gpuUuid)) continue;
            return link.domainNPU1;
        }
        return -1;
    }

    private boolean isDirectLink(int typeDev0, int typeDev1, byte[] uuid0, byte[] uuid1, List<CuptiActivityNvLink> linkRecords) {
        if (typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() || typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode()) {
            return true;
        }
        boolean isDirect = this.getNpuIdFromGpu(uuid0, linkRecords) == this.getNpuIdFromGpu(uuid1, linkRecords);
        return isDirect;
    }

    private List<ChopboxAnchor> getAnchors(List<CuptiActivityNvLink> linkRecords) {
        ArrayList<ChopboxAnchor> anchors = new ArrayList<ChopboxAnchor>();
        for (CuptiActivityNvLink link : linkRecords) {
            ChopboxAnchor anchor1 = this.getAnchor(link.typeDev0, link.uuidDev0, link.domainNPU0, anchors);
            ChopboxAnchor anchor2 = this.getAnchor(link.typeDev1, link.uuidDev1, link.domainNPU1, anchors);
            boolean direct = this.isDirectLink(link.typeDev0, link.typeDev1, link.uuidDev0, link.uuidDev1, linkRecords);
            NVLinkConnection connection = new NVLinkConnection(link, direct);
            new LinkListener(connection);
            connection.setDevice1(anchor1);
            connection.setDevice2(anchor2);
            long avgTransmitBandwidth = this.getAvgTransmitBandwidth(connection);
            connection.setTransmitBandwidthLabel(avgTransmitBandwidth);
            long avgReceiveBandwidth = this.getAvgReceiveBandwidth(connection);
            connection.setReceiveBandwidthLabel(avgReceiveBandwidth);
            connection.setColor(avgReceiveBandwidth + avgTransmitBandwidth);
            connection.create();
            this.connections.add(connection);
        }
        return anchors;
    }

    public long getMinTransmitBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMinBandwidth("nvlink_transmit_throughput", connection.getDevice1().getId(), link.portDev0, link.physicalNvLinkCount);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMinBandwidth("nvlink_receive_throughput", connection.getDevice2().getId(), link.portDev1, link.physicalNvLinkCount);
        }
        return 0L;
    }

    public long getMinReceiveBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMinBandwidth("nvlink_receive_throughput", connection.getDevice1().getId(), link.portDev0, link.physicalNvLinkCount);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMinBandwidth("nvlink_transmit_throughput", connection.getDevice2().getId(), link.portDev1, link.physicalNvLinkCount);
        }
        return 0L;
    }

    public long getMaxTransmitBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMaxBandwidth("nvlink_transmit_throughput", connection.getDevice1().getId(), link.portDev0, link.physicalNvLinkCount);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMaxBandwidth("nvlink_receive_throughput", connection.getDevice2().getId(), link.portDev1, link.physicalNvLinkCount);
        }
        return 0L;
    }

    public long getMaxReceiveBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMaxBandwidth("nvlink_receive_throughput", connection.getDevice1().getId(), link.portDev0, link.physicalNvLinkCount);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return this.getMaxBandwidth("nvlink_transmit_throughput", connection.getDevice2().getId(), link.portDev1, link.physicalNvLinkCount);
        }
        return 0L;
    }

    public long getAvgTransmitBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return (long)this.getAvgMetricValue("nvlink_transmit_throughput", connection.getDevice1().getId(), link.portDev0);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return (long)this.getAvgMetricValue("nvlink_receive_throughput", connection.getDevice2().getId(), link.portDev1);
        }
        return 0L;
    }

    public long getAvgReceiveBandwidth(NVLinkConnection connection) {
        CuptiActivityNvLink link = connection.getActivity();
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return (long)this.getAvgMetricValue("nvlink_receive_throughput", connection.getDevice1().getId(), link.portDev0);
        }
        if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return (long)this.getAvgMetricValue("nvlink_transmit_throughput", connection.getDevice2().getId(), link.portDev1);
        }
        return 0L;
    }

    private double getAvgMetricValue(String metric, int deviceId, int[] port) {
        InstantaneousMetricManager instantaneousMetricManager = this.activeSession.getInstantaneousMetricManager();
        double avgValue = 0.0;
        avgValue = instantaneousMetricManager.getAvgMetricValue(deviceId, metric, port);
        return avgValue;
    }

    public double getUtilization(NVLinkConnection connection) {
        long peak;
        long tx;
        long rx = this.getAvgReceiveBandwidth(connection);
        long util = Math.min(rx + (tx = this.getAvgTransmitBandwidth(connection)), peak = connection.getBandwidth());
        return util > 0L ? (double)util / (double)peak * 100.0 : -1.0;
    }

    public int getIdleTime(NVLinkConnection connection) {
        InstantaneousMetricManager instantaneousMetricManager = this.activeSession.getInstantaneousMetricManager();
        CuptiActivityNvLink link = connection.getActivity();
        int deviceId = -1;
        String metric = null;
        int[] port = null;
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            deviceId = connection.getDevice1().getId();
            metric = "nvlink_transmit_throughput";
            port = link.portDev0;
        } else if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            deviceId = connection.getDevice2().getId();
            metric = "nvlink_receive_throughput";
            port = link.portDev1;
        }
        List<Long> txList = instantaneousMetricManager.getAggregateMetricValues(deviceId, metric, port);
        if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            deviceId = connection.getDevice1().getId();
            metric = "nvlink_receive_throughput";
            port = link.portDev0;
        } else if (link.typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            deviceId = connection.getDevice2().getId();
            metric = "nvlink_transmit_throughput";
            port = link.portDev1;
        }
        List<Long> rxList = instantaneousMetricManager.getAggregateMetricValues(deviceId, metric, port);
        List<CuptiActivityMetric> metricsList = instantaneousMetricManager.getMetricsList(deviceId, metric, port[0]);
        if (metricsList == null || metricsList.isEmpty()) {
            return -1;
        }
        long earliestTime = 0L;
        long latestTime = 0L;
        long idleTime = 0L;
        int i = 0;
        while (i < metricsList.size()) {
            if (i == 0) {
                earliestTime = metricsList.get((int)i).timestamp;
            }
            latestTime = metricsList.get((int)i).timestamp;
            if (txList.get(i) + rxList.get(i) == 0L && i > 0) {
                idleTime += latestTime - metricsList.get((int)(i - 1)).timestamp;
            }
            ++i;
        }
        long totalDuration = latestTime - earliestTime;
        return (int)((double)idleTime / (double)totalDuration * 100.0);
    }

    private long getMaxBandwidth(String metric, int deviceId, int[] port, int numLinks) {
        InstantaneousMetricManager instantaneousMetricManager = this.activeSession.getInstantaneousMetricManager();
        long maxValue = instantaneousMetricManager.getMaxMetricValue(deviceId, metric, port);
        return maxValue;
    }

    private long getMinBandwidth(String metric, int deviceId, int[] port, int numLinks) {
        InstantaneousMetricManager instantaneousMetricManager = this.activeSession.getInstantaneousMetricManager();
        long minValue = instantaneousMetricManager.getMinMetricValue(deviceId, metric, port);
        return minValue;
    }

    public void init(Set<CuptiActivityNvLink> linkRecords) {
        LABEL_FONT = new Font((Device)Display.getDefault(), "Arial", 9, 0);
        LightweightSystem lws = new LightweightSystem((Canvas)this);
        Figure mainFigure = new Figure();
        mainFigure.addMouseListener((MouseListener)new MainFigureListener());
        XYLayout layout = new XYLayout();
        mainFigure.setLayoutManager((LayoutManager)layout);
        this.anchors = this.getAnchors(new ArrayList<CuptiActivityNvLink>(linkRecords));
        Collections.sort(this.anchors, new Comparator<ChopboxAnchor>(){

            @Override
            public int compare(ChopboxAnchor o1, ChopboxAnchor o2) {
                NodeFigure dev1 = (NodeFigure)o1.getOwner();
                NodeFigure dev2 = (NodeFigure)o2.getOwner();
                return dev1.getId() > dev2.getId() ? 1 : -1;
            }
        });
        for (ChopboxAnchor anchor : this.anchors) {
            NodeFigure node = (NodeFigure)anchor.getOwner();
            Rectangle rect = this.result.getBoxRectangle(node.getId());
            layout.setConstraint((IFigure)node, (Object)rect);
            mainFigure.add((IFigure)node);
        }
        BendpointConnectionRouter router = new BendpointConnectionRouter();
        this.gpuNodes = new NodeFigure[32];
        TopologyCanvas.processNodes(this.anchors, this.connections, this.gpuNodes, this.cpuNodes, this.result);
        boolean showNpuLink = false;
        for (NVLinkConnection link : this.connections) {
            if (!link.isDirectLink()) {
                showNpuLink = true;
                continue;
            }
            link.setConnectionRouter((ConnectionRouter)router);
            mainFigure.add((IFigure)link);
        }
        if (showNpuLink && this.cpuNodes.size() > 1) {
            ChopboxAnchor anchor1 = this.getAnchor(CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode(), null, this.cpuNodes.get(0).getId(), this.anchors);
            ChopboxAnchor anchor2 = this.getAnchor(CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode(), null, this.cpuNodes.get(1).getId(), this.anchors);
            PolylineConnection conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)anchor1);
            conn.setTargetAnchor((ConnectionAnchor)anchor2);
            BendpointConnectionRouter npuRouter = new BendpointConnectionRouter();
            conn.setConnectionRouter((ConnectionRouter)npuRouter);
            conn.setForegroundColor(ViperColors.COLOR_DEVICE);
            conn.setLineWidth(2);
            PolygonDecoration dec1 = new PolygonDecoration();
            PolygonDecoration dec2 = new PolygonDecoration();
            dec1.setLineWidth(2);
            dec2.setLineWidth(2);
            conn.add((IFigure)dec1, (Object)new ArrowLocator((Connection)conn, 2));
            conn.add((IFigure)dec2, (Object)new ArrowLocator((Connection)conn, 3));
            mainFigure.add((IFigure)conn);
        }
        this.routeConnectors();
        lws.setContents((IFigure)mainFigure);
    }

    public void selectLink(NVLinkConnection link) {
        if (this.currentLinks != null) {
            for (NVLinkConnection curLink : this.currentLinks) {
                curLink.setForegroundColor(curLink.color);
            }
            this.currentLinks.clear();
        } else {
            this.currentLinks = new ArrayList<NVLinkConnection>();
        }
        link.setForegroundColor(ViperColors.COLOR_NVLINK_SELECTION);
        this.currentLinks.add(link);
        this.selectNode(null);
        this.fireProperty(link, PROP_LINK_SELECTION);
    }

    public void selectLinks(List<NVLinkConnection> links) {
        if (links == null || links.isEmpty()) {
            return;
        }
        if (this.currentLinks != null) {
            for (NVLinkConnection curLink : this.currentLinks) {
                curLink.setForegroundColor(curLink.color);
            }
            this.currentLinks.clear();
        } else {
            this.currentLinks = new ArrayList<NVLinkConnection>();
        }
        boolean isFirstLink = true;
        for (NVLinkConnection link : links) {
            link.setForegroundColor(ViperColors.COLOR_NVLINK_SELECTION);
            this.currentLinks.add(link);
            if (isFirstLink) {
                this.fireProperty(link, PROP_LINK_SELECTION);
                isFirstLink = false;
                continue;
            }
            this.fireProperty(link, PROP_LINKS_SELECTION);
        }
    }

    private void fireProperty(IModel model, String prop) {
        Object[] listeners;
        Object[] objectArray = listeners = this.propertyListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ISessionPropertyChangeListener) {
                ((ISessionPropertyChangeListener)object).propertyChange(model, prop);
            }
            ++n2;
        }
    }

    public void addPropertyChangeListener(ISessionPropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.anchors != null) {
            this.result.needRestore();
        }
    }

    public static void processNodes(List<ChopboxAnchor> anchors, List<NVLinkConnection> connections, NodeFigure[] gpuNodes, ArrayList<NodeFigure> cpus, AnalysisResultNVLink result) {
        boolean[][] adj = new boolean[8][8];
        for (ChopboxAnchor anchor1 : anchors) {
            for (ChopboxAnchor anchor2 : anchors) {
                int id1 = ((NodeFigure)anchor1.getOwner()).getId();
                int id2 = ((NodeFigure)anchor2.getOwner()).getId();
                if (id1 >= adj.length || id2 >= adj.length) continue;
                for (NVLinkConnection link : connections) {
                    if (!link.isDirectLink()) continue;
                    int id1_ = link.getDevice1().getId();
                    int id2_ = link.getDevice2().getId();
                    if (id1 < 0 || id2 < 0 || id1_ < 0 || id2_ < 0 || link.getDevice1().getDevType() == CuptiDevType.CUPTI_DEV_TYPE_NPU || link.getDevice2().getDevType() == CuptiDevType.CUPTI_DEV_TYPE_NPU || (id1_ != id1 || id2_ != id2) && (id1_ != id2 || id2_ != id1)) continue;
                    adj[id1][id2] = true;
                    adj[id2][id1] = true;
                }
            }
        }
        ArrayList<NodeFigure> unsortedGpuNodes = new ArrayList<NodeFigure>();
        ArrayList<NodeFigure> excessGpuNodes = new ArrayList<NodeFigure>();
        int gpuNodeCount = 0;
        for (ChopboxAnchor anchor : anchors) {
            if (((NodeFigure)anchor.getOwner()).getDevType() == CuptiDevType.CUPTI_DEV_TYPE_GPU) {
                ++gpuNodeCount;
                if (unsortedGpuNodes.size() < 8) {
                    unsortedGpuNodes.add((NodeFigure)anchor.getOwner());
                    continue;
                }
                excessGpuNodes.add((NodeFigure)anchor.getOwner());
                continue;
            }
            cpus.add((NodeFigure)anchor.getOwner());
        }
        NodeFigure[] sortedGpuNodes = new NodeFigure[8];
        if (cpus.size() == 0) {
            if (TopologyCanvas.recursivePlaceInCubeMesh(sortedGpuNodes, unsortedGpuNodes, adj) && result != null) {
                TopologyCanvas.drawTopologyCubeMesh(sortedGpuNodes, result);
            }
        } else if (TopologyCanvas.recursivePlaceInHexagon(sortedGpuNodes, unsortedGpuNodes, adj) && result != null) {
            TopologyCanvas.drawTopologyHexagon(cpus, sortedGpuNodes, gpuNodeCount, result);
        }
        int i = 0;
        while (i < sortedGpuNodes.length) {
            gpuNodes[i] = sortedGpuNodes[i];
            ++i;
        }
        i = 0;
        while (i < excessGpuNodes.size()) {
            gpuNodes[sortedGpuNodes.length + i] = (NodeFigure)((Object)excessGpuNodes.get(i));
            ++i;
        }
    }

    private static boolean recursivePlaceInCubeMesh(NodeFigure[] placedNodes, ArrayList<NodeFigure> remainingNodes, boolean[][] adj) {
        int i = 0;
        while (i < placedNodes.length) {
            if (placedNodes[i] == null) {
                boolean valid = false;
                int id = remainingNodes.get(0).getId();
                switch (i) {
                    case 0: {
                        valid = !(placedNodes[4] != null && adj[placedNodes[4].getId()][id] || placedNodes[5] != null && adj[placedNodes[5].getId()][id] || placedNodes[7] != null && adj[placedNodes[7].getId()][id]);
                        break;
                    }
                    case 1: {
                        valid = !(placedNodes[4] != null && adj[placedNodes[4].getId()][id] || placedNodes[5] != null && adj[placedNodes[5].getId()][id] || placedNodes[6] != null && adj[placedNodes[6].getId()][id]);
                        break;
                    }
                    case 2: {
                        valid = !(placedNodes[5] != null && adj[placedNodes[5].getId()][id] || placedNodes[6] != null && adj[placedNodes[6].getId()][id] || placedNodes[7] != null && adj[placedNodes[7].getId()][id]);
                        break;
                    }
                    case 3: {
                        valid = !(placedNodes[4] != null && adj[placedNodes[4].getId()][id] || placedNodes[6] != null && adj[placedNodes[6].getId()][id] || placedNodes[7] != null && adj[placedNodes[7].getId()][id]);
                        break;
                    }
                    case 4: {
                        valid = !(placedNodes[0] != null && adj[placedNodes[0].getId()][id] || placedNodes[1] != null && adj[placedNodes[1].getId()][id] || placedNodes[3] != null && adj[placedNodes[3].getId()][id]);
                        break;
                    }
                    case 5: {
                        valid = !(placedNodes[0] != null && adj[placedNodes[0].getId()][id] || placedNodes[1] != null && adj[placedNodes[1].getId()][id] || placedNodes[2] != null && adj[placedNodes[2].getId()][id]);
                        break;
                    }
                    case 6: {
                        valid = !(placedNodes[1] != null && adj[placedNodes[1].getId()][id] || placedNodes[2] != null && adj[placedNodes[2].getId()][id] || placedNodes[3] != null && adj[placedNodes[3].getId()][id]);
                        break;
                    }
                    case 7: {
                        valid = !(placedNodes[0] != null && adj[placedNodes[0].getId()][id] || placedNodes[2] != null && adj[placedNodes[2].getId()][id] || placedNodes[3] != null && adj[placedNodes[3].getId()][id]);
                        break;
                    }
                    default: {
                        valid = true;
                    }
                }
                if (valid) {
                    placedNodes[i] = remainingNodes.get(0);
                    if (remainingNodes.size() == 1) {
                        return true;
                    }
                    ArrayList<NodeFigure> newRemainingNodes = new ArrayList<NodeFigure>(remainingNodes);
                    newRemainingNodes.remove(0);
                    if (TopologyCanvas.recursivePlaceInCubeMesh(placedNodes, newRemainingNodes, adj)) {
                        return true;
                    }
                    placedNodes[i] = null;
                }
            }
            ++i;
        }
        return false;
    }

    private static void drawTopologyCubeMesh(NodeFigure[] gpus, AnalysisResultNVLink result) {
        int nextX = 50;
        int gpuOffset = 170;
        int i = 0;
        while (i < gpus.length) {
            if (gpus[i] != null) {
                Rectangle bounds = new Rectangle(nextX, 225 - 150 * (i % 2), -1, -1);
                LayoutManager layoutMgr = gpus[i].getParent().getLayoutManager();
                layoutMgr.setConstraint((IFigure)gpus[i], (Object)bounds);
                result.setBoxRectangle(gpus[i].getId(), bounds);
            }
            if (i % 2 == 1) {
                nextX += gpuOffset;
            }
            ++i;
        }
    }

    private static boolean recursivePlaceInHexagon(NodeFigure[] placedNodes, ArrayList<NodeFigure> remainingNodes, boolean[][] adj) {
        if (remainingNodes.size() > 6) {
            return false;
        }
        int i = 0;
        while (i < 6) {
            if (placedNodes[i] == null) {
                boolean valid = false;
                int id = remainingNodes.get(0).getId();
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        valid = !(placedNodes[3] != null && adj[placedNodes[3].getId()][id] || placedNodes[4] != null && adj[placedNodes[4].getId()][id] || placedNodes[5] != null && adj[placedNodes[5].getId()][id]);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        valid = !(placedNodes[0] != null && adj[placedNodes[0].getId()][id] || placedNodes[1] != null && adj[placedNodes[1].getId()][id] || placedNodes[2] != null && adj[placedNodes[2].getId()][id]);
                        break;
                    }
                    default: {
                        valid = true;
                    }
                }
                if (valid) {
                    placedNodes[i] = remainingNodes.get(0);
                    if (remainingNodes.size() == 1) {
                        return true;
                    }
                    ArrayList<NodeFigure> newRemainingNodes = new ArrayList<NodeFigure>(remainingNodes);
                    newRemainingNodes.remove(0);
                    if (TopologyCanvas.recursivePlaceInHexagon(placedNodes, newRemainingNodes, adj)) {
                        return true;
                    }
                    placedNodes[i] = null;
                }
            }
            ++i;
        }
        return false;
    }

    private static void drawTopologyHexagon(ArrayList<NodeFigure> cpus, NodeFigure[] gpus, int numGpus, AnalysisResultNVLink result) {
        int leftMargin = 50;
        int i = 0;
        while (i < cpus.size()) {
            Rectangle bounds = i == 0 ? new Rectangle(leftMargin + 215, 100, -1, -1) : (i == 1 ? new Rectangle(leftMargin + 345, 100, -1, -1) : new Rectangle(0, 0, -1, -1));
            LayoutManager layoutMgr = cpus.get(i).getParent().getLayoutManager();
            layoutMgr.setConstraint((IFigure)cpus.get(i), (Object)bounds);
            result.setBoxRectangle(cpus.get(i).getId(), bounds);
            ++i;
        }
        i = 0;
        while (i < gpus.length) {
            if (gpus[i] != null) {
                int x = 0;
                if (i == 0 || i == 1) {
                    x = leftMargin;
                } else if (i == 3 || i == 4) {
                    x = leftMargin + 560;
                } else if (i == 2) {
                    x = leftMargin + 70;
                } else if (i == 5) {
                    x = leftMargin + 490;
                }
                int y = 0;
                if (i == 0 || i == 3) {
                    y = 250;
                } else if (i == 1 || i == 4) {
                    y = 50;
                } else if (i == 2 || i == 5) {
                    y = 150;
                }
                Rectangle bounds = new Rectangle(x, y, -1, -1);
                LayoutManager layoutMgr = gpus[i].getParent().getLayoutManager();
                layoutMgr.setConstraint((IFigure)gpus[i], (Object)bounds);
                result.setBoxRectangle(gpus[i].getId(), bounds);
            }
            ++i;
        }
    }

    private void routeConnectors() {
        if (this.cpuNodes.size() > 0) {
            return;
        }
        for (NVLinkConnection link : this.connections) {
            if (this.gpuNodes == null) {
                return;
            }
            int id1 = link.getDevice1().getId();
            int id2 = link.getDevice2().getId();
            int loc1 = -1;
            int loc2 = -1;
            int i = 0;
            while (i < this.gpuNodes.length) {
                if (this.gpuNodes[i] != null && (id1 == this.gpuNodes[i].getId() || id2 == this.gpuNodes[i].getId())) {
                    if (loc1 == -1) {
                        loc1 = i;
                    } else {
                        loc2 = i;
                    }
                }
                ++i;
            }
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            Rectangle rect1 = this.result.getBoxRectangle(id1);
            Rectangle rect2 = this.result.getBoxRectangle(id2);
            int x1 = rect1.x + NodeFigure.NODE_WIDTH / 2;
            int x2 = rect2.x + NodeFigure.NODE_WIDTH / 2;
            int y1 = rect1.y;
            int y2 = rect2.y;
            if (loc1 == 0 && loc2 == 6) {
                bends.add(new AbsoluteBendpoint(x1, y1 + 100));
                bends.add(new AbsoluteBendpoint(x2, y2 + 100));
                link.setRoutingConstraint(bends);
            } else if (loc1 == 1 && loc2 == 7) {
                bends.add(new AbsoluteBendpoint(x1, y1 - 50));
                bends.add(new AbsoluteBendpoint(x2, y2 - 50));
                link.setRoutingConstraint(bends);
            } else if (loc1 == 2 && loc2 == 4) {
                bends.add(new AbsoluteBendpoint(x1, y1 + 75));
                bends.add(new AbsoluteBendpoint(x2, y2 + 75));
                link.setRoutingConstraint(bends);
            } else if (loc1 == 3 && loc2 == 5) {
                bends.add(new AbsoluteBendpoint(x1, y1 - 25));
                bends.add(new AbsoluteBendpoint(x2, y2 - 25));
                link.setRoutingConstraint(bends);
            }
            if (loc1 == 0 && loc2 == 1 || loc1 == 4 && loc2 == 5) {
                link.setTransmitBandwidthLabelOffset(10, -10);
                link.setReceiveBandwidthLabelOffset(10, -10);
                continue;
            }
            if (loc1 == 6 && loc2 == 7 || loc1 == 2 && loc2 == 3) {
                link.setTransmitBandwidthLabelOffset(10, 10);
                link.setReceiveBandwidthLabelOffset(10, 10);
                continue;
            }
            if (loc1 == 0 && loc2 == 6 || loc1 == 1 && loc2 == 7 || loc1 == 2 && loc2 == 4 || loc1 == 3 && loc2 == 5) {
                link.setTransmitBandwidthLabelOffset(10, 10);
                link.setReceiveBandwidthLabelOffset(10, -10);
                continue;
            }
            if (loc1 == 0 && loc2 == 3 || loc1 == 1 && loc2 == 2 || loc1 == 4 && loc2 == 7 || loc1 == 5 && loc2 == 6) {
                link.setTransmitBandwidthLabelOffset(10, 0);
                link.setReceiveBandwidthLabelOffset(10, 0);
                continue;
            }
            if (loc1 == 0 && loc2 == 2 || loc1 == 1 && loc2 == 3 || loc1 == 4 && loc2 == 6 || loc1 == 5 && loc2 == 7) {
                link.setTransmitBandwidthLabelOffset(-20, -5);
                link.setReceiveBandwidthLabelOffset(-20, 5);
                continue;
            }
            if (loc1 == 1 && loc2 == -1) {
                link.setTransmitBandwidthLabelOffset(5, -20);
                link.setReceiveBandwidthLabelOffset(5, -10);
                continue;
            }
            if (loc1 != 0 || loc2 != -1) continue;
            link.setTransmitBandwidthLabelOffset(5, 20);
            link.setReceiveBandwidthLabelOffset(5, 10);
        }
    }

    public void propertyChanged(NodeFigure node, String property) {
        if (NodeFigure.PROPERTY_NODE_MOVED.equals(property)) {
            this.result.setBoxRectangle(node.getId(), node.getBounds());
        }
        if (NodeFigure.PROPERTY_NODE_SELECTED.equals(property)) {
            this.selectNode(node);
        }
    }

    private void selectNode(NodeFigure selectedNode) {
        NodeFigure[] nodeFigureArray = this.gpuNodes;
        int n = this.gpuNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeFigure node = nodeFigureArray[n2];
            if (node != null) {
                node.setLineWidth(NodeFigure.NOT_SELECTED_WIDTH);
            }
            ++n2;
        }
        for (NodeFigure node : this.cpuNodes) {
            if (node == null) continue;
            node.setLineWidth(NodeFigure.NOT_SELECTED_WIDTH);
        }
        if (selectedNode != null) {
            selectedNode.setLineWidth(NodeFigure.SELECTED_WIDTH);
            ArrayList<NVLinkConnection> links = new ArrayList<NVLinkConnection>();
            for (NVLinkConnection link : this.connections) {
                if (!((Object)((Object)link.getDevice1())).equals((Object)selectedNode) && !((Object)((Object)link.getDevice2())).equals((Object)selectedNode)) continue;
                links.add(link);
            }
            this.selectLinks(links);
        }
    }

    public class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private NVLinkConnection link;

        public LinkListener(NVLinkConnection link) {
            this.link = link;
            this.link.addMouseListener(this);
            this.link.addMouseMotionListener(this);
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
            if (TopologyCanvas.this.currentLinks == null || TopologyCanvas.this.currentLinks.isEmpty()) {
                this.link.setForegroundColor(this.link.color);
            }
        }

        public void mouseHover(MouseEvent me) {
            if (TopologyCanvas.this.currentLinks == null || TopologyCanvas.this.currentLinks.isEmpty()) {
                this.link.setForegroundColor(ViperColors.COLOR_NVLINK_SELECTION);
            }
        }

        public void mouseMoved(MouseEvent me) {
            if (TopologyCanvas.this.currentLinks == null || TopologyCanvas.this.currentLinks.isEmpty()) {
                this.link.setForegroundColor(ViperColors.COLOR_NVLINK_SELECTION);
            }
        }

        public void mousePressed(MouseEvent me) {
            TopologyCanvas.this.selectLink(this.link);
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    public class MainFigureListener
    implements MouseListener {
        public void mousePressed(MouseEvent me) {
            if (TopologyCanvas.this.currentLinks != null && !TopologyCanvas.this.currentLinks.isEmpty()) {
                for (NVLinkConnection curLink : TopologyCanvas.this.currentLinks) {
                    curLink.setForegroundColor(curLink.color);
                }
                TopologyCanvas.this.currentLinks.clear();
            }
            TopologyCanvas.this.selectNode(null);
            TopologyCanvas.this.fireProperty(null, PROP_LINK_SELECTION);
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

