/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.ViperViewerComparator;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultCriticalPath;
import com.nvidia.viper.model.CriticalPath;
import com.nvidia.viper.model.CriticalPathStat;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ViperMemento;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CriticalPathResultControl
extends AnalysisResultControl {
    private static String KEY_SORTED_COLUMN_INDEX = "table.sorted.column.index";
    private static String KEY_SORT_DIRECTION = "table.sort.direction";
    private ViperViewerComparator comparator;
    private static final String[] columnNames = new String[]{"Function Name", "Time on Critical Path (%)", "Time on Critical Path", "Waiting time"};

    public CriticalPathResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
    }

    private CriticalPath getCriticalPath() {
        if (this.result instanceof AnalysisResultCriticalPath) {
            return ((AnalysisResultCriticalPath)this.result).getCriticalPath();
        }
        return null;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        CriticalPath path = this.getCriticalPath();
        if (path == null) {
            return;
        }
        TableViewer viewer = new TableViewer(parent, 68354);
        this.createColumns(viewer);
        Table table = viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)path.stats);
        this.comparator = new ViperViewerComparator(){

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                CriticalPathStat stat1 = (CriticalPathStat)e1;
                CriticalPathStat stat2 = (CriticalPathStat)e2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        rc = stat1.getName().compareTo(stat2.getName());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (stat1.time < stat2.time) {
                            rc = -1;
                        }
                        if (stat1.time <= stat2.time) break;
                        rc = 1;
                        break;
                    }
                    case 3: {
                        if (stat1.waitTime < stat2.waitTime) {
                            rc = -1;
                        }
                        if (stat1.waitTime <= stat2.waitTime) break;
                        rc = 1;
                        break;
                    }
                    default: {
                        rc = 0;
                    }
                }
                if (this.direction == 1) {
                    rc = -rc;
                }
                return rc;
            }
        };
        int sortCol = 1;
        int sortDir = 1024;
        ViperMemento memento = ((AnalysisResultCriticalPath)this.result).getMemento();
        if (memento != null) {
            if (memento.getInteger(KEY_SORTED_COLUMN_INDEX) != null) {
                sortCol = memento.getInteger(KEY_SORTED_COLUMN_INDEX);
            }
            if (memento.getInteger(KEY_SORT_DIRECTION) != null) {
                sortDir = memento.getInteger(KEY_SORT_DIRECTION);
            }
        }
        this.comparator.setColumn(sortCol, sortDir);
        viewer.setComparator((ViewerComparator)this.comparator);
        viewer.getTable().setSortColumn(viewer.getTable().getColumn(sortCol));
        viewer.getTable().setSortDirection(sortDir);
        viewer.refresh();
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private void createColumns(TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn(columnNames[0], 0, 0, viewer);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((CriticalPathStat)cell.getElement()).getName());
            }
        });
        col = this.createTableViewerColumn(columnNames[1], 1, 131072, viewer);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                CriticalPathStat function = (CriticalPathStat)cell.getElement();
                double per = 100.0 * ((double)function.time / (double)((CriticalPathResultControl)CriticalPathResultControl.this).getCriticalPath().totalDuration);
                cell.setText(String.format("%.2f %%", per));
            }
        });
        col = this.createTableViewerColumn(columnNames[2], 2, 131072, viewer);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                CriticalPathStat function = (CriticalPathStat)cell.getElement();
                cell.setText(new TimeFormatter().format(function.time));
            }
        });
        col = this.createTableViewerColumn(columnNames[3], 3, 131072, viewer);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                CriticalPathStat function = (CriticalPathStat)cell.getElement();
                cell.setText(new TimeFormatter().format(function.waitTime));
            }
        });
        col = this.createTableViewerColumn("", columnNames.length, 0, viewer);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int colNumber, int style, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        if (title != null && !title.isEmpty()) {
            column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber, viewer));
        }
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index, final TableViewer viewer) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriticalPathResultControl.this.comparator.setColumn(index, 128);
                int dir = CriticalPathResultControl.this.comparator.getDirection();
                viewer.getTable().setSortColumn(column);
                viewer.getTable().setSortDirection(dir);
                viewer.refresh();
                column.pack();
                ViperMemento memento = ((AnalysisResultCriticalPath)CriticalPathResultControl.this.result).getMemento();
                if (memento != null) {
                    memento.putInteger(KEY_SORTED_COLUMN_INDEX, index);
                    memento.putInteger(KEY_SORT_DIRECTION, dir);
                }
            }
        };
        return selectionAdapter;
    }
}

