/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.cdi.Locator;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;

public abstract class LocationBreakpoint
extends Breakpoint
implements ICDIBreakpoint {
    ICDILocation fLocation;

    public LocationBreakpoint(Target target, int kind, ICDILocation loc, ICDICondition cond, boolean enabled) {
        super(target, kind, cond, enabled);
        this.fLocation = loc;
    }

    public int getLineNumber() {
        if (this.miBreakpoints != null && this.miBreakpoints.length > 0) {
            return this.miBreakpoints[0].getLine();
        }
        if (this.fLocation instanceof ICDILineLocation) {
            return ((ICDILineLocation)this.fLocation).getLineNumber();
        }
        return 0;
    }

    public String getFile() {
        if (this.miBreakpoints != null && this.miBreakpoints.length > 0) {
            return this.miBreakpoints[0].getFile();
        }
        if (this.fLocation instanceof ICDILineLocation) {
            return ((ICDILineLocation)this.fLocation).getFile();
        }
        if (this.fLocation instanceof ICDIFunctionLocation) {
            return ((ICDIFunctionLocation)this.fLocation).getFile();
        }
        return null;
    }

    public BigInteger getAddress() {
        if (this.miBreakpoints != null && this.miBreakpoints.length > 0) {
            BigInteger addr = BigInteger.ZERO;
            String a = this.miBreakpoints[0].getAddress();
            if (a != null) {
                addr = MIFormat.getBigInteger(a);
            }
            return addr;
        }
        if (this.fLocation instanceof ICDIAddressLocation) {
            return ((ICDIAddressLocation)this.fLocation).getAddress();
        }
        return null;
    }

    public String getFunction() {
        if (this.fLocation instanceof ICDIFunctionLocation) {
            return ((ICDIFunctionLocation)this.fLocation).getFunction();
        }
        if (this.miBreakpoints != null && this.miBreakpoints.length > 0) {
            return this.miBreakpoints[0].getFunction();
        }
        return null;
    }

    public ICDILocator getLocator() {
        return new Locator(this.getFile(), this.getFunction(), this.getLineNumber(), this.getAddress());
    }
}

