/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.InstructionFormatter;
import com.nvidia.viper.RequestFormatter;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.EdgeItem;
import com.nvidia.viper.ui.analysis.NodeItem;
import com.nvidia.viper.ui.analysis.VerticalNodeItem;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class MemoryChartCanvas
extends FigureCanvas {
    static int NumRows = 5;
    static int RowHeight = 40;
    static int RowSpacing = 20;
    static int Row1Y = 50;
    static int Row2Y = Row1Y + RowHeight + RowSpacing;
    static int Row3Y = Row1Y + (RowHeight + RowSpacing) * 2;
    static int Row4Y = Row1Y + (RowHeight + RowSpacing) * 3;
    static int Row5Y = Row1Y + (RowHeight + RowSpacing) * 4;
    static int ColumnSpacing = 100;
    static int Column1Width = 30;
    static int Column2Width = 80;
    static int Column3Width = 80;
    static int Column4Width = 80;
    static int Column5Width = 30;
    static int DefaultSpaceLoadStoreEdge = 15;
    private NodeItem kernelRect;
    private NodeItem globalRect;
    private NodeItem localRect;
    private NodeItem texRect;
    private NodeItem surfaceRect;
    private NodeItem sharedRect;
    private NodeItem unifiedRect;
    private NodeItem sharedMemRect;
    private NodeItem l2Rect;
    private NodeItem sysMemRect;
    private NodeItem deviceMemRect;
    private TimelineIntervalKernel kernel;
    private Figure parentFigure;

    public MemoryChartCanvas(Composite parent, int style, TimelineIntervalKernel kernel) {
        super(parent, style);
        this.kernel = kernel;
        this.init();
    }

    private void init() {
        LightweightSystem lws = new LightweightSystem((Canvas)this);
        this.parentFigure = new Figure();
        XYLayout layout = new XYLayout();
        this.parentFigure.setLayoutManager((LayoutManager)layout);
        lws.setContents((IFigure)this.parentFigure);
        this.createNodes();
        this.createEdges();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
    }

    private void createNodes() {
        long metricValue;
        String kernelName = this.kernel.getDisplayName();
        int itemX = 50;
        this.kernelRect = new VerticalNodeItem(kernelName);
        this.parentFigure.add((IFigure)this.kernelRect);
        int itemHeight = RowHeight * NumRows + RowSpacing * (NumRows - 1);
        this.kernelRect.setSize(Column1Width, itemHeight);
        this.kernelRect.setLocation(new Point(itemX, Row1Y));
        this.kernelRect.setBackgroundColor(NodeItem.COLOR_SW);
        this.globalRect = new NodeItem("Global");
        this.parentFigure.add((IFigure)this.globalRect);
        this.globalRect.setSize(Column2Width, RowHeight);
        this.globalRect.setLocation(new Point(itemX += Column1Width + ColumnSpacing, Row1Y));
        this.globalRect.setBackgroundColor(NodeItem.COLOR_SW);
        this.localRect = new NodeItem("Local");
        this.parentFigure.add((IFigure)this.localRect);
        this.localRect.setSize(Column2Width, RowHeight);
        this.localRect.setLocation(new Point(itemX, Row2Y));
        this.localRect.setBackgroundColor(NodeItem.COLOR_SW);
        this.texRect = new NodeItem("Texture");
        this.parentFigure.add((IFigure)this.texRect);
        this.texRect.setSize(Column2Width, RowHeight);
        this.texRect.setLocation(new Point(itemX, Row3Y));
        this.texRect.setBackgroundColor(NodeItem.COLOR_SW);
        this.surfaceRect = new NodeItem("Surface");
        this.parentFigure.add((IFigure)this.surfaceRect);
        this.surfaceRect.setSize(Column2Width, RowHeight);
        this.surfaceRect.setLocation(new Point(itemX, Row4Y));
        this.surfaceRect.setBackgroundColor(NodeItem.COLOR_SW);
        this.sharedRect = new NodeItem("Shared");
        this.parentFigure.add((IFigure)this.sharedRect);
        this.sharedRect.setSize(Column2Width, RowHeight);
        this.sharedRect.setLocation(new Point(itemX, Row5Y));
        this.sharedRect.setBackgroundColor(NodeItem.COLOR_SW);
        itemX += Column2Width + ColumnSpacing;
        int rowSpan = 4;
        itemHeight = RowHeight * rowSpan + RowSpacing * (rowSpan - 1);
        Number value = AnalysisBase.getAggregateMetricValue(this.kernel, "tex_cache_hit_rate");
        String text = "Unified\nCache";
        if (value != null) {
            metricValue = value.longValue();
            text = String.valueOf(text) + "\n\n" + metricValue + "%";
        }
        this.unifiedRect = new NodeItem(text);
        this.parentFigure.add((IFigure)this.unifiedRect);
        this.unifiedRect.setSize(Column3Width, itemHeight);
        this.unifiedRect.setLocation(new Point(itemX, Row1Y));
        this.sharedMemRect = new NodeItem("Shared\nMemory");
        this.parentFigure.add((IFigure)this.sharedMemRect);
        this.sharedMemRect.setSize(Column3Width, RowHeight);
        this.sharedMemRect.setLocation(new Point(itemX, Row5Y));
        itemX += Column3Width + ColumnSpacing;
        rowSpan = 4;
        int l2Height = itemHeight = RowHeight * rowSpan + RowSpacing * (rowSpan - 1);
        value = AnalysisBase.getAggregateMetricValue(this.kernel, "l2_tex_hit_rate");
        text = "L2 Cache";
        if (value != null) {
            metricValue = value.longValue();
            text = String.valueOf(text) + "\n\n" + metricValue + "%";
        }
        this.l2Rect = new NodeItem(text);
        this.parentFigure.add((IFigure)this.l2Rect);
        this.l2Rect.setSize(Column4Width, l2Height);
        this.l2Rect.setLocation(new Point(itemX, Row1Y));
        itemHeight = 2 * RowHeight + RowSpacing;
        this.sysMemRect = new VerticalNodeItem("System Memory");
        this.parentFigure.add((IFigure)this.sysMemRect);
        this.sysMemRect.setSize(Column5Width, itemHeight);
        this.sysMemRect.setLocation(new Point(itemX += Column4Width + ColumnSpacing, Row1Y));
        int itemY = Row1Y + itemHeight + RowSpacing;
        this.deviceMemRect = new VerticalNodeItem("Device Memory");
        this.parentFigure.add((IFigure)this.deviceMemRect);
        this.deviceMemRect.setSize(Column5Width, itemHeight);
        this.deviceMemRect.setLocation(new Point(itemX, itemY));
    }

    private String getColumn2Text(Collection<String> metricList) {
        if (metricList != null) {
            long metricValue = 0L;
            for (String metric : metricList) {
                Number value = AnalysisBase.getAggregateMetricValue(this.kernel, metric);
                if (value == null) {
                    return "n/a";
                }
                metricValue += value.longValue();
            }
            RequestFormatter formatter = new RequestFormatter();
            return formatter.getFormattedText(metricValue);
        }
        return "n/a";
    }

    private String getColumn1Text(Collection<String> metricList) {
        if (metricList != null) {
            long metricValue = 0L;
            for (String metric : metricList) {
                Number value = AnalysisBase.getAggregateMetricValue(this.kernel, metric);
                if (value == null) {
                    return "n/a";
                }
                metricValue += value.longValue();
            }
            InstructionFormatter formatter = new InstructionFormatter();
            return formatter.getFormattedText(metricValue);
        }
        return "n/a";
    }

    private String getByteText(Collection<String> metricList) {
        if (metricList != null) {
            long metricValue = 0L;
            for (String metricName : metricList) {
                Number metric = AnalysisBase.getAggregateMetricValue(this.kernel, metricName);
                if (metric == null) {
                    return "n/a";
                }
                metricValue += metric.longValue();
            }
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(metricValue);
        }
        return "n/a";
    }

    private boolean isPascalMaxwell() {
        int major = this.kernel.getMajorComputeCapability();
        return major >= 5 && major < 7;
    }

    private boolean isVolta() {
        int major = this.kernel.getMajorComputeCapability();
        return major >= 7 && major < 8;
    }

    private void createEdges() {
        String text = this.getColumn1Text(Arrays.asList("inst_executed_global_loads", "inst_executed_global_stores", "inst_executed_global_atomics", "inst_executed_global_reductions"));
        this.createColumn1Edge(this.kernelRect, this.globalRect, new int[]{2, 3}, text);
        text = this.getColumn1Text(Arrays.asList("inst_executed_local_loads", "inst_executed_local_stores"));
        this.createColumn1Edge(this.kernelRect, this.localRect, new int[]{2, 3}, text);
        text = this.getColumn1Text(Arrays.asList("inst_executed_tex_ops"));
        this.createColumn1Edge(this.kernelRect, this.texRect, new int[]{2}, text);
        text = this.getColumn1Text(Arrays.asList("inst_executed_surface_loads", "inst_executed_surface_stores", "inst_executed_surface_atomics", "inst_executed_surface_reductions"));
        this.createColumn1Edge(this.kernelRect, this.surfaceRect, new int[]{2, 3}, text);
        text = this.getColumn1Text(Arrays.asList("inst_executed_shared_loads", "inst_executed_shared_stores", "inst_executed_shared_atomics"));
        this.createColumn1Edge(this.kernelRect, this.sharedRect, new int[]{2, 3}, text);
        text = this.getColumn2Text(Arrays.asList("global_load_requests", "global_atomic_requests"));
        this.createColumn2Edge(this.globalRect, this.unifiedRect, 2, text);
        text = this.getColumn2Text(Arrays.asList("global_store_requests", "global_reduction_requests"));
        this.createColumn2Edge(this.globalRect, this.unifiedRect, 3, text);
        text = this.getColumn2Text(Arrays.asList("local_load_requests"));
        this.createColumn2Edge(this.localRect, this.unifiedRect, 2, text);
        text = this.getColumn2Text(Arrays.asList("local_store_requests"));
        this.createColumn2Edge(this.localRect, this.unifiedRect, 3, text);
        text = this.getColumn2Text(Arrays.asList("surface_load_requests", "surface_atomic_requests"));
        this.createColumn2Edge(this.surfaceRect, this.unifiedRect, 2, text);
        text = this.getColumn2Text(Arrays.asList("surface_store_requests", "surface_reduction_requests"));
        this.createColumn2Edge(this.surfaceRect, this.unifiedRect, 3, text);
        text = this.getColumn2Text(Arrays.asList("shared_load_transactions"));
        this.createColumn2Edge(this.sharedRect, this.sharedMemRect, 2, text);
        text = this.getColumn2Text(Arrays.asList("shared_store_transactions"));
        this.createColumn2Edge(this.sharedRect, this.sharedMemRect, 3, text);
        this.createTextToUniCacheEdge();
        String[] metrics = null;
        if (this.isPascalMaxwell()) {
            metrics = new String[]{"l2_global_atomic_store_bytes", "l2_global_load_bytes", "l2_local_load_bytes", "l2_surface_load_bytes", "l2_surface_atomic_store_bytes"};
        } else if (this.isVolta()) {
            metrics = new String[]{"l2_global_atomic_store_bytes", "l2_global_load_bytes", "l2_local_load_bytes", "l2_surface_load_bytes"};
        }
        text = this.getByteText(Arrays.asList(metrics));
        this.createColumn3Edge(this.unifiedRect, this.l2Rect, 2, text);
        if (this.isPascalMaxwell()) {
            metrics = new String[]{"l2_global_atomic_store_bytes", "l2_local_global_store_bytes", "l2_global_reduction_bytes", "l2_surface_atomic_store_bytes", "l2_surface_store_bytes", "l2_surface_reduction_bytes"};
        } else if (this.isVolta()) {
            metrics = new String[]{"l2_global_atomic_store_bytes", "l2_local_global_store_bytes", "l2_surface_store_bytes"};
        }
        text = this.getByteText(Arrays.asList(metrics));
        this.createColumn3Edge(this.unifiedRect, this.l2Rect, 3, text);
        text = this.getByteText(Arrays.asList("sysmem_read_bytes"));
        this.createColumn4Edge(this.l2Rect, this.sysMemRect, 2, text);
        text = this.getByteText(Arrays.asList("sysmem_write_bytes"));
        this.createColumn4Edge(this.l2Rect, this.sysMemRect, 3, text);
        text = this.getByteText(Arrays.asList("dram_read_bytes"));
        this.createColumn4Edge(this.l2Rect, this.deviceMemRect, 2, text);
        text = this.getByteText(Arrays.asList("dram_write_bytes"));
        this.createColumn4Edge(this.l2Rect, this.deviceMemRect, 3, text);
    }

    private void createColumn4Edge(NodeItem src, NodeItem target, int location, String text) {
        int y1;
        Rectangle srcBound = src.getBounds();
        Rectangle dstBound = target.getBounds();
        double interval = (dstBound.height() - DefaultSpaceLoadStoreEdge) / 2;
        double factor = location == 2 ? interval : interval + (double)DefaultSpaceLoadStoreEdge;
        int x1 = srcBound.x() + srcBound.width();
        int x2 = dstBound.x();
        int y2 = y1 = (int)((double)dstBound.y() + factor);
        EdgeItem conn = new EdgeItem();
        conn.addArrow(location);
        conn.setStart(new Point(x1, y1));
        conn.setEnd(new Point(x2, y2));
        conn.addLabel(text, location);
        this.parentFigure.add((IFigure)conn);
    }

    private void createColumn3Edge(NodeItem src, NodeItem target, int location, String text) {
        this.createColumn2Edge(src, target, location, text);
    }

    private void createTextToUniCacheEdge() {
        int y1;
        Rectangle col1Bound = this.texRect.getBounds();
        Rectangle col2Bound = this.unifiedRect.getBounds();
        int x1 = col1Bound.x + col1Bound.width();
        int x2 = col2Bound.x;
        int y2 = y1 = col1Bound.y + col1Bound.height() / 2;
        EdgeItem conn = new EdgeItem();
        conn.addArrow(2);
        conn.setStart(new Point(x1, y1));
        conn.setEnd(new Point(x2, y2));
        String text = this.getColumn2Text(Arrays.asList("texture_load_requests"));
        conn.addLabel(text, 2);
        this.parentFigure.add((IFigure)conn);
    }

    private void createColumn2Edge(NodeItem src, NodeItem target, int location, String text) {
        int y1;
        Rectangle srcRect = src.getBounds();
        Rectangle dstRect = target.getBounds();
        double interval = (srcRect.height - DefaultSpaceLoadStoreEdge) / 2;
        double factor = location == 2 ? interval : interval + (double)DefaultSpaceLoadStoreEdge;
        int x1 = srcRect.x + srcRect.width();
        int x2 = dstRect.x;
        int y2 = y1 = (int)((double)srcRect.y + factor);
        EdgeItem conn = new EdgeItem();
        conn.addArrow(location);
        conn.setStart(new Point(x1, y1));
        conn.setEnd(new Point(x2, y2));
        conn.addLabel(text, location);
        this.parentFigure.add((IFigure)conn);
    }

    private void createColumn1Edge(NodeItem src, NodeItem target, int[] arrowLocation, String string) {
        EdgeItem conn = new EdgeItem();
        int[] nArray = arrowLocation;
        int n = arrowLocation.length;
        int n2 = 0;
        while (n2 < n) {
            int location = nArray[n2];
            conn.addArrow(location);
            ++n2;
        }
        Rectangle srcRect = src.getBounds();
        Rectangle destRect = target.getBounds();
        int x1 = srcRect.right();
        int y1 = destRect.getCenter().y;
        int x2 = destRect.x;
        int y2 = destRect.getCenter().y;
        conn.setStart(new Point(x1, y1));
        conn.setEnd(new Point(x2, y2));
        conn.addLabel(string, 2);
        this.parentFigure.add((IFigure)conn);
    }
}

