/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.EventManager;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.model.Event;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.Disposable;

public class InstantaneousEventManager
implements Disposable {
    private Map<Integer, Map<String, List<CuptiActivityEvent>>> deviceEventMap = new HashMap<Integer, Map<String, List<CuptiActivityEvent>>>();
    private Map<Integer, Map<String, Map<Integer, List<CuptiActivityEvent>>>> deviceInstanceEventMap = new HashMap<Integer, Map<String, Map<Integer, List<CuptiActivityEvent>>>>();

    public void dispose() {
        this.deviceEventMap.clear();
        this.deviceInstanceEventMap.clear();
        this.deviceEventMap = null;
        this.deviceInstanceEventMap = null;
    }

    public void reset() {
        this.deviceEventMap.clear();
        this.deviceInstanceEventMap.clear();
    }

    public void addEvent(CuptiActivityEvent event) {
        Event eventObject = EventManager.getEvent(event.domain, event.id);
        if (eventObject == null) {
            return;
        }
        String eventName = eventObject.getName();
        if (event.instance == -1) {
            Map<Object, Object> eventMap = this.deviceEventMap.containsKey(event.deviceId) ? this.deviceEventMap.get(event.deviceId) : new HashMap();
            List<CuptiActivityEvent> eventsList = eventMap.containsKey(event.id) ? (List)eventMap.get(event.id) : new LinkedList<CuptiActivityEvent>();
            eventsList.add(event);
            eventMap.put(eventName, eventsList);
            this.deviceEventMap.put(event.deviceId, eventMap);
        } else {
            Map<Object, Object> eventInstanceMap = this.deviceInstanceEventMap.containsKey(event.deviceId) ? this.deviceInstanceEventMap.get(event.deviceId) : new HashMap();
            Map instanceMap = eventInstanceMap.containsKey(event.id) ? (Map)eventInstanceMap.get(event.id) : new HashMap();
            List<CuptiActivityEvent> eventsList = instanceMap.containsKey(event.instance) ? (List)instanceMap.get(event.instance) : new LinkedList<CuptiActivityEvent>();
            eventsList.add(event);
            instanceMap.put(event.instance, eventsList);
            eventInstanceMap.put(eventName, instanceMap);
            this.deviceInstanceEventMap.put(event.deviceId, eventInstanceMap);
        }
    }
}

