/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CallableWithProgress;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.remote.RemoteUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import com.nvidia.cuda.ide.remote.connection.UserTerminatedException;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.FileSystemException;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.fs.NvprofDeviceData;
import com.nvidia.viper.fs.ToolkitNotConfiguredException;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.ui.RememberChoiceDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public final class RemoteFileSystem
extends FileSystem {
    private static final String LAUNCH_STATE_DIRNAME = "launch";
    private static int launchCount = 0;
    private final IRemoteConnection connection;
    private AtomicReference<IDevicesData> deviceData = new AtomicReference<Object>(null);
    private AtomicReference<String[]> remoteOutput = new AtomicReference<Object>(null);
    private ViperException deviceInformationFetchingFailure = null;
    private AtomicBoolean fetching = new AtomicBoolean(false);

    public RemoteFileSystem(IRemoteConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevicesData accessDeviceData() throws ViperException, DeviceListNotReadyException {
        if (this.fetching.compareAndSet(false, true)) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RemoteFileSystem.this.readDeviceData();
                        }
                        catch (ViperException e) {
                            RemoteFileSystem.this.deviceInformationFetchingFailure = e;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                AtomicBoolean atomicBoolean = this.fetching;
                synchronized (atomicBoolean) {
                    this.fetching.set(false);
                    this.fetching.notify();
                }
                throw throwable;
            }
            AtomicBoolean atomicBoolean = this.fetching;
            synchronized (atomicBoolean) {
                this.fetching.set(false);
                this.fetching.notify();
            }
        }
        System.out.printf("[RemoteFileSystem::accessDeviceData] Waiting for other thread\n", new Object[0]);
        try {
            AtomicBoolean atomicBoolean = this.fetching;
            synchronized (atomicBoolean) {
                while (this.fetching.get()) {
                    this.fetching.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.deviceInformationFetchingFailure != null) {
            throw this.deviceInformationFetchingFailure;
        }
        IDevicesData newData = this.deviceData.get();
        if (newData == null) {
            throw new DeviceListNotReadyException(this);
        }
        return newData;
    }

    @Override
    public String browseForDirectory(Shell shell, String title, String prompt, String value) throws CoreException {
        return this.connection.browse(shell, prompt, value);
    }

    @Override
    public String browseForFile(Shell shell, String title, String prompt, String value) throws CoreException {
        return this.connection.browse(shell, prompt, value);
    }

    @Override
    public String[] browseForFileMulti(Shell shell, String title, String prompt, String value) throws CoreException {
        return this.connection.browseMulti(shell, prompt, value);
    }

    public String buildProfilerCommandLine(Executable executable, String profilerArguments, IPath profileFile) throws ViperException {
        Path filePath;
        ICudaToolkit toolkit = this.getToolkit();
        String strCWD = executable.getWorkingDir();
        if (toolkit.isCustomScript(ICudaToolkit.Tool.Nvprof)) {
            filePath = new Path(toolkit.getToolPath(ICudaToolkit.Tool.Nvprof));
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toString();
        } else if (strCWD == null && executable.getFilename() != null) {
            filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(RemoteUtil.cd((IRemoteConnection)this.connection, (String)strCWD));
        builder.append(RemoteUtil.setEnvironment((IRemoteConnection)this.connection, (ICudaToolkit)toolkit, executable.getEnv()));
        builder.append(toolkit.getToolPath(ICudaToolkit.Tool.Nvprof)).append(" ");
        if (!executable.isProfileAllProcesses()) {
            builder.append(" --quiet ");
        }
        builder.append(profilerArguments);
        builder.append(" -o ").append(RemoteUtil.quote((String)profileFile.toString())).append(" ");
        if (!executable.isProfileAllProcesses()) {
            builder.append(RemoteUtil.quote((String)executable.getFilename()));
            String applicationArguments = executable.getArgs();
            if (!CoreUtil.isNullOrEmpty((String)applicationArguments)) {
                builder.append(" ").append(executable.getArgs());
            }
        }
        return builder.toString();
    }

    @Override
    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connection.connect(IRemoteConnection.Service.Files, monitor);
    }

    public File[] dowloadProfilingResultFile(IPath profilePath, SubMonitor m, Executable exe) throws ViperException, CoreException {
        IPath localParent = TemporaryDirs.launches.newSubfolder();
        IPath[] remoteFiles = null;
        if (exe != null && exe.isMultiProcess()) {
            IPath remoteParent = profilePath.removeLastSegments(1);
            remoteFiles = this.connection.getProfileFiles(remoteParent, (IProgressMonitor)m);
        } else {
            remoteFiles = new IPath[]{profilePath};
        }
        ArrayList<File> localFiles = new ArrayList<File>();
        int i = 0;
        while (i < remoteFiles.length) {
            if (exe == null || !exe.isMPI() || remoteFiles[i].lastSegment().contains("api_" + this.connection.getHostName())) {
                IPath localPath = localParent.append(remoteFiles[i].lastSegment());
                this.connection.download(remoteFiles[i], localPath, false, (IProgressMonitor)m.newChild(300));
                if (exe != null) {
                    this.connection.deleteFile(remoteFiles[i].toString(), (IProgressMonitor)m.newChild(100));
                }
                localFiles.add(localPath.toFile());
            }
            ++i;
        }
        if (exe != null) {
            this.connection.deleteEmptyFolder(profilePath.removeLastSegments(1), (IProgressMonitor)m.newChild(100));
        }
        return localFiles.toArray(new File[localFiles.size()]);
    }

    @Override
    public IDevicesData getDeviceData(boolean longRunning) throws DeviceListNotReadyException, ViperException {
        IDevicesData data = this.deviceData.get();
        if (!this.connection.isConnected(IRemoteConnection.Service.Shell)) {
            this.deviceData.compareAndSet(data, null);
        }
        if (this.deviceData.get() != null) {
            return this.deviceData.get();
        }
        if (!longRunning) {
            throw new DeviceListNotReadyException(this);
        }
        return this.accessDeviceData();
    }

    @Override
    public String getName() {
        return this.connection.getName();
    }

    private IPath getProfileFolder(IProgressMonitor monitor) throws ViperException {
        IPath loc;
        IPath launchState = new Path(String.valueOf(this.connection.getTmpDirectory()) + "/nvvp_" + this.connection.getUserName()).append(LAUNCH_STATE_DIRNAME);
        while (this.connection.isDirectory((loc = launchState.append(String.valueOf(launchCount++))).toString(), (IProgressMonitor)new NullProgressMonitor())) {
        }
        try {
            this.connection.mkdir(loc.toString(), monitor);
        }
        catch (CoreException e) {
            throw new ViperException(String.format("Unable to create directory %s on a remote system", loc.toString()), e);
        }
        return loc;
    }

    public ICudaToolkit getToolkit() throws ViperException, ToolkitNotConfiguredException {
        ICudaToolkit toolkit;
        try {
            toolkit = (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return service.getToolkit(RemoteFileSystem.this.getName());
                }
            });
        }
        catch (CoreException e) {
            throw new ViperException(e);
        }
        if (toolkit == null) {
            throw new ToolkitNotConfiguredException(this);
        }
        return toolkit;
    }

    @Override
    public boolean isConnected() {
        return this.connection.isConnected(IRemoteConnection.Service.Files);
    }

    @Override
    public boolean isExistingDirectory(String path) throws FileSystemException {
        return this.connection.isDirectory(path, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isExistingFile(String path) throws FileSystemException {
        return this.connection.isFile(path, false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isLocal() {
        return this.connection.isLocalSystem();
    }

    @Override
    public boolean isRunnable(String path) {
        return !this.connection.isConnected(IRemoteConnection.Service.Files) || this.connection.isFile(path, true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isTimestampChanged(String path, long lastModifiedTime) {
        return false;
    }

    protected String[] obtainRemoteNvprofOutput(IProgressMonitor monitor) throws ViperException {
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)"Obtaining list of devices", (int)200);
        ICudaToolkit toolkit = this.getToolkit();
        try {
            String environment = RemoteUtil.setEnvironment((IRemoteConnection)this.connection, (ICudaToolkit)toolkit, Collections.emptyMap());
            String profilerPath = RemoteUtil.quote((String)toolkit.getToolPath(ICudaToolkit.Tool.Nvprof));
            String profiler_with_env = String.format("%s%s", environment, profilerPath);
            String[] output = this.runCommand(String.format("%s %s; %s --version", profiler_with_env, "--query-cuda-info", profiler_with_env), convert);
            return output;
        }
        catch (CoreException e) {
            throw new ViperException(e);
        }
    }

    protected void readDeviceData() throws ViperException {
        if (this.remoteOutput.get() == null) {
            try {
                Version version;
                int localVersion;
                this.remoteOutput.compareAndSet(null, (String[])new CallableWithProgress<String[]>(){

                    public String[] call(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            return RemoteFileSystem.this.obtainRemoteNvprofOutput(monitor);
                        }
                        catch (ViperException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }.callInDialog());
                String[] deviceStr = null;
                String[] versionStr = null;
                String[] output = this.remoteOutput.get();
                int i = 0;
                while (i < output.length) {
                    if (output[i].contains("command line profiler")) {
                        deviceStr = new String[i];
                        System.arraycopy(output, 0, deviceStr, 0, i);
                        versionStr = new String[output.length - i];
                        System.arraycopy(output, i, versionStr, 0, output.length - i);
                        break;
                    }
                    ++i;
                }
                int remoteVersion = 0;
                if (versionStr != null) {
                    int i2 = 0;
                    while (i2 < versionStr.length) {
                        if (versionStr[i2].contains("version")) {
                            String v = versionStr[i2].split(" ")[2];
                            String[] nums = v.split("\\.");
                            remoteVersion = Integer.parseInt(nums[0]) * 1000 + Integer.parseInt(nums[1]) * 10;
                            break;
                        }
                        ++i2;
                    }
                }
                if ((localVersion = (version = FrameworkUtil.getBundle(this.getClass()).getVersion()).getMajor() * 1000 + version.getMinor() * 10) != remoteVersion) {
                    String msg = String.format("Remote nvprof version (%s) is different than the local version (%s). Due to this, some profiling information might not be available. Do you want to proceed?", this.formatVersion(remoteVersion), this.formatVersion(localVersion));
                    if (!RememberChoiceDialog.openQuestion("Version mismatch", msg, "ShowVersionMismatchWarning", true)) {
                        this.deviceData.set(null);
                    } else {
                        this.deviceData.set(new NvprofDeviceData(deviceStr));
                    }
                } else {
                    this.deviceData.set(new NvprofDeviceData(deviceStr));
                }
                this.remoteOutput.set(null);
            }
            catch (InvocationTargetException e) {
                throw (ViperException)CoreUtil.exceptionCast((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String formatVersion(int version) {
        return String.format("%s.%s", version / 1000, version % 1000 / 10);
    }

    private String[] runCommand(String command, SubMonitor monitor) throws CoreException {
        IRemoteShell shell = this.connection.openShell((IProgressMonitor)monitor.newChild(100));
        if (monitor.isCanceled()) {
            return null;
        }
        String remoteShell = String.format("/bin/sh -c %s", RemoteUtil.quote((String)command));
        String[] output = shell.run(remoteShell, 300000, (IProgressMonitor)monitor.newChild(100));
        if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
            if (output != null) {
                String[] stringArray = output;
                int n = output.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    System.out.println(string);
                    ++n2;
                }
            } else {
                System.err.println("No output!!!");
            }
        }
        return output;
    }

    private boolean runConsoleCommand(String consoleName, String command, String profileFolder, SubMonitor monitor, Executable executable) throws CoreException, ViperException {
        String remoteShell;
        IRemoteShell shell = this.connection.openShell((IProgressMonitor)monitor.newChild(100));
        if (monitor.isCanceled()) {
            return false;
        }
        String osType = this.connection.getOsType();
        if (osType.equals("QNX")) {
            String encoding;
            String innerCommand = String.format("/bin/sh -c %s", RemoteUtil.quote((String)command));
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath localExe = workspaceLocation.append("execTemp.sh");
            try {
                FileOutputStream out = new FileOutputStream(localExe.toFile());
                OutputStreamWriter writer = new OutputStreamWriter(out);
                encoding = writer.getEncoding();
                writer.write(innerCommand);
                writer.flush();
                writer.close();
                out.close();
            }
            catch (Exception exception) {
                return false;
            }
            String execTemp = String.valueOf(profileFolder) + "/execTemp.sh";
            this.connection.uploadExecutableFile(localExe.toString(), execTemp, encoding, (IProgressMonitor)monitor.newChild(100));
            String outerCommand = String.format("%s; rm %s", execTemp, execTemp, execTemp);
            remoteShell = String.format("/bin/sh -c %s", RemoteUtil.quote((String)outerCommand));
        } else {
            remoteShell = String.format("/bin/sh -c %s", RemoteUtil.quote((String)command));
        }
        try {
            this.checkNvprofErrorCode(shell.runInteractive(consoleName, remoteShell, (IProgressMonitor)monitor.newChild(100)));
            return true;
        }
        catch (UserTerminatedException userTerminatedException) {
            if (executable.isProfileAllProcesses()) {
                monitor.setCanceled(false);
                return true;
            }
            return false;
        }
    }

    @Override
    public File[] runNvprof(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        File[] result = this.runTool(executable, profilerArguments, outputFile, monitor, ICudaToolkit.Tool.Nvprof);
        return result;
    }

    private File[] runTool(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor, ICudaToolkit.Tool tool) throws ViperException, CoreException {
        File[] result;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
        IPath profileFolder = this.getProfileFolder((IProgressMonitor)m.newChild(100));
        IPath profilePath = profileFolder.append(outputFile);
        String commandLine = "";
        if (tool.equals((Object)ICudaToolkit.Tool.Nvprof)) {
            commandLine = this.buildProfilerCommandLine(executable, profilerArguments, profilePath);
        } else if (tool.equals((Object)ICudaToolkit.Tool.RebelCmdLine)) {
            commandLine = this.buildRebelCommandLine(executable, profilerArguments, profilePath);
        }
        String appName = executable.getFilename() == null ? "nvprof" : new Path(executable.getFilename()).lastSegment();
        String consoleTitle = String.format("%s on %s", appName, this.getName());
        if (this.runConsoleCommand(consoleTitle, commandLine, profileFolder.toString(), m, executable)) {
            result = this.dowloadResultFile(profilePath, m, executable, tool);
        } else {
            m.setWorkRemaining(0);
            result = null;
        }
        m.done();
        return result;
    }

    private File[] dowloadResultFile(IPath profilePath, SubMonitor m, Executable exe, ICudaToolkit.Tool tool) throws ViperException, CoreException {
        if (tool.equals((Object)ICudaToolkit.Tool.Nvprof)) {
            return this.dowloadProfilingResultFile(profilePath, m, exe);
        }
        if (tool.equals((Object)ICudaToolkit.Tool.RebelCmdLine)) {
            return this.dowloadRebelResultFile(profilePath, m, exe);
        }
        return null;
    }

    private File[] dowloadRebelResultFile(IPath profilePath, SubMonitor m, Executable exe) throws ViperException, CoreException {
        profilePath = profilePath.addFileExtension(Viper.REBEL_COMMAND_LINE_EXT.substring(1));
        IPath localParent = TemporaryDirs.launches.newSubfolder();
        IPath[] remoteFiles = new IPath[]{profilePath};
        ArrayList<File> localFiles = new ArrayList<File>();
        int i = 0;
        while (i < remoteFiles.length) {
            IPath localPath = localParent.append(remoteFiles[i].lastSegment());
            this.connection.download(remoteFiles[i], localPath, false, (IProgressMonitor)m.newChild(300));
            if (exe != null) {
                this.connection.deleteFile(remoteFiles[i].toString(), (IProgressMonitor)m.newChild(100));
            }
            localFiles.add(localPath.toFile());
            ++i;
        }
        if (exe != null) {
            IPath parentFolder = profilePath.removeLastSegments(1);
            try {
                this.connection.deleteEmptyFolder(parentFolder, (IProgressMonitor)m.newChild(100));
            }
            catch (Exception exception) {}
        }
        return localFiles.toArray(new File[localFiles.size()]);
    }

    private String buildRebelCommandLine(Executable executable, String profilerArguments, IPath profileFile) throws ToolkitNotConfiguredException, ViperException, CoreException {
        ICudaToolkit toolkit = this.getToolkit();
        String strCWD = executable.getWorkingDir();
        if (strCWD == null && executable.getFilename() != null) {
            Path filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(RemoteUtil.cd((IRemoteConnection)this.connection, (String)strCWD));
        builder.append(RemoteUtil.setEnvironment((IRemoteConnection)this.connection, (ICudaToolkit)toolkit, executable.getEnv()));
        String rebelPath = this.connection.getRebelCmdLinePath();
        if (rebelPath != null && !rebelPath.isEmpty()) {
            builder.append(rebelPath);
        } else {
            File binDir = new File(toolkit.getBinDirectory());
            File parentDir = binDir.getParentFile();
            rebelPath = String.valueOf(parentDir.getAbsolutePath()) + File.separator + "NsightCompute-1.0" + File.separator + Viper.REBEL_COMMAND_LINE_EXE;
            if (this.isExistingFile(rebelPath) && this.isRunnable(rebelPath)) {
                builder.append(rebelPath);
            } else {
                throw new ViperException(String.format(ViperMessages.ErrorExeNotInPath, Viper.REBEL_COMMAND_LINE_EXE));
            }
        }
        builder.append(profilerArguments);
        builder.append(" -o ").append(RemoteUtil.quote((String)profileFile.toString())).append(" ");
        builder.append(RemoteUtil.quote((String)executable.getFilename()));
        String applicationArguments = executable.getArgs();
        if (!CoreUtil.isNullOrEmpty((String)applicationArguments)) {
            builder.append(" ").append(executable.getArgs());
        }
        return builder.toString();
    }

    @Override
    public boolean readAndResetNvprofWarningStatus() {
        return false;
    }

    @Override
    public boolean isCustomScript() {
        try {
            return this.getToolkit().isCustomScript(ICudaToolkit.Tool.Nvprof);
        }
        catch (ViperException viperException) {
            return false;
        }
    }

    public String downloadExecutable(String remoteFilename) throws ViperException, CoreException {
        Path remotePath = new Path(remoteFilename);
        IPath localParent = TemporaryDirs.execs.newSubfolder().append(remotePath.lastSegment());
        IProgressMonitor downloadProgress = new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void worked(int work) {
            }
        };
        this.connection.download((IPath)remotePath, localParent, true, downloadProgress);
        return localParent.toString();
    }

    @Override
    public File runRebelCommandLine(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        File[] result = this.runTool(executable, profilerArguments, outputFile, monitor, ICudaToolkit.Tool.RebelCmdLine);
        if (result != null && result.length == 1) {
            return result[0];
        }
        return null;
    }
}

