/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.RulerColumnBase;
import com.nvidia.viper.ui.SassViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class GPRColumn
extends RulerColumnBase {
    public static final int DEFAULT_WIDTH = 90;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_VMARGIN = 2;
    public static final String COLUMN_HEADER = "Registers";
    private static Color GPR_COLOR = new Color(null, new RGB(160, 160, 160));

    public GPRColumn() {
        this(90);
    }

    public GPRColumn(int width) {
        this.setWidth(width);
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && ((SassViewer)this.viewer).getGPRvalue(widgetLine) > 0L) {
            int barBorderY = linePixel + 2;
            int maxWidth = this.getWidth() - 10;
            int height = lineHeight - 4;
            int barWidth = this.getRelativeWidth(widgetLine, maxWidth);
            if (barWidth > 0) {
                gc.setBackground(GPR_COLOR);
                gc.fillRectangle(5, barBorderY, barWidth, height);
            }
            gc.setForeground(ViperColors.COLOR_EXEC_COUNT_BACKGROUND);
            gc.drawRectangle(5, barBorderY, maxWidth, height);
            this.drawMarkerAtEnd(widgetLine, gc, this.viewer, this.getWidth() - 1, lineHeight + linePixel, this.getWidth() - 1, barBorderY);
        }
    }

    private int getRelativeWidth(int widgetLine, int maxWidth) {
        if (this.viewer instanceof SassViewer) {
            return (int)((double)((SassViewer)this.viewer).getGPRvalue(widgetLine) * (double)maxWidth / (double)((SassViewer)this.viewer).getMaxGPR());
        }
        return 0;
    }

    @Override
    protected void updateColumn() {
        this.redraw();
    }

    @Override
    public int getColumnIndex() {
        return 8;
    }

    @Override
    protected String getToolTipText(int lineNumber) {
        if (this.viewer instanceof SassViewer) {
            String tooltipFormat = "Registers/Thread = %d [Maximum Registers/Thread = %d]\n";
            long gpr = ((SassViewer)this.viewer).getGPRvalue(lineNumber);
            if (gpr > 0L) {
                return String.format(tooltipFormat, gpr, ((SassViewer)this.viewer).getMaxGPR());
            }
        }
        return null;
    }

    @Override
    protected boolean isHotspotPresent() {
        return AnalysisResultSourceLevelKind.GENERAL_PURPOSE_REGISTER_KIND.equals((Object)this.viewer.getCurrentAnnotationKind());
    }
}

