/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityInstructionClass;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivitySourceLevelResultBase;
import com.nvidia.viper.model.ITimelineInterval;

public class CuptiActivityInstructionExecution
extends CuptiActivitySourceLevelResultBase {
    public int flags;
    public long notPredOffThreadsExecuted;

    CuptiActivityInstructionExecution() {
    }

    public CuptiActivityInstructionExecution(ITimelineInterval interval, boolean isNull) {
        super(interval, isNull);
        if (isNull && !interval.getCorrelationIds().isEmpty()) {
            this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION.getCode();
            this.flags = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_NONE.getCode();
            this.functionId = 0;
            this.notPredOffThreadsExecuted = 0L;
        }
    }

    @Override
    public boolean isNullResult() {
        return super.isNullResult() && this.notPredOffThreadsExecuted == 0L;
    }

    public CuptiActivityInstructionClass getInstructionClass() {
        int classType = (this.flags & CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK.getCode()) >> 1;
        CuptiActivityInstructionClass[] cuptiActivityInstructionClassArray = CuptiActivityInstructionClass.values();
        int n = cuptiActivityInstructionClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityInstructionClass iClass = cuptiActivityInstructionClassArray[n2];
            if (iClass.getCode() == classType) {
                return iClass;
            }
            ++n2;
        }
        return CuptiActivityInstructionClass.CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN;
    }
}

