#! /usr/bin/perl
#* ============================================================
# * File  : rdfcast.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2007-03-14
# * ============================================================ */


use English;
use XML::Simple;
use XML::DOM;
use Data::Dumper;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

eval { $data = $xml->XMLin($source); };

$data = $data->{aflevering};
$streams = $data->{streams};

# print Dumper($data);

foreach my $entry (@{$streams->{stream}})
{
  
  if ($entry->{content} ne "")
  {
    $item = $doc->createElement('item');
    $item->appendChild( newNode('name', $data->{tite} . ' (' . $entry->{compressie_formaat} . ', ' . $entry->{compressie_kwaliteit} . ')') );
    $item->appendChild( newNode('url', $entry->{content}) );
    $item->appendChild( newNode('descr', $data->{gids_tekst}) );
    #$item->appendChild( newNode('handler', 'STREAM_DL') );
    $root->appendChild($item);
  }
    
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


