#include "plugin.h"
#include <errno.h>

extern int errno;
extern int DEBUG;
#include <X11/xpm.h>
#include <X11/cursorfont.h>

#ifdef X_ENABLED
#include "../pixmaps/logo.xpm"
#include "../pixmaps/progress_left.xpm"
#include "../pixmaps/progress_middle.xpm"
#include "../pixmaps/progress_right.xpm"
#include "../pixmaps/progress_fill.xpm"
#endif

#ifdef GTK_ENABLED

// 16 x 12 button pixmaps
#include "../pixmaps/play_down_small.xpm"
#include "../pixmaps/play_up_small.xpm"
#include "../pixmaps/pause_down_small.xpm"
#include "../pixmaps/pause_up_small.xpm"
#include "../pixmaps/stop_down_small.xpm"
#include "../pixmaps/stop_up_small.xpm"
#include "../pixmaps/ff_down_small.xpm"
#include "../pixmaps/ff_up_small.xpm"
#include "../pixmaps/rew_down_small.xpm"
#include "../pixmaps/rew_up_small.xpm"
#include "../pixmaps/fs_down_small.xpm"
#include "../pixmaps/fs_up_small.xpm"
#endif

#define BUTTON_WIDTH	43
#define BUTTON_HEIGHT	32
#define SMALL_BUTTON_WIDTH	21
#define SMALL_BUTTON_HEIGHT	16

#define BORDER               10
#define LOGO_WIDTH          257
#define LOGO_HEIGHT          48

#ifndef HAVE_X11_XPM
#error libXpm has not been found. Compilation cannot continue
#endif

void Initialize(Display * dpy, Drawable d, nsPluginInstance * instance,
		GC gc)
{
#ifdef X_ENABLED
    Cursor guicursor;
    XSetWindowAttributes attrs;

    XpmCreatePixmapFromData(dpy, d, logo_xpm, &instance->logo,
			    &instance->logomask, NULL);
    XpmCreatePixmapFromData(dpy, d, progress_left_xpm,
			    &instance->progress_left,
			    &instance->progress_leftmask, NULL);
    XpmCreatePixmapFromData(dpy, d, progress_middle_xpm,
			    &instance->progress_middle,
			    &instance->progress_middlemask, NULL);
    XpmCreatePixmapFromData(dpy, d, progress_right_xpm,
			    &instance->progress_right,
			    &instance->progress_rightmask, NULL);
    XpmCreatePixmapFromData(dpy, d, progress_fill_xpm,
			    &instance->progress_fill,
			    &instance->progress_fillmask, NULL);
    instance->font = XQueryFont(dpy, XGContextFromGC(gc));
    guicursor = XCreateFontCursor(dpy, XC_watch);
    attrs.cursor = guicursor;
    XChangeWindowAttributes(dpy, d, CWCursor, &attrs);
#endif
}

void InitPixbufs(nsPluginInstance * instance)
{
#ifdef GTK2_ENABLED

    instance->pb_sm_play_up =
	gdk_pixbuf_new_from_xpm_data((const char **) play_up_small);
    instance->pb_sm_play_down =
	gdk_pixbuf_new_from_xpm_data((const char **) play_down_small);
    instance->pb_sm_pause_up =
	gdk_pixbuf_new_from_xpm_data((const char **) pause_up_small);
    instance->pb_sm_pause_down =
	gdk_pixbuf_new_from_xpm_data((const char **) pause_down_small);
    instance->pb_sm_stop_up =
	gdk_pixbuf_new_from_xpm_data((const char **) stop_up_small);
    instance->pb_sm_stop_down =
	gdk_pixbuf_new_from_xpm_data((const char **) stop_down_small);
    instance->pb_sm_ff_up =
	gdk_pixbuf_new_from_xpm_data((const char **) ff_up_small);
    instance->pb_sm_ff_down =
	gdk_pixbuf_new_from_xpm_data((const char **) ff_down_small);
    instance->pb_sm_rew_up =
	gdk_pixbuf_new_from_xpm_data((const char **) rew_up_small);
    instance->pb_sm_rew_down =
	gdk_pixbuf_new_from_xpm_data((const char **) rew_down_small);
    instance->pb_sm_fs_up =
	gdk_pixbuf_new_from_xpm_data((const char **) fs_up_small);
    instance->pb_sm_fs_down =
	gdk_pixbuf_new_from_xpm_data((const char **) fs_down_small);
#endif

#ifdef GTK1_ENABLED

    instance->pb_sm_play_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, play_up_small);
    instance->pb_sm_play_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, play_down_small);
    instance->pb_sm_pause_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, pause_up_small);
    instance->pb_sm_pause_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, pause_down_small);
    instance->pb_sm_stop_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, stop_up_small);
    instance->pb_sm_stop_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, stop_down_small);
    instance->pb_sm_ff_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, ff_up_small);
    instance->pb_sm_ff_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, ff_down_small);
    instance->pb_sm_rew_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, rew_up_small);
    instance->pb_sm_rew_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, rew_down_small);
    instance->pb_sm_fs_up =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, fs_up_small);
    instance->pb_sm_fs_down =
	gdk_pixmap_create_from_xpm_d(instance->gtkwidget->window,
				     NULL, NULL, fs_down_small);

#endif
}

void DrawLogo(Display * dpy, Drawable d, nsPluginInstance * instance,
	      GC gc)
{
#ifdef X_ENABLED
    XGCValues values;

    values.clip_mask = instance->logomask;
    values.clip_x_origin = 0;
    values.clip_y_origin = 0;
    XChangeGC(dpy, gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);
    XCopyArea(dpy, instance->logo, d, gc, 0, 0, LOGO_WIDTH, LOGO_HEIGHT, 0,
	      0);
    values.clip_mask = (Pixmap) NULL;
    XChangeGC(dpy, gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);
#endif
}


void DrawProgressBG(Display * dpy, Window w, nsPluginInstance * instance,
		    int x, int y, int width, int height)
{
#ifdef X_ENABLED
    XGCValues values;
    GC border_gc;

    border_gc = XCreateGC(dpy, w, GCForeground, &values);

    values.clip_mask = instance->progress_leftmask;
    values.clip_x_origin = x - 10;
    values.clip_y_origin = y - 10;
    XChangeGC(dpy, border_gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);
    XCopyArea(dpy, instance->progress_left, (Drawable) w, border_gc, 0, 0,
	      10, 31, x - 10, y - 10);
    values.clip_mask = (Pixmap) NULL;
    XChangeGC(dpy, border_gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);

    XSetTile(dpy, border_gc, instance->progress_middle);
    XSetFillStyle(dpy, border_gc, FillTiled);
    XSetTSOrigin(dpy, border_gc, x, y - 10);
    XFillRectangle(dpy, w, border_gc, x, y - 10, width, 31);
    XSetFillStyle(dpy, border_gc, FillSolid);

    values.clip_mask = instance->progress_rightmask;
    values.clip_x_origin = x + width;
    values.clip_y_origin = y - 10;
    XChangeGC(dpy, border_gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);
    XCopyArea(dpy, instance->progress_right, (Drawable) w, border_gc, 0, 0,
	      10, 31, x + width, y - 10);
    values.clip_mask = (Pixmap) NULL;
    XChangeGC(dpy, border_gc, GCClipMask | GCClipXOrigin | GCClipYOrigin,
	      &values);

    XFreeGC(dpy, border_gc);
#endif
}

void DrawProgress(Display * dpy, Window w, nsPluginInstance * instance,
		  int x, int y, int width, int height, int percent)
{
#ifdef X_ENABLED
    GC progress_gc;
    int pixelpercent;
    XGCValues values;

    if (percent > 100)
	percent = 100;
    progress_gc = XCreateGC(dpy, w, GCForeground, &values);
    XSetTile(dpy, progress_gc, instance->progress_fill);
    XSetFillStyle(dpy, progress_gc, FillTiled);
    XSetTSOrigin(dpy, progress_gc, x, y);
    pixelpercent = (int) ((width - x) * (percent / 100.));
    XFillRectangle(dpy, w, progress_gc, x, y, pixelpercent, height);
    XSetFillStyle(dpy, progress_gc, FillSolid);
    XFreeGC(dpy, progress_gc);
#endif
}



void DrawUI(Widget w, nsPluginInstance * instance, char *message,
	    int FullRedraw, int percent)
{
#ifdef X_ENABLED
    GC black_gc, white_gc;
    XGCValues values;
    const char *id = "mplayerplug-in v" PACKAGE_VERSION;
    unsigned int id_width;
    int top, font_height, loops;
    int term, chop;
    int PercentRedraw;

    if (0) {
	printf("Widget: %i\n", (int)w);
	printf("Message: %s\n", message);
    }

    if (DEBUG > 1)
	printf("state = %i, height = %i width = %i\n", instance->state,
	       instance->movie_height, instance->movie_width);

    if (w == NULL)
	return;
    if (instance->state < STATE_READY)
	return;
    if (message == NULL)
	return;
    if (instance->display == NULL)
	return;
    if (instance->state == STATE_PLAYING && instance->movie_height > 0
	&& instance->movie_width > 0)
	return;

    sprintf(instance->lastmessage, "%s", message);

    values.foreground =
	BlackPixel((Display *) instance->display,
		   DefaultScreen((Display *) instance->display));
    black_gc =
	XCreateGC((Display *) instance->display,
		  (Drawable) instance->window, GCForeground, &values);
    values.foreground =
	WhitePixel((Display *) instance->display,
		   DefaultScreen((Display *) instance->display));
    white_gc =
	XCreateGC((Display *) instance->display,
		  (Drawable) instance->window, GCForeground, &values);

    PercentRedraw = FALSE;
    if (percent != -1 && instance->lastpercent != -1
	&& instance->lastpercent > percent)
	PercentRedraw = TRUE;
    if (instance->font == NULL) {
	FullRedraw = TRUE;
	Initialize((Display *) instance->display,
		   (Drawable) instance->window, instance, black_gc);
    }
    font_height =
	instance->font->max_bounds.ascent +
	instance->font->max_bounds.descent;
    id_width = XTextWidth(instance->font, id, strlen(id));

    if (FullRedraw || instance->window_height <= 80) {
	XFillRectangle((Display *) instance->display,
		       (Drawable) instance->window, white_gc, 0, 0,
		       instance->window_width, instance->window_height);
    } else {
	XFillRectangle((Display *) instance->display,
		       (Drawable) instance->window, white_gc, BORDER,
		       LOGO_HEIGHT, instance->window_width - BORDER * 2,
		       instance->window_height - font_height -
		       LOGO_HEIGHT - BORDER - 10);
    }

    if (instance->window_height > 80
	&& instance->window_width > id_width + BORDER * 2) {
	top = BORDER * 2 + LOGO_HEIGHT;
	loops = 0;
	if (FullRedraw) {
	    DrawLogo((Display *) instance->display,
		     (Drawable) instance->window, instance, black_gc);
	    XDrawString((Display *) instance->display,
			(Drawable) instance->window, black_gc,
			instance->window_width - id_width - BORDER,
			instance->window_height - font_height, id,
			strlen(id));
	}
	if ((FullRedraw || PercentRedraw)
	    && instance->window_width > id_width + BORDER * 3 + 100)
	    // The height is set to 11 (my value for font_height)
	    // since the progress image only has 11 pixels of space
	    DrawProgressBG((Display *) instance->display,
			   (Drawable) instance->window,
			   instance,
			   BORDER,
			   instance->window_height - font_height - BORDER,
			   instance->window_width - id_width - BORDER * 3,
			   11);


	// Loop a max of 10 times in case of problems (like too small of a width)
	while (strlen(message) != 0 && loops < 10) {
	    chop = 0;
	    term = 0;
	    while (XTextWidth
		   (instance->font, message,
		    strlen(message) - chop) + BORDER * 2 >
		   (int) instance->window_width)
		chop++;
	    if (strchr(message, '\n') != NULL &&
		(int) (strchr(message, '\n') - message) <
		(int) (strlen(message) - chop)) {
		chop = strlen(message) - (strchr(message, '\n') - message);
		term = 1;
	    }
	    XDrawString((Display *) instance->display,
			(Drawable) instance->window, black_gc, BORDER,
			top, message, strlen(message) - chop);
	    message += strlen(message) - chop + term;
	    top += font_height;
	    loops++;
	    if (top > (int) instance->window_height - font_height - BORDER)
		break;
	}

	// Make sure we have at least 100 px in addition to the id tag and borders
	if (percent != -1
	    && instance->window_width > id_width + BORDER * 3 + 100)
	    DrawProgress((Display *) instance->display,
			 (Drawable) instance->window,
			 instance,
			 BORDER,
			 instance->window_height - font_height - BORDER,
			 instance->window_width - id_width - BORDER * 3,
			 11, percent);
	else if (FullRedraw && instance->lastpercent != -1
		 && instance->window_width > id_width + BORDER * 3 + 100)
	    DrawProgress((Display *) instance->display,
			 (Drawable) instance->window,
			 instance,
			 BORDER,
			 instance->window_height - font_height - BORDER,
			 instance->window_width - id_width - BORDER * 3,
			 11, instance->lastpercent);

    } else {
	XDrawString((Display *) instance->display,
		    (Drawable) instance->window, black_gc, BORDER, 15,
		    message, strlen(message));
    }
    if (percent != -1)
	instance->lastpercent = percent;

    XFreeGC((Display *) instance->display, black_gc);
    XFreeGC((Display *) instance->display, white_gc);

    XFlush((Display *) instance->display);
    usleep(100);
#endif
}

void FreeUI(Display * dpy, nsPluginInstance * instance)
{
#ifdef X_ENABLED
    instance->font = NULL;
    // Free all the pixmaps used by the GUI
    if (instance->progress_left)
	XFreePixmap(dpy, instance->progress_left);
    if (instance->progress_leftmask)
	XFreePixmap(dpy, instance->progress_leftmask);
    if (instance->progress_middle)
	XFreePixmap(dpy, instance->progress_middle);
    if (instance->progress_middlemask)
	XFreePixmap(dpy, instance->progress_middlemask);
    if (instance->progress_right)
	XFreePixmap(dpy, instance->progress_right);
    if (instance->progress_rightmask)
	XFreePixmap(dpy, instance->progress_rightmask);
    if (instance->progress_fill)
	XFreePixmap(dpy, instance->progress_fill);
    if (instance->progress_fillmask)
	XFreePixmap(dpy, instance->progress_fillmask);
    if (instance->logo)
	XFreePixmap(dpy, instance->logo);
    if (instance->logomask)
	XFreePixmap(dpy, instance->logomask);
    // Don't free the font since we didn't create it
    instance->logo = (Pixmap) NULL;
    instance->logomask = (Pixmap) NULL;
    instance->progress_left = (Pixmap) NULL;
    instance->progress_leftmask = (Pixmap) NULL;
    instance->progress_middle = (Pixmap) NULL;
    instance->progress_middlemask = (Pixmap) NULL;
    instance->progress_right = (Pixmap) NULL;
    instance->progress_rightmask = (Pixmap) NULL;
    instance->progress_fill = (Pixmap) NULL;
    instance->progress_fillmask = (Pixmap) NULL;
#endif
}

void RedrawCB(Widget widget, XtPointer client_data, XtPointer call_data)
{
    char message[1024];

    nsPluginInstance *instance = (nsPluginInstance *) client_data;
    if (DEBUG)
	printf("redrawing window\n");

    if (instance->noredraw)
	return;

    if (instance != NULL) {
	if (instance->lastmessage != NULL) {
	    if (strlen(instance->lastmessage) != 0) {
		if (instance->state >= STATE_GETTING_PLAYLIST) {
		    strcpy(message, instance->lastmessage);
#ifdef X_ENABLED
		    DrawUI(instance->widget, instance, message, 1, -1);
#endif
		}
	    }
	}
    }
}

#ifdef GTK_ENABLED
void play_callback(GtkWidget * widget, GdkEventExpose * event,
		   nsPluginInstance * instance)
{
    if (DEBUG)
	printf("play clickd\n");

    if (instance == NULL)
	return;
    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {
	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->play_event_box),
			     instance->image_play);
	gtk_container_remove(GTK_CONTAINER(instance->pause_event_box),
			     instance->image_pause);
	gtk_container_remove(GTK_CONTAINER(instance->stop_event_box),
			     instance->image_stop);
#ifdef GTK2_ENABLED
	instance->image_play =
	    gtk_image_new_from_pixbuf(instance->pb_sm_play_down);
	instance->image_pause =
	    gtk_image_new_from_pixbuf(instance->pb_sm_pause_up);
	instance->image_stop =
	    gtk_image_new_from_pixbuf(instance->pb_sm_stop_up);
#endif
#ifdef GTK1_ENABLED
	instance->image_play =
	    gtk_pixmap_new(instance->pb_sm_play_down, NULL);
	instance->image_pause =
	    gtk_pixmap_new(instance->pb_sm_pause_up, NULL);
	instance->image_stop =
	    gtk_pixmap_new(instance->pb_sm_stop_up, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->play_event_box),
			  instance->image_play);
	gtk_container_add(GTK_CONTAINER(instance->pause_event_box),
			  instance->image_pause);
	gtk_container_add(GTK_CONTAINER(instance->stop_event_box),
			  instance->image_stop);
	gtk_widget_show(instance->image_play);
	gtk_widget_show(instance->image_pause);
	gtk_widget_show(instance->image_stop);

	gtk_widget_show(instance->play_event_box);
	gtk_widget_show(instance->pause_event_box);
	gtk_widget_show(instance->stop_event_box);

	gtk_widget_show(instance->fixed_container);
	gdk_flush();
    }
    if (widget != NULL)
	instance->Play();
}

void pause_callback(GtkWidget * widget, GdkEventExpose * event,
		    nsPluginInstance * instance)
{
    if (DEBUG)
	printf("pause clickd\n");

    if (instance == NULL)
	return;
    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {
	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->play_event_box),
			     instance->image_play);
	gtk_container_remove(GTK_CONTAINER(instance->pause_event_box),
			     instance->image_pause);
	gtk_container_remove(GTK_CONTAINER(instance->stop_event_box),
			     instance->image_stop);

#ifdef GTK2_ENABLED
	instance->image_play =
	    gtk_image_new_from_pixbuf(instance->pb_sm_play_up);
	instance->image_pause =
	    gtk_image_new_from_pixbuf(instance->pb_sm_pause_down);
	instance->image_stop =
	    gtk_image_new_from_pixbuf(instance->pb_sm_stop_up);
#endif
#ifdef GTK1_ENABLED
	instance->image_play =
	    gtk_pixmap_new(instance->pb_sm_play_up, NULL);
	instance->image_pause =
	    gtk_pixmap_new(instance->pb_sm_pause_down, NULL);
	instance->image_stop =
	    gtk_pixmap_new(instance->pb_sm_stop_up, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->play_event_box),
			  instance->image_play);
	gtk_container_add(GTK_CONTAINER(instance->pause_event_box),
			  instance->image_pause);
	gtk_container_add(GTK_CONTAINER(instance->stop_event_box),
			  instance->image_stop);

	gtk_widget_show(instance->image_play);
	gtk_widget_show(instance->image_pause);
	gtk_widget_show(instance->image_stop);

	gtk_widget_show(instance->play_event_box);
	gtk_widget_show(instance->pause_event_box);
	gtk_widget_show(instance->stop_event_box);

	gtk_widget_show(instance->fixed_container);
	gdk_flush();
    }
    if (widget != NULL)
	instance->Pause();
}

void stop_callback(GtkWidget * widget, GdkEventExpose * event,
		   nsPluginInstance * instance)
{
    if (DEBUG)
	printf("stop clickd\n");

    if (instance == NULL)
	return;
    if (instance->mInitialized == FALSE)
	return;
    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {
	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->play_event_box),
			     instance->image_play);
	gtk_container_remove(GTK_CONTAINER(instance->pause_event_box),
			     instance->image_pause);
	gtk_container_remove(GTK_CONTAINER(instance->stop_event_box),
			     instance->image_stop);

#ifdef GTK2_ENABLED
	instance->image_play =
	    gtk_image_new_from_pixbuf(instance->pb_sm_play_up);
	instance->image_pause =
	    gtk_image_new_from_pixbuf(instance->pb_sm_pause_up);
	instance->image_stop =
	    gtk_image_new_from_pixbuf(instance->pb_sm_stop_down);
#endif
#ifdef GTK1_ENABLED
	instance->image_play =
	    gtk_pixmap_new(instance->pb_sm_play_up, NULL);
	instance->image_pause =
	    gtk_pixmap_new(instance->pb_sm_pause_up, NULL);
	instance->image_stop =
	    gtk_pixmap_new(instance->pb_sm_stop_down, NULL);
#endif
	gtk_container_add(GTK_CONTAINER(instance->play_event_box),
			  instance->image_play);
	gtk_container_add(GTK_CONTAINER(instance->pause_event_box),
			  instance->image_pause);
	gtk_container_add(GTK_CONTAINER(instance->stop_event_box),
			  instance->image_stop);
	gtk_widget_show(instance->image_play);
	gtk_widget_show(instance->image_pause);
	gtk_widget_show(instance->image_stop);

	gtk_widget_show(instance->play_event_box);
	gtk_widget_show(instance->pause_event_box);
	gtk_widget_show(instance->stop_event_box);

	gtk_widget_show(instance->fixed_container);
	gtk_widget_hide(GTK_WIDGET(instance->progress_bar));
	gdk_flush();
    }
    if (widget != NULL)
	instance->Stop();

}

void ff_callback(GtkWidget * widget, GdkEventExpose * event,
		 nsPluginInstance * instance)
{
    if (instance == NULL)
	return;
    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {
	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->ff_event_box),
			     instance->image_ff);
#ifdef GTK2_ENABLED
	instance->image_ff =
	    gtk_image_new_from_pixbuf(instance->pb_sm_ff_down);
#endif
#ifdef GTK1_ENABLED
	instance->image_ff = gtk_pixmap_new(instance->pb_sm_ff_down, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->ff_event_box),
			  instance->image_ff);
	gtk_widget_show(instance->image_ff);
	gtk_widget_show(instance->ff_event_box);
	gdk_flush();
	instance->FastForward();
	usleep(500);

	gtk_container_remove(GTK_CONTAINER(instance->ff_event_box),
			     instance->image_ff);
#ifdef GTK2_ENABLED
	instance->image_ff =
	    gtk_image_new_from_pixbuf(instance->pb_sm_ff_up);
#endif
#ifdef GTK1_ENABLED
	instance->image_ff = gtk_pixmap_new(instance->pb_sm_ff_up, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->ff_event_box),
			  instance->image_ff);
	gtk_widget_show(instance->image_ff);
	gtk_widget_show(instance->ff_event_box);
    }

}

void rew_callback(GtkWidget * widget, GdkEventExpose * event,
		  nsPluginInstance * instance)
{
    if (instance == NULL)
	return;
    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {

	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->rew_event_box),
			     instance->image_rew);
#ifdef GTK2_ENABLED
	instance->image_rew =
	    gtk_image_new_from_pixbuf(instance->pb_sm_rew_down);
#endif
#ifdef GTK1_ENABLED
	instance->image_rew =
	    gtk_pixmap_new(instance->pb_sm_rew_down, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->rew_event_box),
			  instance->image_rew);
	gtk_widget_show(instance->image_rew);
	gtk_widget_show(instance->rew_event_box);
	gdk_flush();
	instance->FastReverse();
	usleep(500);

	gtk_container_remove(GTK_CONTAINER(instance->rew_event_box),
			     instance->image_rew);
#ifdef GTK2_ENABLED
	instance->image_rew =
	    gtk_image_new_from_pixbuf(instance->pb_sm_rew_up);
#endif
#ifdef GTK1_ENABLED
	instance->image_rew = gtk_pixmap_new(instance->pb_sm_rew_up, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(instance->rew_event_box),
			  instance->image_rew);
	gtk_widget_show(instance->image_rew);
	gtk_widget_show(instance->rew_event_box);
    }

}

void fs_callback(GtkWidget * widget, GdkEventExpose * event,
		 nsPluginInstance * instance)
{
    if (DEBUG)
	printf("pause clickd\n");
    if (instance == NULL)
	return;

    if (instance->panel_drawn == 0)
	return;
    if (instance->controlsvisible == 1) {
	if (instance->panel_height > 16)
	    instance->panel_height = 16;

	gtk_container_remove(GTK_CONTAINER(instance->fs_event_box),
			     instance->image_fs);

	if (instance->fullscreen) {
#ifdef GTK2_ENABLED
	    instance->image_fs =
		gtk_image_new_from_pixbuf(instance->pb_sm_fs_up);
#endif
#ifdef GTK1_ENABLED
	    instance->image_fs =
		gtk_pixmap_new(instance->pb_sm_fs_up, NULL);
#endif
	} else {
#ifdef GTK2_ENABLED
	    instance->image_fs =
		gtk_image_new_from_pixbuf(instance->pb_sm_fs_down);
#endif
#ifdef GTK1_ENABLED
	    instance->image_fs =
		gtk_pixmap_new(instance->pb_sm_fs_down, NULL);
#endif


	}
	gtk_container_add(GTK_CONTAINER(instance->fs_event_box),
			  instance->image_fs);

	gtk_widget_show(instance->image_fs);
	gtk_widget_show(instance->fs_event_box);
	gtk_widget_show(instance->fixed_container);
	gdk_flush();
    }
    if (widget != NULL)
	instance->SetFullscreen(!instance->fullscreen);
}



gboolean gtkgui_draw(void *data)
{
    nsPluginInstance *instance;

    instance = (nsPluginInstance *) data;

    int width, height;
    int multiplier;
    int win_height, win_width;

    if (instance == NULL)
	return FALSE;
    if (DEBUG > 1)
	printf("panel_height = %i\nDrawn = %i", instance->panel_height,
	       instance->panel_drawn);

    if (instance->mode == NP_EMBED && instance->window == 0)
	return FALSE;

    if (instance->mode == NP_EMBED) {
	win_height = instance->embed_height;
	win_width = instance->embed_width;
    } else {
	win_height = instance->window_height;
	win_width = instance->window_width;
    }

    if (instance->panel_drawn == 0) {
	if (instance->mode == NP_FULL)
	    instance->panel_height = instance->window_height;
	if (instance->panel_height > 16)
	    instance->panel_height = 16;
	if (instance->panel_height < 0)
	    instance->panel_height = 0;
	if (DEBUG > 1)
	    printf("drawing panel\n height = %i panel= %i\n",
		   win_height, instance->panel_height);
	if (instance->panel_height > 0 && instance->showcontrols == 1) {
#ifdef GTK2_ENABLED
	    if (instance->autostart) {
		instance->image_play =
		    gtk_image_new_from_pixbuf(instance->pb_sm_play_down);
	    } else {
		instance->image_play =
		    gtk_image_new_from_pixbuf(instance->pb_sm_play_up);
	    }
	    instance->image_pause =
		gtk_image_new_from_pixbuf(instance->pb_sm_pause_up);
	    instance->image_stop =
		gtk_image_new_from_pixbuf(instance->pb_sm_stop_up);
	    instance->image_ff =
		gtk_image_new_from_pixbuf(instance->pb_sm_ff_up);
	    instance->image_rew =
		gtk_image_new_from_pixbuf(instance->pb_sm_rew_up);
	    instance->image_fs =
		gtk_image_new_from_pixbuf(instance->pb_sm_fs_up);
#endif
#ifdef GTK1_ENABLED
	    if (instance->autostart) {
		instance->image_play =
		    gtk_pixmap_new(instance->pb_sm_play_down, NULL);
	    } else {
		instance->image_play =
		    gtk_pixmap_new(instance->pb_sm_play_up, NULL);
	    }
	    instance->image_pause =
		gtk_pixmap_new(instance->pb_sm_pause_up, NULL);
	    instance->image_stop =
		gtk_pixmap_new(instance->pb_sm_stop_up, NULL);
	    instance->image_ff =
		gtk_pixmap_new(instance->pb_sm_ff_up, NULL);
	    instance->image_rew =
		gtk_pixmap_new(instance->pb_sm_rew_up, NULL);
	    instance->image_fs =
		gtk_pixmap_new(instance->pb_sm_fs_up, NULL);
#endif
	    width = SMALL_BUTTON_WIDTH;
	    height = SMALL_BUTTON_HEIGHT;

	    multiplier = 0;
	    // rewind
	    if (instance->mmsstream == 0) {
		instance->rew_event_box = gtk_event_box_new();
		gtk_widget_set_events(instance->rew_event_box,
				      GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
		g_signal_connect(G_OBJECT(instance->rew_event_box),
				 "button_press_event",
				 G_CALLBACK(rew_callback), instance);
#endif
#ifdef GTK1_ENABLED
		gtk_signal_connect(GTK_OBJECT(instance->rew_event_box),
				   "button_press_event",
				   GTK_SIGNAL_FUNC(rew_callback),
				   instance);
#endif
		gtk_container_add(GTK_CONTAINER(instance->rew_event_box),
				  instance->image_rew);
		gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			      instance->rew_event_box,
			      width * multiplier++, win_height - height);
		gtk_widget_show(instance->image_rew);
		gtk_widget_show(instance->rew_event_box);
	    }
	    // play
	    instance->play_event_box = gtk_event_box_new();
	    gtk_widget_set_events(instance->play_event_box,
				  GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
	    g_signal_connect(G_OBJECT(instance->play_event_box),
			     "button_press_event",
			     G_CALLBACK(play_callback), instance);
#endif
#ifdef GTK1_ENABLED
	    gtk_signal_connect(GTK_OBJECT(instance->play_event_box),
			       "button_press_event",
			       GTK_SIGNAL_FUNC(play_callback), instance);
#endif
	    gtk_container_add(GTK_CONTAINER(instance->play_event_box),
			      instance->image_play);
	    gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			  instance->play_event_box, width * multiplier++,
			  win_height - height);
	    gtk_widget_show(instance->image_play);
	    gtk_widget_show(instance->play_event_box);

	    // pause
	    instance->pause_event_box = gtk_event_box_new();
	    gtk_widget_set_events(instance->pause_event_box,
				  GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
	    g_signal_connect(G_OBJECT(instance->pause_event_box),
			     "button_press_event",
			     G_CALLBACK(pause_callback), instance);
#endif
#ifdef GTK1_ENABLED
	    gtk_signal_connect(GTK_OBJECT(instance->pause_event_box),
			       "button_press_event",
			       GTK_SIGNAL_FUNC(pause_callback), instance);
#endif
	    gtk_container_add(GTK_CONTAINER(instance->pause_event_box),
			      instance->image_pause);
	    gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			  instance->pause_event_box, width * multiplier++,
			  win_height - height);
	    gtk_widget_show(instance->image_pause);
	    gtk_widget_show(instance->pause_event_box);

	    // stop
	    instance->stop_event_box = gtk_event_box_new();
	    gtk_widget_set_events(instance->stop_event_box,
				  GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
	    g_signal_connect(G_OBJECT(instance->stop_event_box),
			     "button_press_event",
			     G_CALLBACK(stop_callback), instance);
#endif
#ifdef GTK1_ENABLED
	    gtk_signal_connect(GTK_OBJECT(instance->stop_event_box),
			       "button_press_event",
			       GTK_SIGNAL_FUNC(stop_callback), instance);
#endif
	    gtk_container_add(GTK_CONTAINER(instance->stop_event_box),
			      instance->image_stop);
	    gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			  instance->stop_event_box, width * multiplier++,
			  win_height - height);
	    gtk_widget_show(instance->image_stop);
	    gtk_widget_show(instance->stop_event_box);

	    // fastforward
	    if (instance->mmsstream == 0) {
		instance->ff_event_box = gtk_event_box_new();
		gtk_widget_set_events(instance->ff_event_box,
				      GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
		g_signal_connect(G_OBJECT(instance->ff_event_box),
				 "button_press_event",
				 G_CALLBACK(ff_callback), instance);
#endif
#ifdef GTK1_ENABLED
		gtk_signal_connect(GTK_OBJECT(instance->ff_event_box),
				   "button_press_event",
				   GTK_SIGNAL_FUNC(ff_callback), instance);
#endif
		gtk_container_add(GTK_CONTAINER(instance->ff_event_box),
				  instance->image_ff);
		gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			      instance->ff_event_box, width * multiplier++,
			      win_height - height);
		gtk_widget_show(instance->image_ff);
		gtk_widget_show(instance->ff_event_box);
	    }

	    if ((int) (width * multiplier + 10) <
		(int) (win_width - 10 - width)) {
		instance->mediaprogress_bar =
		    GTK_PROGRESS_BAR(gtk_progress_bar_new());
		gtk_widget_set_usize(GTK_WIDGET
				     (instance->mediaprogress_bar),
				     (win_width -
				      width * multiplier - 20 - width),
				     height - 4);
		gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			      GTK_WIDGET(instance->mediaprogress_bar),
			      (width * multiplier + 10),
			      win_height - height + 2);
	    }

	    if (instance->mode == NP_EMBED && instance->noembed == 0)
		gtk_widget_hide(GTK_WIDGET(instance->progress_bar));

	    // fullscreen
	    instance->fs_event_box = gtk_event_box_new();
	    gtk_widget_set_events(instance->fs_event_box,
				  GDK_BUTTON_PRESS_MASK);
#ifdef GTK2_ENABLED
	    g_signal_connect(G_OBJECT(instance->fs_event_box),
			     "button_press_event",
			     G_CALLBACK(fs_callback), instance);
#endif
#ifdef GTK1_ENABLED
	    gtk_signal_connect(GTK_OBJECT(instance->fs_event_box),
			       "button_press_event",
			       GTK_SIGNAL_FUNC(fs_callback), instance);
#endif
	    gtk_container_add(GTK_CONTAINER(instance->fs_event_box),
			      instance->image_fs);
	    gtk_fixed_put(GTK_FIXED(instance->fixed_container),
			  instance->fs_event_box,
			  win_width - width, win_height - height);
	    gtk_widget_show(instance->image_fs);
	    gtk_widget_show(instance->fs_event_box);

	    gtk_widget_show(instance->fixed_container);
	    gtk_widget_show(instance->gtkwidget);

	    instance->controlsvisible = 1;
	    instance->panel_drawn = 1;
	}
    }

    return FALSE;
}

gboolean gtkgui_message(void *data)
{
    nsPluginInstance *instance;

    if (DEBUG > 1)
	printf("in gtkgui_message\n");

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;
    if (instance->status != NULL && instance->lastmessage != NULL)
	gtk_label_set_text(instance->status, instance->lastmessage);
    return FALSE;
}

gboolean gtkgui_progress(void *data)
{
    nsPluginInstance *instance;

    if (DEBUG > 1)
	printf("in gtkgui_progress\n");

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->progress_bar != NULL) {
	if ((instance->percent > 0.0) && (instance->percent < 1.0)) {
	    if (instance->movie_height == 0 && instance->movie_width == 0)
		gtk_widget_show(GTK_WIDGET(instance->progress_bar));
	    gtk_progress_bar_update(instance->progress_bar,
				    instance->percent);
	}
	if (instance->percent >= 0.99 || instance->percent == 0)
	    gtk_widget_hide(GTK_WIDGET(instance->progress_bar));
    }
    return FALSE;
}

gboolean gtkgui_resize(void *data)
{
    nsPluginInstance *instance;

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;

    if (DEBUG > 1)
	printf("in resize method\nNew size is %i x %i\n",
	       instance->movie_width, instance->movie_height);
    if (instance->drawing_area != NULL) {
	gtk_widget_set_usize(instance->drawing_area,
			     instance->movie_width,
			     instance->movie_height);
	gtk_widget_hide(GTK_WIDGET(instance->progress_bar));
	if (instance->mode == NP_FULL)
	    if ((instance->movie_width + 10 >= instance->window_width)
		|| (instance->movie_height + 100 >=
		    instance->window_height))
		if (instance->fullscreen == 0)
		    gtk_fixed_put(GTK_FIXED(instance->fixed_container),
				  instance->drawing_area, 0, 0);
    }
    return FALSE;

}

gboolean gtkgui_stop(void *data)
{
    nsPluginInstance *instance;

    if (DEBUG > 1)
	printf("in gtkgui_stop\n");

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;
    stop_callback(NULL, NULL, instance);
    instance->SetFullscreen(0);
    if (DEBUG > 1)
	printf("completed gtkgui_stop\n");

    return FALSE;
}

gboolean gtkgui_save_enable(void *data)
{
    nsPluginInstance *instance;
#ifdef GTK2_ENABLED
    char *filename;
    char newlabel[1024];
    GtkLabel *label;
#endif
    if (DEBUG > 1)
	printf("in gtkgui_save_enable\n");

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;
    if (instance->currentnode == NULL)
	return FALSE;
    if (instance->js_state != JS_STATE_PLAYING)
	return FALSE;

    if (!isMms(instance->currentnode->url)) {
	pthread_mutex_lock(&(instance->playlist_mutex));
	if (DEBUG > 1)
	    printf("Save Enable called retrieved = %i\n",
		   instance->currentnode->retrieved);
#ifdef GTK2_ENABLED
	filename = getURLFilename(instance->currentnode->url);
	if (filename != NULL) {
	    snprintf(newlabel, 1024, "Save as %s/%s",
		     instance->download_dir, filename);
	    NPN_MemFree(filename);

	} else {
	    snprintf(newlabel, 1024, "Save");
	}

	label =
	    GTK_LABEL(gtk_bin_get_child(GTK_BIN(instance->menuitem_save)));
	gtk_label_set_text(label, newlabel);
#endif
	pthread_mutex_unlock(&(instance->playlist_mutex));
	gtk_widget_set_sensitive(GTK_WIDGET(instance->menuitem_save),
				 instance->currentnode->retrieved);
    } else {
	gtk_widget_set_sensitive(GTK_WIDGET(instance->menuitem_save),
				 FALSE);
    }
    return FALSE;
}


gboolean gtkgui_drawMediaProgress(void *data)
{
    nsPluginInstance *instance;

    if (DEBUG > 1)
	printf("in drawMediaProgress method\n");

    instance = (nsPluginInstance *) data;
    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;
    if (instance->mediaprogress_bar != NULL) {
	if ((instance->mediaPercent > 0)
	    && (instance->mediaPercent <= 100)) {
	    if (instance->controlsvisible)
		gtk_widget_show(GTK_WIDGET(instance->mediaprogress_bar));
	    gtk_progress_bar_update(instance->mediaprogress_bar,
				    instance->mediaPercent / 100.0);
	} else {
	    gtk_widget_hide(GTK_WIDGET(instance->mediaprogress_bar));
	}
    }

    return FALSE;
}

gboolean gtkgui_updatebuttons(void *data)
{
    nsPluginInstance *instance;
    int height, width, multiplier;
    int win_height, win_width;

    if (DEBUG > 1)
	printf("in drawMediaProgress method\n");

    instance = (nsPluginInstance *) data;

    if (instance == NULL)
	return FALSE;
    if (instance->mInitialized == FALSE)
	return FALSE;

    if (instance->mode == NP_EMBED) {
	win_height = instance->embed_height;
	win_width = instance->embed_width;
    } else {
	win_height = instance->window_height;
	win_width = instance->window_width;
    }

    if (instance->panel_drawn == 1) {
	height = 16;
	width = 21;

	multiplier = 0;

	if (instance->mmsstream == 0) {
	    if (instance->rew_event_box != NULL) {
		if (instance->showcontrols)
		    gtk_widget_show(GTK_WIDGET(instance->rew_event_box));
		gtk_fixed_move(GTK_FIXED(instance->fixed_container),
			       GTK_WIDGET(instance->rew_event_box),
			       width * multiplier++,
			       instance->embed_height - height);
	    }
	} else {
	    gtk_widget_hide(GTK_WIDGET(instance->rew_event_box));
	}
	gtk_fixed_move(GTK_FIXED(instance->fixed_container),
		       GTK_WIDGET(instance->play_event_box),
		       width * multiplier++, win_height - height);
	gtk_fixed_move(GTK_FIXED(instance->fixed_container),
		       GTK_WIDGET(instance->pause_event_box),
		       width * multiplier++, win_height - height);
	gtk_fixed_move(GTK_FIXED(instance->fixed_container),
		       GTK_WIDGET(instance->stop_event_box),
		       width * multiplier++, win_height - height);
	if (instance->mmsstream == 0) {
	    if (instance->ff_event_box != NULL) {
		if (instance->showcontrols)
		    gtk_widget_show(GTK_WIDGET(instance->rew_event_box));
		gtk_fixed_move(GTK_FIXED(instance->fixed_container),
			       GTK_WIDGET(instance->ff_event_box),
			       width * multiplier++, win_height - height);
	    }
	} else {
	    gtk_widget_hide(GTK_WIDGET(instance->ff_event_box));
	}
	gtk_fixed_move(GTK_FIXED(instance->fixed_container),
		       GTK_WIDGET(instance->mediaprogress_bar),
		       (width * multiplier + 10), win_height - height + 2);
	gtk_fixed_move(GTK_FIXED(instance->fixed_container),
		       GTK_WIDGET(instance->fs_event_box),
		       (win_width - width), win_height - height + 2);

	gtk_widget_set_usize(GTK_WIDGET(instance->mediaprogress_bar),
			     win_width - (width * (multiplier + 1) + 20),
			     height - 4);

    }
    return FALSE;
}


gint popup_handler(GtkWidget * widget, GdkEvent * event)
{
    GtkMenu *menu;
    GdkEventButton *event_button;

    if (DEBUG)
	printf("popup menu callback\n");

    menu = GTK_MENU(widget);
    if (DEBUG)
	printf("event type # %i\n", event->type);
    if (event->type == GDK_BUTTON_PRESS) {
	event_button = (GdkEventButton *) event;
	if (DEBUG)
	    printf("button press # %i\n", event_button->button);
	if (event_button->button == 3) {
	    gtk_menu_popup(menu, NULL, NULL, NULL, NULL,
			   event_button->button, event_button->time);
	    return TRUE;
	}
    }
    return FALSE;
}

void menuitem_play_callback(GtkMenuItem * menuitem,
			    nsPluginInstance * instance)
{
    play_callback(GTK_WIDGET(menuitem), NULL, instance);
}

void menuitem_pause_callback(GtkMenuItem * menuitem,
			     nsPluginInstance * instance)
{
    pause_callback(GTK_WIDGET(menuitem), NULL, instance);
}

void menuitem_stop_callback(GtkMenuItem * menuitem,
			    nsPluginInstance * instance)
{
    stop_callback(GTK_WIDGET(menuitem), NULL, instance);
}

void menuitem_showcontrols_callback(GtkCheckMenuItem * menuitem,
				    nsPluginInstance * instance)
{
#ifdef GTK2_ENABLED
    instance->SetShowControls(gtk_check_menu_item_get_active(menuitem));
#endif
#ifdef GTK1_ENABLED
    instance->SetShowControls(menuitem->active);
#endif
}

void menuitem_fullscreen_callback(GtkCheckMenuItem * menuitem,
				  nsPluginInstance * instance)
{
#ifdef GTK2_ENABLED
    instance->SetFullscreen(gtk_check_menu_item_get_active(menuitem));
#endif
#ifdef GTK1_ENABLED
    instance->SetFullscreen(menuitem->active);
#endif

}

void menuitem_save_callback(GtkCheckMenuItem * menuitem,
			    nsPluginInstance * instance)
{
    char *filename;
    char newname[1024];
    Node *n, *lastplayed;

    if (instance->mInitialized == FALSE)
	return;
    pthread_mutex_lock(&(instance->playlist_mutex));

    lastplayed = NULL;

    if (instance->currentnode != NULL) {
	lastplayed = instance->currentnode;
    } else {
	n = instance->list;
	while (n != NULL) {
	    if (n->played == 1)
		lastplayed = n;
	    n = n->next;
	}
    }

    if (lastplayed != NULL) {
	filename = getURLFilename(lastplayed->url);
	if (filename) {
	    if (lastplayed->retrieved == 1) {
		snprintf(newname, 1024, "%s/%s",
			 instance->download_dir, filename);
		rename(lastplayed->fname, newname);
		snprintf(lastplayed->fname, 1024, "%s/%s",
			 instance->download_dir, filename);
		lastplayed->remove = 0;
	    }
	    NPN_MemFree(filename);
	}
    }
    pthread_mutex_unlock(&(instance->playlist_mutex));
}



#endif
