#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 07 August 2008 15:26:17 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon2_net.py,v 1.5 2008/08/08 01:35:56 vareille Exp $
#
# $Id: cartoon2_net.py,v 1.5 2008/08/08 01:35:56 vareille Exp $
#

from traceback import print_exc

## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_50 = Filelist(constrkw={}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_50,15,8)
    Filelist_50.inputPortByName['match_str'].widget.set("cartoonMovie/*.png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_50.configure(function=code)
    apply(Filelist_50.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_50=None

try:
    ## saving node len ##
    from Vision.StandardNodes import Len
    len_51 = Len(constrkw={}, name='len', library=stdlib)
    masterNet.addNode(len_51,58,117)
    apply(len_51.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Len named len in network masterNet"
    print_exc()
    len_51=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_52 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_52,15,342)
    apply(Read_Image_52.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_52.inputPortByName['filename'].rebindWidget()
    Read_Image_52.inputPortByName['filename'].widget.set("", run=False)
    Read_Image_52.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_52=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_53 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_53,15,390)
    Scale_53.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_53.inputPortByName['filter'].widget.set("NEAREST", run=False)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_53=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_54 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_54,15,445)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_54=None

try:
    ## saving node sub ##
    from Vision.StandardNodes import Operator2
    sub_55 = Operator2(constrkw={}, name='sub', library=stdlib)
    masterNet.addNode(sub_55,183,88)
    sub_55.inputPortByName['operation'].widget.set("sub", run=False)
    sub_55.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(sub_55.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Operator2 named sub in network masterNet"
    print_exc()
    sub_55=None

try:
    ## saving node ThumbWheelInt ##
    from Vision.StandardNodes import ThumbWheelIntNE
    ThumbWheelInt_57 = ThumbWheelIntNE(constrkw={}, name='ThumbWheelInt', library=stdlib)
    masterNet.addNode(ThumbWheelInt_57,122,189)
    apply(ThumbWheelInt_57.inputPortByName['thumbwheel'].widget.configure, (), {'max': 100, 'oneTurn': 30.0, 'min': 0})
    ThumbWheelInt_57.inputPortByName['thumbwheel'].widget.set(96, run=False)
    apply(ThumbWheelInt_57.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ThumbWheelIntNE named ThumbWheelInt in network masterNet"
    print_exc()
    ThumbWheelInt_57=None

try:
    ## saving node DialInt ##
    from Vision.StandardNodes import DialIntNE
    DialInt_58 = DialIntNE(constrkw={}, name='DialInt', library=stdlib)
    masterNet.addNode(DialInt_58,719,121)
    DialInt_58.inputPortByName['dial'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore DialIntNE named DialInt in network masterNet"
    print_exc()
    DialInt_58=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_59 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_59,15,284)
    Index_59.inputPortByName['index'].rebindWidget()
    Index_59.inputPortByName['index'].widget.set(0, run=False)
    Index_59.inputPortByName['index'].unbindWidget()
    apply(Index_59.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_59=None

try:
    ## saving node eval: 1 ##
    from Vision.StandardNodes import Eval
    eval__1_60 = Eval(constrkw={}, name='eval: 1', library=stdlib)
    masterNet.addNode(eval__1_60,272,20)
    eval__1_60.inputPortByName['command'].widget.set("1", run=False)
    eval__1_60.inputPortByName['importString'].widget.set("", run=False)
    apply(eval__1_60.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Eval named eval: 1 in network masterNet"
    print_exc()
    eval__1_60=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon210 ##
if Filelist_50 is not None and len_51 is not None:
    try:
        masterNet.connectNodes(
            Filelist_50, len_51, "filelist", "in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_50 and len_51 in network masterNet"
if Read_Image_52 is not None and Scale_53 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_52, Scale_53, "image", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Image_52 and Scale_53 in network masterNet"
if Scale_53 is not None and Show_Image_54 is not None:
    try:
        masterNet.connectNodes(
            Scale_53, Show_Image_54, "scaledImage", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Scale_53 and Show_Image_54 in network masterNet"
if len_51 is not None and sub_55 is not None:
    try:
        masterNet.connectNodes(
            len_51, sub_55, "length", "data1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between len_51 and sub_55 in network masterNet"
if ThumbWheelInt_57 is not None and Index_59 is not None:
    try:
        masterNet.connectNodes(
            ThumbWheelInt_57, Index_59, "value", "index", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ThumbWheelInt_57 and Index_59 in network masterNet"
if Filelist_50 is not None and Index_59 is not None:
    try:
        masterNet.connectNodes(
            Filelist_50, Index_59, "filelist", "data", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_50 and Index_59 in network masterNet"
if Index_59 is not None and Read_Image_52 is not None:
    try:
        masterNet.connectNodes(
            Index_59, Read_Image_52, "data", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Index_59 and Read_Image_52 in network masterNet"
if sub_55 is not None and ThumbWheelInt_57 is not None:
    try:
        masterNet.connectNodes(
            sub_55, ThumbWheelInt_57, "result", "maxi", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between sub_55 and ThumbWheelInt_57 in network masterNet"
if eval__1_60 is not None and sub_55 is not None:
    try:
        masterNet.connectNodes(
            eval__1_60, sub_55, "result", "data2", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between eval__1_60 and sub_55 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

