/*
  Copyright 2002-2003 The University of Texas at Austin
  
	Authors: Anthony Thane <thanea@ices.utexas.edu>
	Advisor: Chandrajit Bajaj <bajaj@cs.utexas.edu>

  This file is part of Volume Rover.

  Volume Rover is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Volume Rover is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Volume Rover; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOOKUPTABLES_H
#define LOOKUPTABLES_H

/** Lookup tables for calculating the intersection between a
 *  plane and a cube.
 */


// the coordinates for each of the eight verts of the cube
static double VertCoords[8*3] = 
{
	-0.5, -0.5, -0.5,
	 0.5, -0.5, -0.5,
	-0.5,  0.5, -0.5,
	 0.5,  0.5, -0.5,
	-0.5, -0.5,  0.5,
	 0.5, -0.5,  0.5,
	-0.5,  0.5,  0.5,
	 0.5,  0.5,  0.5,
};

// the texture coordinates for each of the eight verts of the cube
static double TexCoords[8*3] = 
{
	 0.0,  0.0,  0.0,
	 1.0,  0.0,  0.0,
	 0.0,  1.0,  0.0,
	 1.0,  1.0,  0.0,
	 0.0,  0.0,  1.0,
	 1.0,  0.0,  1.0,
	 0.0,  1.0,  1.0,
	 1.0,  1.0,  1.0
};

// the indices of the vertices for each edge of the cube
static unsigned int Edges[12*2] =
{
	0,1,
	1,3,
	3,2,
	2,0,

	4,5,
	5,7,
	7,6,
	6,4,
	
	0,4,
	1,5,
	3,7,
	2,6
};

// I'll explain later...
static unsigned int EdgeCases[256][7] = 
{
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 3, 3, 0, 8, 0, 0, 0 },
	{ 3, 1, 0, 9, 0, 0, 0 },
	{ 4, 3, 1, 9, 8, 0, 0 },
	{ 3, 2, 11, 3, 0, 0, 0 },
	{ 4, 2, 11, 8, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 8, 11, 2, 1, 9, 0 },
	{ 3, 2, 10, 1, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 10, 9, 0, 0, 0 },
	{ 5, 9, 10, 2, 3, 8, 0 },
	{ 4, 10, 11, 3, 1, 0, 0 },
	{ 5, 8, 11, 10, 1, 0, 0 },
	{ 5, 9, 10, 11, 3, 0, 0 },
	{ 4, 10, 11, 8, 9, 0, 0 },
	{ 3, 7, 4, 8, 0, 0, 0 },
	{ 4, 3, 7, 4, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 7, 3, 1, 9, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 11, 7, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 6, 1, 9, 4, 7, 11, 2 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 9, 10, 11, 7, 4, 0 },
	{ 3, 5, 9, 4, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 1, 5, 4, 0, 0, 0 },
	{ 5, 3, 1, 5, 4, 8, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 10, 5, 4, 0 },
	{ 6, 3, 8, 4, 5, 10, 2 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 8, 11, 10, 5, 4, 0 },
	{ 4, 5, 7, 8, 9, 0, 0 },
	{ 5, 5, 7, 3, 0, 9, 0 },
	{ 5, 1, 5, 7, 8, 0, 0 },
	{ 4, 3, 1, 5, 7, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 1, 5, 7, 11, 2, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 5, 7, 3, 2, 10, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 10, 11, 7, 5, 0, 0 },
	{ 3, 6, 11, 7, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 6, 7, 3, 0, 0 },
	{ 5, 0, 2, 6, 7, 8, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 7, 3, 1, 10, 6, 0 },
	{ 6, 1, 0, 8, 7, 6, 10 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 9, 10, 6, 7, 8, 0 },
	{ 4, 6, 11, 8, 4, 0, 0 },
	{ 5, 4, 6, 11, 3, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 2, 3, 8, 0 },
	{ 4, 2, 6, 4, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 2, 1, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 10, 1, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 10, 6, 4, 9, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 8, 11, 6, 5, 9, 0 },
	{ 6, 3, 0, 9, 5, 6, 11 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 3, 1, 5, 6, 11, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 6, 5, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 6, 5, 1, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 3, 10, 6, 5, 0, 0, 0 },
	{ 3, 10, 6, 5, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 6, 5, 1, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 6, 5, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 3, 1, 5, 6, 11, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 6, 3, 0, 9, 5, 6, 11 },
	{ 5, 8, 11, 6, 5, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 10, 6, 4, 9, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 10, 1, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 2, 1, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 6, 4, 0, 0, 0 },
	{ 5, 4, 6, 2, 3, 8, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 4, 6, 11, 3, 0, 0 },
	{ 4, 6, 11, 8, 4, 0, 0 },
	{ 5, 9, 10, 6, 7, 8, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 6, 1, 0, 8, 7, 6, 10 },
	{ 5, 7, 3, 1, 10, 6, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 6, 7, 8, 0 },
	{ 4, 2, 6, 7, 3, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 3, 6, 11, 7, 0, 0, 0 },
	{ 4, 10, 11, 7, 5, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 5, 7, 3, 2, 10, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 1, 5, 7, 11, 2, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 3, 1, 5, 7, 0, 0 },
	{ 5, 1, 5, 7, 8, 0, 0 },
	{ 5, 5, 7, 3, 0, 9, 0 },
	{ 4, 5, 7, 8, 9, 0, 0 },
	{ 5, 8, 11, 10, 5, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 6, 3, 8, 4, 5, 10, 2 },
	{ 5, 0, 2, 10, 5, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 3, 1, 5, 4, 8, 0 },
	{ 4, 1, 5, 4, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 3, 5, 9, 4, 0, 0, 0 },
	{ 5, 9, 10, 11, 7, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 6, 1, 9, 4, 7, 11, 2 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 0, 2, 11, 7, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 5, 7, 3, 1, 9, 4, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 3, 7, 4, 0, 0, 0 },
	{ 3, 7, 4, 8, 0, 0, 0 },
	{ 4, 10, 11, 8, 9, 0, 0 },
	{ 5, 9, 10, 11, 3, 0, 0 },
	{ 5, 8, 11, 10, 1, 0, 0 },
	{ 4, 10, 11, 3, 1, 0, 0 },
	{ 5, 9, 10, 2, 3, 8, 0 },
	{ 4, 2, 10, 9, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 3, 2, 10, 1, 0, 0, 0 },
	{ 5, 8, 11, 2, 1, 9, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 },
	{ 4, 2, 11, 8, 0, 0, 0 },
	{ 3, 2, 11, 3, 0, 0, 0 },
	{ 4, 3, 1, 9, 8, 0, 0 },
	{ 3, 1, 0, 9, 0, 0, 0 },
	{ 3, 3, 0, 8, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0 }
};

#endif
