/* SVN FILE: $Id$ */
/**
* Project Name : ManDVD
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/
/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.


	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA   02110-1301

	see: http://www.fsf.org/licensing/licenses/gpl-howto.html
*/

/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org (2008)
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/

#include "mandvd_global.h"

void mainfrm::init()
{
    QDir currentDir = QDir::home();
    lockfile = currentDir.path() + QDir::separator() + ".mandvd/.run";
    QFile run(lockfile);

    if (!run.exists()) {

	m_pMPlayerWidget = new QMPlayerWidget(vframe, "MPlayerWidget");
	m_pMPlayerLayout =
	    new QGridLayout(vframe, 1, 1, 4, 6, "MPlayerMainLayout");
	m_pMPlayerLayout->addWidget(m_pMPlayerWidget, 0, 0);

	vframe->setGeometry(31, 125, 115, 71);
	vframe->hide();
	newproj->hide();
	importSubs->hide();

	QString myrec;
	QFile myfic(currentDir.path() + CONFIGFILE);

	if (myfic.open(IO_ReadOnly)) {
	    QTextStream mystream(&myfic);
	    myrec = mystream.readLine();
	    wlanguage = myrec;
	    myfic.close();
	    rc_003 = 0;

	    /* Setup language for interface: mandvdrc exist! */
	    bt_valid_langue_clicked();

	} else {
	    /* Show language selection dialog */
	    rc_003 = 1;
	    combolangue->insertItem("Dutch", -1);
	    combolangue->insertItem("English", -1);
	    combolangue->insertItem("French", -1);
	    combolangue->insertItem("German", -1);
	    combolangue->insertItem("Italian", -1);
	    combolangue->insertItem("Spanish", -1);
	    combolangue->insertItem("Swedish", -1);
	    combolangue->insertItem("Portugugs", -1);

	    combolangue->setCurrentItem(0);
	    parametrage->setGeometry(290, 260, 421, 221);

	    /* Hide main program before language i choosen */
	    Etape_03->hide();
	    vframe->hide();
	    Etape_02->hide();

	    parametrage->show();
	    parametrage->raise();
	}
    } else {
	QMessageBox::warning(this, MANDVDVER,
			     tr
			     ("Program seams to running!\n\nElse please remove lockfile .run in .mandvd/ directory"));
	exit(0);
    }
}
