/* SVN FILE: $Id$ */
/**
* Project Name : Project Description
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/

// C++ Implementation: mandvd
//
// Description: Generic functions for ManDVD interface functions
//
// Author  : Gibault Stphane
// Modifier: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <effects.h>
#include <mainfrm.h>

void mainfrm::toolButton115_clicked()
{
    cadredit->hide();
    groupBox13->hide();
    QTime nowtime;
    nowtime = QTime::currentTime();
    tmp_009 =
	wpathtotalproj + "GIBtmpphoto_" + nowtime.toString("hh:mm:ss") +
	".png";
    QImage myimg = pixmapLabel1_3->pixmap()->convertToImage();
    myimg.save(tmp_009, "PNG");
    table_images[num_photo->value() - 1][0] = tmp_009;
    QLabel *pntloc = table_pnt_img[num_photo->value() - 1];
    QPixmap pixloc;
    pixloc.load(tmp_009);
    QImage tmptransf = pixloc.convertToImage();
    myimg = tmptransf.scale(320, 256, QImage::ScaleMax);
    pntloc->setPixmap(myimg);
    apercu_photo_diapo->setPixmap(myimg);
    fen_slideshow->setEnabled(true);
}

void mainfrm::toolButton115_2_clicked()
{
    cadredit->hide();
    groupBox13->hide();
    fen_slideshow->setEnabled(true);
}

void mainfrm::toolButton117_clicked()
{
    QColor couleur_10 =
	QColorDialog::getColor(couleur_10, this, table_message[71]);
    if (couleur_10.isValid()) {
	fdcolor->setPaletteBackgroundColor(couleur_10);
	wlanguage = "";
	calculcadre();
    }
}

void mainfrm::outils1_2_clicked()
{
    editmask->setDisabled(true);
    addtxt2mask->setGeometry(300, 230, 400, 240);
    addtxt2mask->show();
    addtxt2mask->raise();
    lineEdit13->setFocus();
}

void mainfrm::toolButton120_clicked()
{
    if (lineEdit13->text() != "") {
	addtxt2mask->hide();
	editmask->setEnabled(true);
	QIconSet wl_icoset = outils1_2->iconSet();
	pixmapLabel1_5->setPixmap(wl_icoset.pixmap());
	rc_003 = 2;
	buttonGroup63->setDisabled(true);
    } else {
	addtxt2mask->hide();
	editmask->setEnabled(true);
	QIconSet wl_icoset = outils0->iconSet();
	pixmapLabel1_5->setPixmap(wl_icoset.pixmap());
	rc_003 = 0;
	buttonGroup63->setDisabled(true);
    }
}

void mainfrm::toolButton121_clicked()
{
    myfontmask =
	QFontDialog::getFont(&ok, QFont("Helvetica [Cronyx]", 10), this);
    taille_police_mask = myfontmask.pointSize();
    testpol->setFont(myfontmask);
}

void mainfrm::toolButton122_clicked()
{
    addfilter->hide();
    //
    QString wvf = "";
    QString lum = QString::number(sl_lum->value());
    QString con = QString::number(sl_con->value());
    QString x = QString::number(spx->value());
    QString y = QString::number(spy->value());
    QString l = QString::number(spl->value());
    QString h = QString::number(sph->value());

    if (btreglages->isChecked() == true || btdelogo->isChecked() == true
	|| btmirroir->isChecked() == true
	|| btdenoise->isChecked() == true) {
	wvf = ",";

	if (btreglages->isChecked() == true) {
	    wvf = wvf + "eq=" + lum + ":" + con;
	}

	if (btdelogo->isChecked() == true) {
	    if (btreglages->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    wvf = wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h + ":3";
	}

	if (btmirroir->isChecked() == true) {
	    if (btreglages->isChecked() == true
		|| btdelogo->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    wvf = wvf + "mirror";
	}

	if (btdenoise->isChecked() == true) {
	    if (btreglages->isChecked() == true
		|| btdelogo->isChecked() == true
		|| btmirroir->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    wvf = wvf + "denoise3d=8:6:12";
	}
	QListViewItem *i = lst_video_1->selectedItem();

	if (i != 0) {
	    QImage wl_img1 = i->pixmap(0)->convertToImage();
	    QPixmap wl_pix1(wl_img1);
	    QImage wl_img2 = previcon_3->pixmap()->convertToImage();
	    QPixmap wl_pix2(wl_img2);
	    ::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
		     false);
	    tmp_004 = i->text(2);
	    rc_003 = tmp_004.find("/*EDL/*", 0);
	    if (rc_003 != -1) {
		tmp_005 = tmp_004.mid(0, rc_003 + 7);
		tmp_005 = tmp_005 + wvf;
		i->setText(2, tmp_005);
	    } else {
		i->setText(2, "1" + wvf + " ");
	    }
	    i->setPixmap(0, wl_pix1);
	    bt_force->setDisabled(true);
	}
    } else {
	QListViewItem *i = lst_video_1->selectedItem();

	if (i != 0) {
	    tmp_001 = i->text(2);
	    tmp_002 = tmp_001.mid(0, 1);
	    i->setText(2, tmp_002);
	}
    }
    //
    Etape_02->setEnabled(true);
}

void mainfrm::btpreveffets_clicked()
{
    QString wvf = "";
    QString lum = QString::number(sl_lum->value());
    QString con = QString::number(sl_con->value());
    QString x = QString::number(spx->value());
    QString y = QString::number(spy->value());
    QString l = QString::number(spl->value());
    QString h = QString::number(sph->value());

    proc_003 = new QProcess(this);
    proc_003->addArgument("mplayer");
    proc_003->addArgument(nomfilm);

    if (btreglages->isChecked() == true || btdelogo->isChecked() == true
	|| btmirroir->isChecked() == true
	|| btdenoise->isChecked() == true) {
	proc_003->addArgument("-vf");

	if (btreglages->isChecked() == true) {
	    wvf = "eq=" + lum + ":" + con;
	}

	if (btdelogo->isChecked() == true) {
	    if (btreglages->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    if (checkBox5->isChecked() == true) {
		wvf =
		    wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h +
		    ":-1";
	    } else {
		wvf =
		    wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h +
		    ":3";
	    }
	}

	if (btmirroir->isChecked() == true) {
	    if (btreglages->isChecked() == true
		|| btdelogo->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    wvf = wvf + "mirror";
	}

	if (btdenoise->isChecked() == true) {
	    if (btreglages->isChecked() == true
		|| btdelogo->isChecked() == true
		|| btmirroir->isChecked() == true) {
		wvf = wvf + ",";
	    }
	    wvf = wvf + "denoise3d=8:6:12";
	}

	proc_003->addArgument(wvf);
    }
    connect(proc_003, SIGNAL(processExited()), this,
	    SLOT(fin_prevmplayer()));

    if (!proc_003->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "Mplayer");
    } else {
	this->setDisabled(true);
    }
}

void mainfrm::fin_prevmplayer()
{
    this->setEnabled(true);
}


void mainfrm::avvalue_valueChanged(int)
{
    if (avvalue->value() < 0) {
	grpaudio->setGeometry(62, 51, 130, 20);
	QColor c1(255, 0, 0);
	avgroup->setPaletteForegroundColor(c1);
    } else {
	if (avvalue->value() > 0) {
	    QColor c1(255, 0, 0);
	    avgroup->setPaletteForegroundColor(c1);
	    grpaudio->setGeometry(10, 51, 130, 20);
	} else {
	    QColor c1(0, 255, 0);
	    avgroup->setPaletteForegroundColor(c1);
	    grpaudio->setGeometry(36, 51, 130, 20);
	}
    }
}

/* Preview button clicked in movie effects GUI */
void mainfrm::btprevdelay_clicked()
{

    float decalage;
    tmp_004 = textLabel2_11->text();
    rc_003 = tmp_004.find(":", 0);

    if (rc_003 != -1) {
	rc_003 = rc_003 + 2;
	tmp_008 = "";
	while (rc_003 < (int) tmp_004.length())	// Cast to avoid CC-warning
	{
	    tmp_008 = tmp_008 + tmp_004.mid(rc_003, 1);
	    rc_003 = rc_003 + 1;
	}
	rc_001 = tmp_008.toInt(&ok, 10);
	if (ok == true) {
	    decalage = avvalue->value() - rc_001;
	} else {
	    decalage = 0;
	}
    } else {
	decalage = 0;
    }
    float myval = decalage / 1000;
    QString thetest;
    thetest.setNum(myval, 'f', 3);
    proc_003 = new QProcess(this);
    proc_003->addArgument("mplayer");
    proc_003->addArgument(path_video);
    proc_003->addArgument("-delay");
    proc_003->addArgument(thetest);

    connect(proc_003, SIGNAL(processExited()), this,
	    SLOT(fin_prevmplayer()));

    if (!proc_003->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "Mplayer");
    } else {
	this->setDisabled(true);
    }
}

void mainfrm::bt_dep_droite_clicked()
{
    // *** Deplacement images vers droite ***
    if (nbre_images > 1) {
	int cpt1;
	QLabel *mylabel;
	QLabel *mylabel_2;
	QLabel *mylabel_3;
	QLabel *tmp_tab1[1][2];
	QLabel *tmp_tab2;
	QString tmp_tab3[1][5];

	cpt1 = num_photo->value();

	if (nbre_images > 1 && num_photo->value() < nbre_images) {
	    // *** Dcalage des contrles ***
	    mylabel = table_pnt_img[cpt1 - 1];
	    mylabel_2 = table_pnt_txt[cpt1 - 1][0];
	    mylabel_3 = table_pnt_txt[cpt1 - 1][1];
	    //
	    mylabel->setGeometry((10 + ((cpt1) * 120)) + ((cpt1) * 10), 6,
				 120, 96);
	    mylabel_2->setGeometry((10 + ((cpt1) * 120)) + ((cpt1) * 10),
				   103, 120, 14);
	    mylabel_2->setText("Photo : " + QString::number(cpt1 + 1));
	    mylabel_3->setGeometry((13 + ((cpt1) * 120)) + ((cpt1) * 10),
				   35, 40, 40);
	    // *** Dcalage des pointeurs et autres ***
	    tmp_tab2 = table_pnt_img[cpt1 - 1];
	    tmp_tab1[0][0] = table_pnt_txt[cpt1 - 1][0];
	    tmp_tab1[0][1] = table_pnt_txt[cpt1 - 1][1];
	    tmp_tab3[0][0] = table_images[cpt1 - 1][0];
	    tmp_tab3[0][1] = table_images[cpt1 - 1][1];
	    tmp_tab3[0][2] = table_images[cpt1 - 1][2];
	    tmp_tab3[0][3] = table_images[cpt1 - 1][3];
	    tmp_tab3[0][4] = table_images[cpt1 - 1][4];
	    // *** Dcalage des contrles ***
	    mylabel = table_pnt_img[cpt1];
	    mylabel_2 = table_pnt_txt[cpt1][0];
	    mylabel_3 = table_pnt_txt[cpt1][1];
	    //
	    mylabel->setGeometry((10 + ((cpt1 - 1) * 120)) +
				 ((cpt1 - 1) * 10), 6, 120, 96);
	    mylabel_2->setGeometry((10 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 103, 120, 14);
	    mylabel_2->setText("Photo : " + QString::number(cpt1));
	    mylabel_3->setGeometry((13 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 35, 40, 40);
	    //
	    table_pnt_img[cpt1 - 1] = table_pnt_img[cpt1];
	    table_pnt_txt[cpt1 - 1][0] = table_pnt_txt[cpt1][0];
	    table_pnt_txt[cpt1 - 1][1] = table_pnt_txt[cpt1][1];
	    table_images[cpt1 - 1][0] = table_images[cpt1][0];
	    table_images[cpt1 - 1][1] = table_images[cpt1][1];
	    table_images[cpt1 - 1][2] = table_images[cpt1][2];
	    table_images[cpt1 - 1][3] = table_images[cpt1][3];
	    table_images[cpt1 - 1][4] = table_images[cpt1][4];
	    //
	    table_pnt_img[cpt1] = tmp_tab2;
	    table_pnt_txt[cpt1][0] = tmp_tab1[0][0];
	    table_pnt_txt[cpt1][1] = tmp_tab1[0][1];
	    table_images[cpt1][0] = tmp_tab3[0][0];
	    table_images[cpt1][1] = tmp_tab3[0][1];
	    table_images[cpt1][2] = tmp_tab3[0][2];
	    table_images[cpt1][3] = tmp_tab3[0][3];
	    table_images[cpt1][4] = tmp_tab3[0][4];
	    //
	    num_photo->setValue(cpt1 + 1);
	    calcul_dureeslide();
	}
    }
}

void mainfrm::bt_dep_gauche_clicked()
{
    // *** Deplacement images vers gauche ***
    if (nbre_images > 1) {
	int cpt1;
	QLabel *mylabel;
	QLabel *mylabel_2;
	QLabel *mylabel_3;
	QLabel *tmp_tab1[1][2];
	QLabel *tmp_tab2;
	QString tmp_tab3[1][5];

	cpt1 = num_photo->value();

	if (nbre_images > 1 && num_photo->value() > 1) {
	    // *** Dcalage des contrles ***
	    mylabel = table_pnt_img[cpt1 - 1];
	    mylabel_2 = table_pnt_txt[cpt1 - 1][0];
	    mylabel_3 = table_pnt_txt[cpt1 - 1][1];
	    //
	    mylabel->setGeometry((10 + ((cpt1 - 2) * 120)) +
				 ((cpt1 - 2) * 10), 6, 120, 96);
	    mylabel_2->setGeometry((10 + ((cpt1 - 2) * 120)) +
				   ((cpt1 - 2) * 10), 103, 120, 14);
	    mylabel_2->setText("Photo : " + QString::number(cpt1 - 1));
	    mylabel_3->setGeometry((13 + ((cpt1 - 2) * 120)) +
				   ((cpt1 - 2) * 10), 35, 40, 40);
	    // *** Dcalage des pointeurs et autres ***
	    tmp_tab2 = table_pnt_img[cpt1 - 1];
	    tmp_tab1[0][0] = table_pnt_txt[cpt1 - 1][0];
	    tmp_tab1[0][1] = table_pnt_txt[cpt1 - 1][1];
	    tmp_tab3[0][0] = table_images[cpt1 - 1][0];
	    tmp_tab3[0][1] = table_images[cpt1 - 1][1];
	    tmp_tab3[0][2] = table_images[cpt1 - 1][2];
	    tmp_tab3[0][3] = table_images[cpt1 - 1][3];
	    tmp_tab3[0][4] = table_images[cpt1 - 1][4];
	    // *** Dcalage des contrles ***
	    mylabel = table_pnt_img[cpt1 - 2];
	    mylabel_2 = table_pnt_txt[cpt1 - 2][0];
	    mylabel_3 = table_pnt_txt[cpt1 - 2][1];
	    //
	    mylabel->setGeometry((10 + ((cpt1 - 1) * 120)) +
				 ((cpt1 - 1) * 10), 6, 120, 96);
	    mylabel_2->setGeometry((10 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 103, 120, 14);
	    mylabel_2->setText("Photo : " + QString::number(cpt1));
	    mylabel_3->setGeometry((13 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 35, 40, 40);
	    //
	    table_pnt_img[cpt1 - 1] = table_pnt_img[cpt1 - 2];
	    table_pnt_txt[cpt1 - 1][0] = table_pnt_txt[cpt1 - 2][0];
	    table_pnt_txt[cpt1 - 1][1] = table_pnt_txt[cpt1 - 2][1];
	    table_images[cpt1 - 1][0] = table_images[cpt1 - 2][0];
	    table_images[cpt1 - 1][1] = table_images[cpt1 - 2][1];
	    table_images[cpt1 - 1][2] = table_images[cpt1 - 2][2];
	    table_images[cpt1 - 1][3] = table_images[cpt1 - 2][3];
	    table_images[cpt1 - 1][4] = table_images[cpt1 - 2][4];
	    //
	    table_pnt_img[cpt1 - 2] = tmp_tab2;
	    table_pnt_txt[cpt1 - 2][0] = tmp_tab1[0][0];
	    table_pnt_txt[cpt1 - 2][1] = tmp_tab1[0][1];
	    table_images[cpt1 - 2][0] = tmp_tab3[0][0];
	    table_images[cpt1 - 2][1] = tmp_tab3[0][1];
	    table_images[cpt1 - 2][2] = tmp_tab3[0][2];
	    table_images[cpt1 - 2][3] = tmp_tab3[0][3];
	    table_images[cpt1 - 2][4] = tmp_tab3[0][4];
	    //
	    num_photo->setValue(cpt1 - 1);
	    calcul_dureeslide();
	}
    }
}

void mainfrm::bt_invert_2_clicked()
{
    QImage saveimg = apercu_fond->pixmap()->convertToImage();
    saveimg.save(wpathtotalproj + "limagefond.png", "PNG");
    proc_001 = new QProcess(this);
    proc_001->addArgument("convert");
    proc_001->addArgument(wpathtotalproj + "limagefond.png");
    proc_001->addArgument("-sepia-tone");
    proc_001->addArgument("50000");
    proc_001->addArgument(wpathtotalproj + "tmplimagefond.png");
    connect(proc_001, SIGNAL(processExited()), this,
	    SLOT(fin_effets_menu()));
    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "convert (ImageMagick)");
    } else {
	this->setDisabled(true);
    }
}

void mainfrm::fin_effets_menu()
{
    QImage saveimg;
    saveimg.load(wpathtotalproj + "tmplimagefond.png");
    apercu_fond->setPixmap(saveimg);
    my_pixmap_001->setPixmap(saveimg);
    bitBlt(&save_fond, 0, 0, &saveimg, 0, 0, -1, -1);
    this->setEnabled(true);
}

void mainfrm::toolButton129_clicked()
{
    QPixmap save_cadre_2(deplace_w->value(), deplace_h->value());
    ::bitBlt(&save_cadre_2, 0, 0, imgtravail->pixmap(), deplace_x->value(),
	     deplace_y->value(), deplace_w->value(), deplace_h->value(),
	     Qt::CopyROP, false);
    QImage save_cadre = save_cadre_2.convertToImage();
    QImage save_cadre_3 = save_cadre.scale(720, 576, QImage::ScaleMin);
    QPixmap tmpcreat(720, 576);
    tmpcreat.fill(Qt::black);
    QPixmap tmpcreat2(save_cadre_3);
    ::bitBlt(&tmpcreat, (720 - save_cadre_3.width()) / 2,
	     (576 - save_cadre_3.height()) / 2, &tmpcreat2, 0, 0, -1, -1,
	     Qt::CopyROP, false);
    save_cadre_3 = tmpcreat.convertToImage();
    QTime nowtime;
    nowtime = QTime::currentTime();
    tmp_009 =
	wpathtotalproj + "GIBtmpphoto_" + nowtime.toString("hh:mm:ss") +
	".png";
    save_cadre_3.save(tmp_009, "PNG");
    table_images[num_photo->value() - 1][0] = tmp_009;
    QLabel *pntloc = table_pnt_img[num_photo->value() - 1];
    QPixmap pixloc;
    pixloc.load(tmp_009);
    QImage tmptransf = pixloc.convertToImage();
    QImage myimg = tmptransf.scale(320, 256, QImage::ScaleMax);
    pntloc->setPixmap(myimg);
    apercu_photo_diapo->setPixmap(myimg);
    recadrage->hide();
    fen_slideshow->setEnabled(true);
}

void mainfrm::deplace_y_valueChanged(int)
{
    depl_coupe();
}

void mainfrm::deplace_x_valueChanged(int)
{
    depl_coupe();
}

void mainfrm::depl_coupe()
{
    QImage travfond = fantome_decoupe->pixmap()->convertToImage();
    imgtravail->setPixmap(travfond);
    QPixmap titi(travfond.width(), travfond.height());
    deplace_x->setMaxValue(travfond.width() - deplace_w->value());
    deplace_y->setMaxValue(travfond.height() - deplace_h->value());
    QColor localcol(255, 0, 0);
    titi.fill(localcol);
    QPainter p(this);
    p.end();
    p.begin(&titi);
    p.fillRect(deplace_x->value() - 2, deplace_y->value() - 2,
	       deplace_w->value() + 4, deplace_h->value() + 4, Qt::white);
    p.fillRect(deplace_x->value(), deplace_y->value(), deplace_w->value(),
	       deplace_h->value(), Qt::black);
    p.end();
    ::bitBlt(imgtravail->pixmap(), 0, 0, &titi, 0, 0, -1, -1, Qt::OrROP,
	     false);
}

void mainfrm::toolButton129_2_clicked()
{
    recadrage->hide();
    fen_slideshow->setEnabled(true);
}

void mainfrm::bt_defil_1_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotBack();
    }
}

void mainfrm::bt_defil_2_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotForward();
    }
}

void mainfrm::bt_deb_sub_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	int iHour;
	int iMin;
	int iSec;
	QTime mytime;
	float fElapsedTime =
	    m_pMPlayerWidget->m_rxParseElapsedTime.cap(1).toFloat();
	iHour = (int) (fElapsedTime / 3600.0);
	iMin = (int) ((fElapsedTime - iHour * 3600) / 60.0);
	iSec = (int) (fElapsedTime - iHour * 3600 - iMin * 60);
	mytime.setHMS(iHour, iMin, iSec);
	hre_fin_sub->setTime(mytime);
    }
}

void mainfrm::bt_lire_pr_chap_2_clicked()
{
    m_pMPlayerWidget->slotPlay();
}

void mainfrm::bt_stop_play_chap_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
}

void mainfrm::listdessub_doubleClicked(QListViewItem *)
{
    QListViewItem *i = listdessub->selectedItem();

    if (i != 0) {
	int hre;
	int min;
	int sec;

	tmp_001 = i->text(0);
	tmp_002 = tmp_001.mid(0, 2);
	rc_001 = tmp_002.toInt(&ok, 10);

	if (ok == true) {
	    hre = rc_001;
	} else {
	    hre = 0;
	}
	tmp_002 = tmp_001.mid(3, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    min = rc_001;
	} else {
	    min = 0;
	}
	tmp_002 = tmp_001.mid(6, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    sec = rc_001;
	} else {
	    sec = 0;
	}
	QTime time1(hre, min, sec);
	hre_deb_sub->setTime(time1);
	//
	tmp_001 = i->text(1);
	tmp_002 = tmp_001.mid(0, 2);
	rc_001 = tmp_002.toInt(&ok, 10);

	if (ok == true) {
	    hre = rc_001;
	} else {
	    hre = 0;
	}
	tmp_002 = tmp_001.mid(3, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    min = rc_001;
	} else {
	    min = 0;
	}
	tmp_002 = tmp_001.mid(6, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    sec = rc_001;
	} else {
	    sec = 0;
	}
	QTime time2(hre, min, sec);
	hre_fin_sub->setTime(time2);
	//
	textsub->setText(i->text(2));
	toolButton133_2->setDisabled(true);
	toolButton133_2_2->setDisabled(true);
	btcloseedit->setDisabled(true);
	btcloseedit_2->setDisabled(true);
	newsubt->setEnabled(true);
	listdessub->setDisabled(true);
	rc_002 = 1;
    }
}

void mainfrm::toolButton133_2_clicked()
{
    rc_002 = 0;
    newsubt->setEnabled(true);
    listdessub->setDisabled(true);
    toolButton133_2->setDisabled(true);
    toolButton133_2_2->setDisabled(true);
    btcloseedit->setDisabled(true);
    btcloseedit_2->setDisabled(true);
}

void mainfrm::toolButton133_2_2_clicked()
{
    QListViewItem *i = listdessub->selectedItem();

    if (i != 0) {
	listdessub->takeItem(i);
    }
}

void mainfrm::btcloseedit_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
    createsubtitle->hide();
    mediabar->hide();
    //vframe->setGeometry(31, 125, 115, 71);
    vframe->setGeometry(28, 117, 195, 110);
    vframe->show();
    vframe->raise();
}

void mainfrm::bt_lire_pr_chap_2_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotPause();
    }
}

void mainfrm::listdessub_clicked(QListViewItem *)
{
    QListViewItem *i = listdessub->selectedItem();

    if (i != 0) {
	tmp_001 = i->text(0).mid(0, 2);
	tmp_002 = i->text(0).mid(3, 2);
	tmp_003 = i->text(0).mid(6, 2);
	int hre = tmp_001.toInt(&ok, 10);
	int min = tmp_002.toInt(&ok, 10);
	int sec = tmp_003.toInt(&ok, 10);
	float wpositionnow;
	wpositionnow = (hre * 3600) + (min * 60) + sec;
	if (m_pMPlayerWidget->isPlaying() == false) {
	    m_pMPlayerWidget->slotPlay();
	}
	m_pMPlayerWidget->slotSeek(wpositionnow, 2);
    }
}

void mainfrm::btvalidcapture_clicked()
{
    captureframe->hide();
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
    mediabar->hide();
    Etape_02->setEnabled(true);
    //vframe->setGeometry(31, 125, 115, 71);
    vframe->setGeometry(28, 117, 195, 110);
    vframe->show();
    vframe->raise();
}


void mainfrm::bt_defil_1_2_2_2_clicked()
{
    m_pMPlayerWidget->slotSeek(0.1, 0);
    m_pMPlayerWidget->slotPause();
}

void mainfrm::bt_defil_1_2_2_clicked()
{
    int myseek = 2;
    m_pMPlayerWidget->slotSeek(-myseek, 0);
    m_pMPlayerWidget->slotPause();
}

void mainfrm::openedl(QString myfic)
{
    QString myrec;
    // QString tmp_001; Testing if causeing strange error! 
    QFile myfichier(myfic);
    QTextStream mystream(&myfichier);
    QListViewItem *j;
    QTime time_1(0, 0, 0);
    QTime time_2(0, 0, 0);
    QTime time_3(0, 0, 0);
    QTime time_4(0, 0, 0);
    int thestartint;
    int theendint;
    int cpt1;

    if (myfichier.open(IO_ReadOnly)) {
	myrec = mystream.readLine();
	tmp_001 = "";
	cpt1 = 0;

	while (myrec.mid(cpt1, 1) != " " && cpt1 < (int) myrec.length())	// Cast to avoid cc-warning
	{
	    tmp_001 = tmp_001 + myrec.mid(cpt1, 1);
	    cpt1 = cpt1 + 1;
	}
	//
	cpt1 = cpt1 + 1;
	tmp_002 = "";
	while (myrec.mid(cpt1, 1) != " " && cpt1 < (int) myrec.length())	// Cast to avoid cc-warning
	{
	    tmp_002 = tmp_002 + myrec.mid(cpt1, 1);
	    cpt1 = cpt1 + 1;
	}
	//
	thestartint = tmp_001.toInt(&ok, 10);
	if (ok != true) {
	    thestartint = 0;
	}
	theendint = tmp_002.toInt(&ok, 10);
	if (ok != true) {
	    theendint = 0;
	}
	//
	time_1.setHMS(0, 0, 0);
	time_2.setHMS(0, 0, 0);
	time_3 = time_1.addSecs(thestartint);
	time_4 = time_2.addSecs(theendint);

	if (theendint != 0) {
	    j = new QListViewItem(lstcut, time_3.toString("hh:mm:ss"),
				  time_4.toString("hh:mm:ss"));
	}

	while (mystream.atEnd() == false) {
	    myrec = mystream.readLine();
	    tmp_001 = "";
	    cpt1 = 0;

	    while (myrec.mid(cpt1, 1) != " " && cpt1 < (int) myrec.length())	// Cast to avoid cc-warning
	    {
		tmp_001 = tmp_001 + myrec.mid(cpt1, 1);
		cpt1 = cpt1 + 1;
	    }
	    //
	    cpt1 = cpt1 + 1;
	    tmp_002 = "";
	    while (myrec.mid(cpt1, 1) != " " && cpt1 < (int) myrec.length())	// Cast to avoid cc-warning
	    {
		tmp_002 = tmp_002 + myrec.mid(cpt1, 1);
		cpt1 = cpt1 + 1;
	    }
	    //
	    thestartint = tmp_001.toInt(&ok, 10);
	    if (ok != true) {
		thestartint = 0;
	    }
	    theendint = tmp_002.toInt(&ok, 10);
	    if (ok != true) {
		theendint = 0;
	    }
	    //
	    time_1.setHMS(0, 0, 0);
	    time_2.setHMS(0, 0, 0);
	    time_3 = time_1.addSecs(thestartint);
	    time_4 = time_2.addSecs(theendint);
	    //
	    if (theendint != 0) {
		j = new QListViewItem(lstcut, time_3.toString("hh:mm:ss"),
				      time_4.toString("hh:mm:ss"));
	    }
	}
	if (lstcut->childCount() > 0) {
	    lstcut->setSortColumn(1);
	    lstcut->sort();
	}
    }
}

void mainfrm::outils1_2_2_clicked()
{
    rc_003 = 3;
    QIconSet wl_icoset = outils1_2_2->iconSet();
    pixmapLabel1_5->setPixmap(wl_icoset.pixmap());
    tabpoint[0] = 0;
    tabpoint[1] = 0;
    buttonGroup63->setDisabled(true);
}

void mainfrm::toolButton158_clicked()
{
    rc_004 = 0;
}

void mainfrm::toolButton158_2_clicked()
{
    rc_004 = 1;
}

void mainfrm::toolButton158_3_clicked()
{
    rc_004 = 2;
}

void mainfrm::toolButton158_3_2_clicked()
{
    rc_004 = 3;
}

void mainfrm::toolButton158_3_2_2_clicked()
{
    rc_004 = 4;
}
