/* SVN FILE: $Id$ */
/**
* Project Name : Project Description
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/
/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Implementation: animation
//
// Description: Functions (backend) for making an animation in menu
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
#include <animation.h>

void mainfrm::bt_create_fond_anim_clicked()
{
    // ************************************************
    // *** Ouverture de la fen�tre de cr�ation d'un menu anim� ***
    // ************************************************
    creation_menu_anim->setGeometry(0, 110, 1000, 700);
    Etape_03->hide();
    textEdit4->hide();
    bt_go_extract->setDisabled(true);
    idtpage->setText(table_message[35]);
    vframe->setGeometry(30, 130, 380, 280);
    vframe->show();
    vframe->raise();
    buttonGroup64->hide();
    creation_menu_anim->show();
}


/* Extract picures from video in Animation*/
void mainfrm::bt_go_extract_clicked()
{
    // *********************************
    // *** Extraction des images de la vido ***
    // *********************************
    if (namevideoimport->text() == "") {
	QMessageBox::warning(this, MANDVDVER, table_message[25]);
    } else {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotPause();
	}

	QFile myfic_2(wpathtotalproj + "/genmenuanim.sh");
	int debut;
	int fin;
	QString C_debut;
	QString C_fin;
	if (myfic_2.open(IO_WriteOnly)) {
	    tmp_001 = "#!/bin/bash\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "cd \"" + wpathtotalproj + "\"\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f gibmenanim*.*\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    debut = startvidmenanim->value() * projfps;
	    fin =
		(dureevidmenanim->value() +
		 startvidmenanim->value()) * projfps;
	    C_debut = QString::number(debut);
	    C_fin = QString::number(fin);

	    tmp_001 =
		"transcode -a 0 -c " + C_debut + "-" + C_fin +
		" -Z " PALDVD " -i \"" + namevideoimport->text() +
		"\" -y jpg -F 100 -o gibmenanim\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    myfic_2.close();
	    //
	    pb_006->setTotalSteps(dureevidmenanim->value() * projfps);
	    rc_002 = 0;
	    textEdit4->clear();
	    nbre_images = 0;
	    pb_006->setProgress(0);
	    panel_menu_anim->setDisabled(true);
	    //
	    proc_001 = new QProcess(this);
	    proc_001->addArgument("bash");
	    proc_001->addArgument(wpathtotalproj + "/genmenuanim.sh");

	    connect(proc_001, SIGNAL(readyReadStderr()), this,
		    SLOT(stdout_genanimenu()));
	    connect(proc_001, SIGNAL(processExited()), this,
		    SLOT(fin_genanimenu()));

	    if (!proc_001->start()) {
		QMessageBox::warning(this, MANDVDVER,
				     table_message[0] + "transcode");
	    } else {
		bt_modif_gimp->setDisabled(true);
		bt_effets_anim->setDisabled(true);
	    }
	}
    }
}

/* Extracting images finsh in animation!? */
void mainfrm::stdout_genanimenu()
{
    // ***********************************************
    // *** Lecture de la sortie console d'extraction des images ***
    // ***********************************************
    lineEdit1->setText(proc_001->readStderr());
    tmp_001 = lineEdit1->text();

    rc_001 = tmp_001.find("encoding frame [", 0);

    if (rc_001 != -1) {
	pb_006->setProgress(pb_006->progress() + 1);
	nbre_images = nbre_images + 1;
    }

    rc_001 = tmp_001.find("Err", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    textEdit4->append(lineEdit1->text());
}

/* Extracting images finsh in animation  */
void mainfrm::fin_genanimenu()
{
    // ****************************
    // *** Fin d'extraction des images ***
    // ****************************
    pb_006->setProgress(dureevidmenanim->value() * projfps);

    if (rc_002 == 0 && nbre_images > -1) {	// -1 is a dirty hack to make it run if transcoder dont work as expected
	cdraddmask->setEnabled(true);
	panel_menu_anim->setEnabled(true);
	QImage myimg(wpathtotalproj + "/gibmenanim000000.jpg", 0);
	QPixmap mypix(myimg);
	imgstart->setPixmap(mypix);
	exempleimg->setPixmap(mypix);
	bt_valid_menu_anim->setEnabled(true);
	progress = 0;
	wdebut = 0;
	nbre_images = dureevidmenanim->value() * projfps;
	wfin = nbre_images;
	txtnbreimages->setText(nr_of_im + QString::number(nbre_images));
	//txtnbreimages_2->setText ("Premire image : 0");
	txtnbreimages_2_2->setText(last_im +
				   QString::number(nbre_images - 1));
	changingframe->setMaxValue(nbre_images - 1);
	changingframe->setValue(0);
	bt_modif_gimp->setEnabled(true);
	bt_effets_anim->setEnabled(true);
    } else {
	bt_valid_menu_anim->setDisabled(true);
	QMessageBox::warning(this, MANDVDVER, table_message[26]);
    }
}

/* Hide och show console in animation */
void mainfrm::bt_console_menu_anim_clicked()
{
    // ****************************************************
    // *** Affichage ou pas de la console dans cration menu anim ***
    // ****************************************************
    if (textEdit4->isVisible() == true) {
	textEdit4->hide();
    } else {
	textEdit4->show();
	textEdit4->raise();
    }
}


/* Forward one picture in animation */
void mainfrm::bt_avance_anim_clicked()
{
    // *************************
    // *** On avance d'une image ***
    // *************************
    if (progress < nbre_images - 1) {
	progress = progress + 1;
	tmp_001 = QString::number(progress);
	tmp_002 = "gibmenanim000000";
	tmp_002.replace(tmp_002.length() - tmp_001.length(),
			tmp_001.length(), tmp_001);
	QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
	QPixmap mypix(myimg);
	imgstart->setPixmap(mypix);
	changingframe->setValue(progress);
    }
}

/* Animation?*/
void mainfrm::bt_recul_anim_clicked()
{
    // ************************
    // *** On recul d'une image ***
    // ************************
    if (progress > 0) {
	progress = progress - 1;
	tmp_001 = QString::number(progress);
	tmp_002 = "gibmenanim000000";
	tmp_002.replace(tmp_002.length() - tmp_001.length(),
			tmp_001.length(), tmp_001);
	QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
	QPixmap mypix(myimg);
	imgstart->setPixmap(mypix);
	changingframe->setValue(progress);
    }
}

/* Animation?*/
void mainfrm::bt_last_imganim_clicked()
{
    // *******************
    // *** Dernire image ***
    // *******************
    progress = nbre_images - 1;
    tmp_001 = QString::number(progress);
    tmp_002 = "gibmenanim000000";
    tmp_002.replace(tmp_002.length() - tmp_001.length(), tmp_001.length(),
		    tmp_001);
    QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
    QPixmap mypix(myimg);
    imgstart->setPixmap(mypix);
    changingframe->setValue(progress);
}


/* Animated menu function: Play animation!? mPlayerwidget  */
void mainfrm::btchauto_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == false) {
	m_pMPlayerWidget->slotPlay();
    }
    durfilmchap = 0;

    while (durfilmchap == 0) {
	if (m_pMPlayerWidget->isPlaying() == false) {
	    durfilmchap = 1;
	} else {
	    m_pMPlayerWidget->slotReadStdout();
	    durfilmchap = m_pMPlayerWidget->m_fLength;
	}
    }
    QTime time_001(0, 0, 0);
    QTime time_002;
    time_002 = time_001.addSecs(durfilmchap);
    value_time->setMaxValue(time_002);
    durfilmchap = durfilmchap / 60;
    if (intervalchap->value() < durfilmchap) {
	int winterval;
	int wdurfilm;
	int nbrestep;
	int wcpt1;
	QTime mytime(0, 0, 0);
	QTime mytime_2;
	QListViewItem *j;
	winterval = intervalchap->value();
	wdurfilm = durfilmchap;
	nbrestep = wdurfilm / winterval;
	wcpt1 = 1;
	while (wcpt1 < nbrestep) {
	    mytime_2 = mytime.addSecs(60 * winterval);
	    j = new QListViewItem(lst_chap, mytime_2.toString("hh:mm:ss"));
	    max_chapitres = max_chapitres + 1;
	    wcpt1 = wcpt1 + 1;
	    mytime.setHMS(mytime_2.hour(), mytime_2.minute(),
			  mytime_2.second());
	}
	chapauto->setDisabled(true);
	bt_add_chap->setEnabled(true);
	bt_sup_chap->setEnabled(true);
	bt_sup_chap_2->setEnabled(true);
	bt_add_chap_2_2->setEnabled(true);
	bt_fermer_chapitre->setEnabled(true);
	lst_chap->sort();
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[38]);
    }

}


/* Import a video to the project?? Maybe this function belongs in slideshow???? */
void mainfrm::bt_import_video_manim_clicked()
{
    // *****************************
    // *** Choix de la vid�o � importer ***
    // *****************************
    QString myfic = QFileDialog::getOpenFileName(dossier_travail_2, VIDEOS,
						 this, table_message[65],
						 table_message[66]);

    if (!myfic.isNull()) {
	int i = myfic.findRev('/');

	if (i != 1) {
	    dossier_travail_2 = myfic.mid(0, i);
	} else {
	    dossier_travail_2 = myfic;
	}
	namevideoimport->setText(myfic);
	// *** R�cup info vid�o ***
	bt_go_extract->setDisabled(true);
	proc_001 = new QProcess(this);
	proc_001->addArgument("tcprobe");
	proc_001->addArgument("-i");
	proc_001->addArgument(myfic);
	frame_rate = "0";

	connect(proc_001, SIGNAL(readyReadStdout()), this,
		SLOT(test_type_video_menuanim()));
	connect(proc_001, SIGNAL(processExited()), this,
		SLOT(fin_import_menu_anim()));

	if (!proc_001->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "transcode");
	}
    }
}

/* Animated DVD menu video testing */
void mainfrm::test_type_video_menuanim()
{
    // ****************************
    // *** Lecture de la sortie console ***   
    // ****************************
    lineEdit1->setText(proc_001->readStdout());
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("frame rate: -f ", 0);
    if (rc_001 != -1) {
	frame_rate = tmp_001.mid(rc_001 + 15, 2);
    }
}

/* Finish import of animated menu for DVD */
void mainfrm::fin_import_menu_anim()
{
    if (frame_rate != "0") {
	if (frame_rate == "25" || frame_rate == "30") {
	    bt_go_extract->setEnabled(true);
	    m_pMPlayerWidget->setFilename(namevideoimport->text());
	} else {
	    bt_go_extract->setDisabled(true);
	    QMessageBox::warning(this, MANDVDVER, table_message[27]);
	}
    }
}

/* Animation!? */
void mainfrm::bt_lire_anim_source_clicked()
{
    if (namevideoimport->text() != "") {
	m_pMPlayerWidget->slotPlay();
    }
}

/* Animation!? */
void mainfrm::bt_stop_anim_source_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotPause();
    }
}

/* Animation!? */
void mainfrm::bt_recul_anim_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotBack();
    }
}

/* Animation!? */
void mainfrm::bt_avance_anim_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotForward();
    }
}

/* Animation!? */
void mainfrm::bt_deb_menani_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	//   int iHour; 
	//   int iMin; 
	//   int iSec; Warningfix MB
	QTime mytime;
	float fElapsedTime =
	    m_pMPlayerWidget->m_rxParseElapsedTime.cap(1).toFloat();
	startvidmenanim->setValue(fElapsedTime);
    }
}

/* Animation!? */
void mainfrm::bt_fin_menani_2_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true
	|| startvidmenanim->text() != "0") {
	/*
	   int iHour; 
	   int iMin; 
	   int iSec; warningfix MB 
	 */
	QTime mytime;
	float fElapsedTime =
	    m_pMPlayerWidget->m_rxParseElapsedTime.cap(1).toFloat();
	int zone1;
	int zone2;

	zone1 = startvidmenanim->value();
	zone2 = fElapsedTime - zone1;
	if (zone2 > 0) {
	    dureevidmenanim->setValue(zone2);
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[29]);
	}
    }
}


/* Might be choise of background image */
void mainfrm::bt_first_imganim_clicked()
{
    // *******************
    // *** Premire image ***
    // *******************
    progress = 0;
    QImage myimg(wpathtotalproj + "/gibmenanim000000.jpg", 0);
    QPixmap mypix(myimg);
    imgstart->setPixmap(mypix);
    changingframe->setValue(progress);
}


/* Modify image in the gimp starting a QProcess */
void mainfrm::bt_modif_gimp_clicked()
{
    // **************************************
    // *** Modification d'une frame avec the gimp ***
    // **************************************
    tmp_001 = QString::number(progress);
    tmp_002 = "gibmenanim000000";
    tmp_002.replace(tmp_002.length() - tmp_001.length(), tmp_001.length(),
		    tmp_001);
    //
    proc_001 = new QProcess(this);
    proc_001->addArgument("gimp");
    proc_001->addArgument(wpathtotalproj + "/" + tmp_002 + ".jpg");
    connect(proc_001, SIGNAL(processExited()), this, SLOT(fin_thegimp()));
    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "The Gimp");
    } else {
	this->setDisabled(true);
    }
}

/* Finish gimp */
void mainfrm::fin_thegimp()
{
    this->setEnabled(true);
    QImage myimg(wpathtotalproj + tmp_002 + ".jpg", 0);
    QPixmap mypix(myimg);
    imgstart->setPixmap(mypix);

}

/* Animation something??  */
void mainfrm::bt_deb_menani_clicked()
{
    int wtmp = progress;
    if (wtmp < wfin) {
	wdebut = progress;
	txtnbreimages_2->setText("Premire image : " +
				 QString::number(progress));
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[28]);
    }
}

/* Animation something??  */
void mainfrm::bt_fin_menani_clicked()
{
    int wtmp = progress;
    if (wtmp > wdebut) {
	wfin = progress;
	txtnbreimages_2_2->setText("Dernire image : " +
				   QString::number(progress));
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[29]);
    }
}

/* Animation something??  */
void mainfrm::bt_valid_menu_anim_clicked()
{
    // ******************************************
    // *** On valide et on retourne  l'tape prcdente ***
    // ******************************************
    QFile myfic_2(wpathtotalproj + "/nettoyage.sh");
    if (myfic_2.open(IO_WriteOnly)) {
	tmp_001 = "#!/bin/bash\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "cd " + wpathtotalproj + "\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	rc_001 = 0;
	rc_002 = 0;

	while (rc_001 < nbre_images) {
	    if (rc_001 < wdebut || rc_001 > wfin) {
		tmp_001 = QString::number(rc_001);
		tmp_002 = "gibmenanim000000";
		tmp_002.replace(tmp_002.length() - tmp_001.length(),
				tmp_001.length(), tmp_001);
		tmp_003 = "rm -f " + tmp_002 + ".jpg\n";
		myfic_2.writeBlock(tmp_003, tmp_003.length());
	    } else {
		if (rc_001 != rc_002) {
		    tmp_001 = QString::number(rc_002);
		    tmp_002 = "gibmenanim000000";
		    tmp_002.replace(tmp_002.length() - tmp_001.length(),
				    tmp_001.length(), tmp_001);
		    tmp_004 = QString::number(rc_001);
		    tmp_005 = "gibmenanim000000";
		    tmp_005.replace(tmp_005.length() - tmp_004.length(),
				    tmp_004.length(), tmp_004);

		    tmp_003 =
			"mv -f " + tmp_005 + ".jpg " + tmp_002 + ".jpg\n";
		    myfic_2.writeBlock(tmp_003, tmp_003.length());
		    tmp_003 = "rm -f " + tmp_005 + ".jpg\n";
		    myfic_2.writeBlock(tmp_003, tmp_003.length());
		}
		rc_002 = rc_002 + 1;
	    }
	    rc_001 = rc_001 + 1;
	}
	myfic_2.close();
    }

    proc_001 = new QProcess(this);
    proc_001->addArgument("bash");
    proc_001->addArgument(wpathtotalproj + "nettoyage.sh");
    connect(proc_001, SIGNAL(processExited()), this,
	    SLOT(fin_finanimenu()));

    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER, table_message[0] + "bash");
    }
}

/* Finish animated menu ?? mPlayerwidget */
void mainfrm::fin_finanimenu()
{
    tmp_001 = QString::number(wdebut);
    tmp_002 = "gibmenanim000000";
    QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
    QImage myimg_2 = myimg.smoothScale(720, 576, QImage::ScaleFree);
    //
    if (namemaskimport->text() != "") {
	QPixmap mypix8(namemaskimport->text());
	QImage tmpimg1;
	tmpimg1 = mypix8.convertToImage();
	bitBlt(&myimg_2, 0, 0, &tmpimg1, 0, 0, 720, 576);
    }
    //
    QPixmap mypix(myimg_2);
    apercu_fond->setPixmap(mypix);
    path_fond = "Menu anime";
    save_fond = myimg_2.copy(0, 0, 720, 576, 0);
    // *** Mise en place des fonds d'cran pour le menu ***       
    my_pixmap_001->setPixmap(mypix);
    boite_effets->setEnabled(true);
    boite_effets->setDisabled(true);
    //
    if (joubouclmenu->isChecked() == true) {
	loopsound->setCurrentText(table_message[60]);
    }
    idtpage->setText(table_message[31]);
    m_pMPlayerWidget->slotStop();
    vframe->hide();
    creation_menu_anim->hide();
    Etape_03->show();
}


/* Animated menu function */
void mainfrm::changingframe_valueChanged(int)
{
    // ************************
    // *** Changement de frame ***
    // ************************
    tmp_001 = QString::number(changingframe->value());
    tmp_002 = "gibmenanim000000";
    tmp_002.replace(tmp_002.length() - tmp_001.length(), tmp_001.length(),
		    tmp_001);
    QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
    QPixmap mypix(myimg);
    imgstart->setPixmap(mypix);
    progress = changingframe->value();
}

/* Animated menu function */
void mainfrm::bt_add_photo_bt_clicked()
{
    QString myfic;
    Preview *p = new Preview;
    QFileDialog *fd = new QFileDialog(dossier_travail_2,
				      "Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)",
				      this, table_message[65],
				      table_message[67]);

    fd->setContentsPreviewEnabled(TRUE);
    fd->setContentsPreview(p, p);
    fd->setPreviewMode(QFileDialog::Contents);

    if (fd->exec() == QDialog::Accepted) {
	myfic = fd->selectedFile();
	if (myfic.isNull()) {
	} else {
	    int i = myfic.findRev('/');
	    if (i != 1) {
		dossier_travail_3 = myfic.mid(0, i);
	    } else {
		dossier_travail_3 = myfic;
	    }
	    QImage myimg(myfic, 0);
	    QPixmap mypix(myimg);
	    appimgbt->setPixmap(mypix);
	    appimgbt->show();
	    lineEdit8->setText(myfic);
	}
    }
    delete(p);
    delete(fd);
}

/* Animated menu function */
void mainfrm::bt_import_video_manim_2_clicked()
{
    // *******************************
    // *** Slection du mask d'animation ***
    // *******************************
    QString myfic;
    Preview *p = new Preview;
    QFileDialog *fd = new QFileDialog(dossier_travail_2,
				      "Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)",
				      this, table_message[65],
				      table_message[67]);

    fd->setContentsPreviewEnabled(TRUE);
    fd->setContentsPreview(p, p);
    fd->setPreviewMode(QFileDialog::Contents);

    if (fd->exec() == QDialog::Accepted) {
	myfic = fd->selectedFile();
	if (myfic.isNull()) {
	    namemaskimport->setText("");
	} else {
	    int i = myfic.findRev('/');
	    if (i != 1) {
		dossier_travail_3 = myfic.mid(0, i);
	    } else {
		dossier_travail_3 = myfic;
	    }
	    QPixmap mypix(myfic);
	    QImage tmpimg1;
	    QImage tmpimg2;
	    tmpimg1 = mypix.convertToImage();
	    tmpimg2 = exempleimg->pixmap()->convertToImage();
	    bitBlt(&tmpimg2, 0, 0, &tmpimg1, 0, 0, 720, 576);
	    QPixmap mypix_002(tmpimg2);
	    exempleimg->setPixmap(mypix_002);
	    namemaskimport->setText(myfic);
	}
    }
    delete(p);
    delete(fd);
}

/* Animated menu function */
void mainfrm::btchauto_1_clicked()
{
    chapauto->setDisabled(true);
    bt_add_chap->setEnabled(true);
    bt_sup_chap->setEnabled(true);
    bt_add_chap_2_2->setEnabled(true);
    bt_fermer_chapitre->setEnabled(true);
}

/* Animated menu function */
void mainfrm::bt_valid_info_image_2_clicked()
{
    // *****************************************
    // *** Changement d'une image dans le slideshow ***
    // *****************************************
    QString myfic;
    Preview *p = new Preview;
    QFileDialog *fd = new QFileDialog(dossier_travail_2,
				      "Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)",
				      this, table_message[65],
				      table_message[67]);

    fd->setContentsPreviewEnabled(TRUE);
    fd->setContentsPreview(p, p);
    fd->setPreviewMode(QFileDialog::Contents);

    if (fd->exec() == QDialog::Accepted) {
	myfic = fd->selectedFile();
	if (myfic.isNull()) {
	} else {
	    int i = myfic.findRev('/');

	    if (i != 1) {
		dossier_travail_2 = myfic.mid(0, i);
	    } else {
		dossier_travail_2 = myfic;
	    }
	    QImage myimg(myfic, 0);
	    QImage tmp_img_2 =
		myimg.smoothScale(320, 256, QImage::ScaleMax);

	    dossier_travail = myfic;
	    table_images[num_photo->value() - 1][0] = myfic;
	    QLabel *mypix_2;
	    mypix_2 = table_pnt_img[num_photo->value() - 1];
	    mypix_2->setPixmap(tmp_img_2);
	    apercu_photo_diapo->setPixmap(tmp_img_2);
	}
    }
    delete(p);
    delete(fd);
}

/* Animated menu function */
void mainfrm::bt_valid_info_image_3_clicked()
{
    // *****************************************
    // *** Suppression d'une image dans le slideshow ***
    // *****************************************
    if (nbre_images > 0) {
	delete table_pnt_img[num_photo->value() - 1];
	delete table_pnt_txt[num_photo->value() - 1][0];
	delete table_pnt_txt[num_photo->value() - 1][1];

	int cpt1;
	int cpt2;
	QLabel *mylabel;
	QLabel *mylabel_2;
	QLabel *mylabel_3;

	cpt1 = num_photo->value();
	cpt2 = nbre_images;
	nbre_images = nbre_images - 1;

	if (nbre_images == 0) {
	    the_selection->hide();
	    num_photo->setMaxValue(0);
	    texttottime->setText("Total : 0 sec");
	    bt_modif_gimp_2->setDisabled(true);
	    bt_valid_info_image_2->setDisabled(true);
	    bt_valid_info_image_3->setDisabled(true);
	    bt_dep_gauche->hide();
	    bt_dep_droite->hide();
	    box_det_photo->setDisabled(true);
	    scroll_timeline->setMaxValue(0);
	    scroll_timeline->setValue(0);
	    timeline->setGeometry(scroll_timeline->value() * -1, 25, 13500,
				  140);
	}

	while (cpt1 < cpt2 && nbre_images != 0) {
	    // *** Dcalage des contrles ***
	    mylabel = table_pnt_img[cpt1];
	    mylabel_2 = table_pnt_txt[cpt1][0];
	    mylabel_3 = table_pnt_txt[cpt1][1];
	    //
	    mylabel->setGeometry((10 + ((cpt1 - 1) * 120)) +
				 ((cpt1 - 1) * 10), 6, 120, 96);
	    mylabel_2->setGeometry((10 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 103, 120, 14);
	    mylabel_2->setText("Photo : " + QString::number(cpt1));
	    mylabel_3->setGeometry((13 + ((cpt1 - 1) * 120)) +
				   ((cpt1 - 1) * 10), 35, 40, 40);
	    // *** Dcalage des pointeurs et autres ***
	    table_pnt_img[cpt1 - 1] = table_pnt_img[cpt1];
	    table_pnt_txt[cpt1 - 1][0] = table_pnt_txt[cpt1][0];
	    table_pnt_txt[cpt1 - 1][1] = table_pnt_txt[cpt1][1];
	    //
	    table_images[cpt1 - 1][0] = table_images[cpt1][0];
	    table_images[cpt1 - 1][1] = table_images[cpt1][1];
	    table_images[cpt1 - 1][2] = table_images[cpt1][2];
	    table_images[cpt1 - 1][3] = table_images[cpt1][3];
	    table_images[cpt1 - 1][4] = table_images[cpt1][4];
	    //
	    cpt1 = cpt1 + 1;
	}
	if (nbre_images != 0) {
	    num_photo->setMaxValue(nbre_images);
	    QLabel *mypix;
	    mypix = table_pnt_img[num_photo->value() - 1];
	    apercu_photo_diapo->setPixmap(*mypix->pixmap());
	    apercu_photo_diapo->setScaledContents(true);
	    tmp_004 = table_images[num_photo->value() - 1][1];
	    lst_effets->setCurrentText(table_images[num_photo->value() - 1]
				       [2]);
	    txt_img->setText(table_images[num_photo->value() - 1][4]);
	    rc_001 = tmp_004.toInt(&ok, 10);
	    if (ok == true) {
		duree_affichage->setValue(rc_001);
	    }
	    tmp_004 = table_images[num_photo->value() - 1][3];
	    rc_001 = tmp_004.toInt(&ok, 10);
	    if (ok == true) {
		duree_transition->setValue(rc_001);
	    }
	    calcul_dureeslide();
	}
    }
}

void mainfrm::calcul_dureeslide()
{
    int cpt1 = 0;
    int tottime = 0;
    int longueur_audio_1 = 0;
    int cumul_audio_1 = 0;

    if (nbre_images > 0) {
	bt_modif_gimp_2->setEnabled(true);
	bt_valid_info_image_2->setEnabled(true);
	bt_valid_info_image_3->setEnabled(true);
    } else {
	bt_modif_gimp_2->setDisabled(true);
	bt_valid_info_image_2->setDisabled(true);
	bt_valid_info_image_3->setDisabled(true);
    }

    while (cpt1 < nbre_images) {
	tmp_001 = table_images[cpt1][1];
	tmp_002 = table_images[cpt1][3];
	rc_001 = tmp_001.toInt(&ok, 10);
	if (ok == true) {
	    tottime = tottime + rc_001;
	    cumul_audio_1 = cumul_audio_1 + rc_001;
	}
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true && table_images[cpt1][2] != table_message[40]) {
	    tottime = tottime + rc_001;
	    cumul_audio_1 = cumul_audio_1 + rc_001;
	}
	if (cumul_audio_1 > yaaudio && longueur_audio_1 == 0) {
	    longueur_audio_1 = cpt1 + 1;
	}
	cpt1 = cpt1 + 1;
    }
    if (longueur_audio_1 == 0) {
	Audio_1->setGeometry(0, 121, 105 + (130 * nbre_images), 18);
    } else {
	Audio_1->setGeometry(0, 121, 5 + (130 * longueur_audio_1), 18);
    }
    texttottime->setText("Total : " + QString::number(tottime) + " sec");
}


/* Animated menu function */
void mainfrm::sliderpriorite_valueChanged(int)
{
    // ***************************
    // *** Changement de la priorit ***
    // ***************************
    QImage tmpimg_1 = tmpsliderpriovide->pixmap()->convertToImage();
    QImage tmpimg_2 = tmpsliderprioplein->pixmap()->convertToImage();
    if (sliderpriorite->value() > 0) {
	int wposition;
	wposition =
	    (104 / sliderpriorite->maxValue()) * sliderpriorite->value();
	bitBlt(&tmpimg_1, 0, 0, &tmpimg_2, 0, 0, wposition, -1);
    } else {
	int wposition;
	wposition = 0;
	bitBlt(&tmpimg_1, 0, 0, &tmpimg_2, 0, 0, wposition, -1);
    }
    graphprio->setPixmap(tmpimg_1);
}


/* Animated menu function */
void mainfrm::bt_valid_param_defo_clicked()
{
    fenparamdef->hide();
}


/* Animation something !? */
void mainfrm::outils1_2_2_2_clicked()
{
    rc_003 = 4;
    QIconSet wl_icoset = outils1_2_2_2->iconSet();
    pixmapLabel1_5->setPixmap(wl_icoset.pixmap());
    buttonGroup63->setEnabled(true);
    tabpoint[0] = 0;
    tabpoint[1] = 0;
}

/* Animation something !? */
void mainfrm::bt_effets_anim_clicked()
{
    if (buttonGroup64->isShown() == true) {
	buttonGroup64->hide();
    } else {
	buttonGroup64->show();
    }
}

/* Animation something !? */
void mainfrm::toolButton165_clicked()
{
    if (effmani1->isChecked() == true || effmani2->isChecked() == true
	|| effmani3->isChecked() == true || effmani4->isChecked() == true
	|| effmani5->isChecked() == true || effmani6->isChecked() == true)
    {
	QFile myfic(path_out->text() + "/geneffetsanim.sh");
	if (myfic.open(IO_WriteOnly)) {
	    int wl_cpt1 = wdebut;
	    int wl_cpt2 = wfin;
	    int wl_cpt3 = wdebut + ((wfin - wdebut) / 2);
	    int wl_cpt4 = 0;
	    int wl_cpt5 = 0;
	    myfic.writeBlock("#!/bin/bash\n", 12);
	    while (wl_cpt1 < wl_cpt2) {
		tmp_001 = QString::number(wl_cpt1);
		tmp_002 = "gibmenanim000000";
		tmp_002.replace(tmp_002.length() - tmp_001.length(),
				tmp_001.length(), tmp_001);
		if (effmani1->isChecked() == true) {
		    tmp_001 =
			"mogrify -sepia-tone 50000 " + wpathtotalproj +
			"/" + tmp_002 + ".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		if (effmani2->isChecked() == true) {
		    tmp_001 =
			"mogrify -monochrome " + wpathtotalproj + "/" +
			tmp_002 + ".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		if (effmani3->isChecked() == true) {
		    if (wl_cpt1 < wl_cpt3) {
			wl_cpt4 = wl_cpt4 + slider20->value();
		    } else {
			wl_cpt4 = wl_cpt4 - slider20->value();
		    }
		    tmp_001 =
			"mogrify  -wave " + QString::number(wl_cpt4) +
			"x400 " + wpathtotalproj + "/" + tmp_002 +
			".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		if (effmani4->isChecked() == true) {
		    if (wl_cpt1 < wl_cpt3) {
			wl_cpt5 = wl_cpt5 + slider21->value();
		    } else {
			wl_cpt5 = wl_cpt5 - slider21->value();
		    }
		    tmp_001 =
			"mogrify  -swirl " + QString::number(wl_cpt5) +
			" " + wpathtotalproj + "/" + tmp_002 + ".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		if (effmani5->isChecked() == true) {
		    tmp_001 =
			"mogrify -cycle 100 " + wpathtotalproj + "/" +
			tmp_002 + ".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		if (effmani6->isChecked() == true) {
		    tmp_001 =
			"mogrify -paint " + wpathtotalproj + "/" +
			tmp_002 + ".jpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}
		tmp_001 = "echo \"GIBOSTEP+1\"\n";
		myfic.writeBlock(tmp_001, tmp_001.length());
		wl_cpt1 = wl_cpt1 + 1;
	    }
	    myfic.close();
	    pb_006->setTotalSteps(wfin - wdebut);
	    pb_006->setProgress(0);
	    proc_001 = new QProcess(this);
	    proc_001->addArgument("bash");
	    proc_001->addArgument(path_out->text() + "/geneffetsanim.sh");
	    connect(proc_001, SIGNAL(processExited()), this,
		    SLOT(fin_effet_anim()));
	    connect(proc_001, SIGNAL(readyReadStdout()), this,
		    SLOT(readStdouteffetanim()));

	    if (!proc_001->start()) {
		QMessageBox::warning(this, MANDVDVER,
				     table_message[0] +
				     "mogrify (ImageMagick)");
	    } else {
		buttonGroup64->setDisabled(true);
		bt_valid_menu_anim->setDisabled(true);
		bt_fermer_menu_anim->setDisabled(true);
		bt_go_extract->setDisabled(true);
		bt_import_video_manim_2->setDisabled(true);
		bt_modif_gimp->setDisabled(true);
		bt_effets_anim->setDisabled(true);
	    }
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[8]);
	}
    } else {
	buttonGroup64->hide();
    }
}

/* Animation something !? */
void mainfrm::fin_effet_anim()
{
    buttonGroup64->setEnabled(true);
    buttonGroup64->hide();
    effmani1->setChecked(false);
    effmani2->setChecked(false);
    effmani3->setChecked(false);
    effmani4->setChecked(false);
    effmani5->setChecked(false);
    effmani6->setChecked(false);
    bt_valid_menu_anim->setEnabled(true);
    bt_fermer_menu_anim->setEnabled(true);
    bt_go_extract->setEnabled(true);
    bt_import_video_manim_2->setEnabled(true);
    bt_modif_gimp->setEnabled(true);
    bt_effets_anim->setEnabled(true);
    progress = 0;
    tmp_001 = QString::number(wdebut);
    tmp_002 = "gibmenanim000000";
    tmp_002.replace(tmp_002.length() - tmp_001.length(), tmp_001.length(),
		    tmp_001);
    QImage myimg(wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
    QPixmap mypix(myimg);
    imgstart->setPixmap(mypix);
    changingframe->setValue(wdebut);
}

/* Animation something !? */
void mainfrm::readStdouteffetanim()
{
    // ****************************
    // *** Lecture de la sortie console ***   
    // ****************************
    lineEdit1->setText(proc_001->readStdout());
    tmp_001 = lineEdit1->text();
    // *** Test si changement d'tape ***
    rc_001 = tmp_001.find("GIBOSTEP+1", 0);
    if (rc_001 != -1) {
	pb_006->setProgress(pb_006->progress() + 1);
    }
}

/* Animation something !? Effect Music?? */
void mainfrm::bt_musique_options_clicked()
{
    if (nbre_images > 0) {
	int cpt_001;
	int duree1 = durfilmchap / nbre_images;
	int duree2 = duree1 / 2;
	int duree3;
	if (duree2 > 3) {
	    duree3 = duree2 - 3;
	    duree2 = duree2 + duree3;
	    duree3 = 3;
	} else {
	    duree3 = duree2;
	}
	cpt_001 = 0;
	while (cpt_001 < nbre_images) {
	    if (table_images[cpt_001][2] == table_message[40]) {
		table_images[cpt_001][1] = QString::number(duree1);
		table_images[cpt_001][3] = QString::number(1);
	    } else {
		table_images[cpt_001][1] = QString::number(duree2);
		table_images[cpt_001][3] = QString::number(duree3);
	    }
	    cpt_001 = cpt_001 + 1;
	}
	calcul_dureeslide();
	if (table_images[num_photo->value() - 1][2] == table_message[40]) {
	    duree_affichage->setValue(duree1);
	    duree_transition->setValue(1);
	} else {
	    duree_affichage->setValue(duree2);
	    duree_transition->setValue(duree3);
	}
    }
}

void mainfrm::toolButton170_clicked()
{
    if (groupBox13->isShown() == true) {
	groupBox13->hide();
    } else {
	if (num_photo->value() > 1) {
	    toolButton117_2_2->setEnabled(true);
	} else {
	    toolButton117_2_2->setDisabled(true);
	}
	groupBox13->show();
	groupBox13->raise();
    }
}

void mainfrm::toolButton117_2_clicked()
{
    QString myfic;
    Preview *p = new Preview;
    QFileDialog *fd = new QFileDialog(dossier_travail_2,
				      "Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)",
				      this, table_message[65],
				      table_message[67]);

    fd->setContentsPreviewEnabled(TRUE);
    fd->setContentsPreview(p, p);
    fd->setPreviewMode(QFileDialog::Contents);

    if (fd->exec() == QDialog::Accepted) {
	myfic = fd->selectedFile();
	if (myfic.isNull()) {
	} else {
	    int i = myfic.findRev('/');

	    if (i != 1) {
		dossier_travail_2 = myfic.mid(0, i);
	    } else {
		dossier_travail_2 = myfic;
	    }
	    wlanguage = myfic;
	    calculcadre();
	}
    }
    delete(p);
    delete(fd);
}

void mainfrm::dial1_valueChanged(int)
{
    calculcadre();
}

/* Animation some calculation */
void mainfrm::calculcadre()
{
    QWMatrix m;
    QWMatrix z;
    QPixmap loadimg(table_images[num_photo->value() - 1][0]);
    QImage tmpsrc = loadimg.convertToImage();
    QImage srcimg = tmpsrc.smoothScale(720, 576, QImage::ScaleFree);
    QImage srccdr_2 = pixcdrpho->pixmap()->convertToImage();
    QImage srccdr = srccdr_2.smoothScale(720, 576, QImage::ScaleFree);
    m.scale(0.75, 0.69);
    tmpsrc = srcimg.xForm(m);
    tmpsrc.setAlphaBuffer(true);
    tmpsrc.createHeuristicMask(true);
    bitBlt(&srccdr, 90, 90, &tmpsrc, 0, 0, -1, -1);
    z.rotate(dial1->value());
    QPixmap Pfdcolor(720, 576);
    Pfdcolor.fill(fdcolor->paletteBackgroundColor());
    if (wlanguage != "") {
	QPixmap tmpcreat(720, 576);
	tmpcreat.fill(Qt::black);
	QPixmap tmpcreat2(wlanguage);
	QImage wl_img1 = tmpcreat2.convertToImage();
	QImage wl_img2 = wl_img1.smoothScale(720, 576, QImage::ScaleMin);
	QPixmap wl_pix1(wl_img2.width(), wl_img2.height());
	wl_pix1.convertFromImage(wl_img2);
	::bitBlt(&tmpcreat, (720 - wl_img2.width()) / 2,
		 (576 - wl_img2.height()) / 2, &wl_pix1, 0, 0, -1, -1,
		 Qt::CopyROP, false);
	::bitBlt(&Pfdcolor, 0, 0, &tmpcreat, 0, 0, -1, -1, Qt::CopyROP,
		 false);
    }
    QImage Ifdcolor = Pfdcolor.convertToImage();
    QImage fintran = srccdr.xForm(z);
    srcimg = fintran.smoothScale(720, 576, QImage::ScaleMin);
    srcimg.setAlphaBuffer(true);
    srcimg.createHeuristicMask(true);
    QImage wl_img1 =
	srcimg.smoothScale(dial_size->value(), dial_size->value() / 1.25,
			   QImage::ScaleMin);
    bitBlt(&Ifdcolor, dial_x->value(), dial_y->value(), &wl_img1, 0, 0, -1,
	   -1);
    pixmapLabel1_3->setPixmap(Ifdcolor);
}

void mainfrm::toolButton117_2_2_clicked()
{
    if (num_photo->value() > 1) {
	wlanguage = table_images[num_photo->value() - 2][0];
	calculcadre();
    }
}

void mainfrm::dial_size_valueChanged(int)
{
    calculcadre();
}

void mainfrm::dial_x_valueChanged(int)
{
    calculcadre();
}

void mainfrm::dial_y_valueChanged(int)
{
    calculcadre();
}

void mainfrm::lstcut_clicked(QListViewItem *)
{
    QListViewItem *i = lstcut->selectedItem();

    if (i != 0) {
	tmp_001 = i->text(0).mid(0, 2);
	tmp_002 = i->text(0).mid(3, 2);
	tmp_003 = i->text(0).mid(6, 2);
	int heures = tmp_001.toInt(&ok, 10);
	int minutes = tmp_002.toInt(&ok, 10);
	int secondes = tmp_003.toInt(&ok, 10);
	float wpositionnow;
	wpositionnow = (heures * 3600) + (minutes * 60) + secondes;
	if (m_pMPlayerWidget->isPlaying() == false) {
	    m_pMPlayerWidget->slotPlay();
	}
	m_pMPlayerWidget->slotSeek(wpositionnow, 2);
    }
}

	/* Animation something !? */
void mainfrm::bt_generer_clicked()
{
    if (spin_start->value() < spin_end->value()) {
	bt_generer->setDisabled(true);
	bt_generer_2->setDisabled(true);
	Slider_brake->setDisabled(true);
	spin_start->setDisabled(true);
	spin_end->setDisabled(true);
	toolButton176->setDisabled(true);
	toolButton176_2->setDisabled(true);
	QPB1->setProgress(0);
	if (chkpingpong->isChecked() == true) {
	    QPB1->setTotalSteps((spin_start->value() +
				 ((spin_end->value() -
				   spin_start->value()) / 2)) * 2);
	} else {
	    QPB1->setTotalSteps(nbre_images);
	}
	int wl_nbre_frame = nbre_images;
	int wl_total_nbre_frames = 0;
	int wl_compteur_1 = 0;
	int wl_compteur_2 =
	    spin_start->value() +
	    ((spin_end->value() - spin_start->value()) / 2);
	int wl_compteur_3 = wl_compteur_2 / Slider_brake->value();
	int wl_compteur_4 = 1;
	int wl_compteur_5 = 1;
	int wl_compteur_6 = 0;
	int wl_compteur_7 = 0;
	int wl_increment = 1;
	QString wl_tmp_001;
	QString wl_tmp_002;
	QString wl_tmp_003;
	QImage wl_img_1;
	while (wl_compteur_1 < wl_nbre_frame && wl_compteur_1 > -1) {
	    wl_tmp_001 = QString::number(wl_compteur_1);
	    wl_tmp_002 = "gibmenanim000000";
	    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
			       wl_tmp_001.length(), wl_tmp_001);
	    wl_img_1.load(wpathtotalproj + "/" + wl_tmp_002 + ".jpg");
	    if (wl_compteur_4 > wl_compteur_3) {
		if (wl_compteur_1 < wl_compteur_2 && wl_increment > 0) {
		    wl_compteur_5 = wl_compteur_5 + 1;
		} else {
		    if (chkpingpong->isChecked() == true) {
			wl_increment = -1;
		    }
		    wl_compteur_5 = wl_compteur_5 - 1;
		    if (wl_compteur_5 < 1) {
			wl_compteur_5 = 1;
		    }
		}
		wl_compteur_4 = 0;
	    }

	    wl_compteur_6 = 1;
	    while (wl_compteur_6 <= wl_compteur_5) {
		wl_tmp_001 = QString::number(wl_compteur_7);
		wl_tmp_002 = "gibmenanim000000";
		wl_tmp_002.replace(wl_tmp_002.length() -
				   wl_tmp_001.length(),
				   wl_tmp_001.length(), wl_tmp_001);
		wl_img_1.save(wpathtotalproj + "/xxx" + wl_tmp_002 +
			      ".jpg", "JPEG");
		wl_total_nbre_frames = wl_total_nbre_frames + 1;
		wl_compteur_6 = wl_compteur_6 + 1;
		wl_compteur_7 = wl_compteur_7 + 1;
	    }
	    QPB1->setProgress(QPB1->progress() + 1);
	    if (wl_compteur_1 >= spin_start->value()
		&& wl_compteur_1 <= spin_end->value()) {
		wl_compteur_4 = wl_compteur_4 + 1;
	    } else {
		wl_compteur_5 = 1;
	    }
	    wl_compteur_1 = wl_compteur_1 + wl_increment;
	}
	QFile myfic(wpathtotalproj + "/slanim.sh");
	if (myfic.open(IO_WriteOnly)) {
	    myfic.writeBlock("#!/bin/bash\n", 12);
	    wl_tmp_001 = "rm -f " + wpathtotalproj + "/gibmen*.jpg\n";
	    myfic.writeBlock(wl_tmp_001, wl_tmp_001.length());
	    wl_compteur_7 = 0;
	    while (wl_compteur_7 < wl_total_nbre_frames) {
		wl_tmp_001 = QString::number(wl_compteur_7);
		wl_tmp_002 = "gibmenanim000000";
		wl_tmp_002.replace(wl_tmp_002.length() -
				   wl_tmp_001.length(),
				   wl_tmp_001.length(), wl_tmp_001);
		wl_tmp_001 =
		    "mv -f " + wpathtotalproj + "/xxx" + wl_tmp_002 +
		    ".jpg " + wpathtotalproj + "/" + wl_tmp_002 + ".jpg\n";
		myfic.writeBlock(wl_tmp_001, wl_tmp_001.length());
		wl_compteur_7 = wl_compteur_7 + 1;
	    }
	    wl_tmp_001 = "rm -f " + wpathtotalproj + "/slanim.sh\n";
	    myfic.writeBlock(wl_tmp_001, wl_tmp_001.length());
	    myfic.close();
	    //
	    proc_001 = new QProcess(this);
	    proc_001->addArgument("bash");
	    proc_001->addArgument(wpathtotalproj + "/slanim.sh");
	    connect(proc_001, SIGNAL(readyReadStderr()), this,
		    SLOT(SL_lecture_console()));
	    connect(proc_001, SIGNAL(processExited()), this,
		    SLOT(SL_fin_generation()));
	    if (!proc_001->start()) {
		QMessageBox::warning(this, "SLMotion",
				     "Le process de g�n�ration refuse de d�marrer");
		bt_generer->setEnabled(true);
		bt_generer_2->setEnabled(true);
		Slider_brake->setEnabled(true);
		spin_start->setEnabled(true);
		spin_end->setEnabled(true);
		toolButton176->setEnabled(true);
		toolButton176_2->setEnabled(true);
	    }
	    nbre_images = wl_total_nbre_frames;
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[8]);
	    bt_generer->setEnabled(true);
	    bt_generer_2->setEnabled(true);
	    Slider_brake->setEnabled(true);
	    spin_start->setEnabled(true);
	    spin_end->setEnabled(true);
	    toolButton176->setEnabled(true);
	    toolButton176_2->setEnabled(true);
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[28]);
    }
}

void mainfrm::SL_lecture_console()
{
    lineEdit1->setText(proc_001->readStderr());
    textEdit5->append(lineEdit1->text());
}

void mainfrm::SL_fin_generation()
{
    txtnbreimages->setText(nr_of_im + QString::number(nbre_images));
    txtnbreimages_2->setText("Premire image : 0");
    txtnbreimages_2_2->setText(last_im + QString::number(nbre_images - 1));
    progress = 0;
    wdebut = 0;
    wfin = nbre_images;
    changingframe->setMaxValue(nbre_images - 1);
    changingframe->setValue(0);
    SLMotion->hide();
    creation_menu_anim->setEnabled(true);
    effmani7->setChecked(false);
    buttonGroup64->hide();
    bt_generer->setEnabled(true);
    bt_generer_2->setEnabled(true);
    Slider_brake->setEnabled(true);
    spin_start->setEnabled(true);
    spin_end->setEnabled(true);
}

	/* Animation something !? */
void mainfrm::spin_start_valueChanged(int)
{
    int wl_compteur_1 = spin_start->value();
    QString wl_tmp_001;
    QString wl_tmp_002;
    QString wl_tmp_003;
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    wg_img_1->setPixmap(wl_tmp_003);
}

	/* Animation something !? */
void mainfrm::spin_end_valueChanged(int)
{
    int wl_compteur_1 = spin_end->value();
    QString wl_tmp_001;
    QString wl_tmp_002;
    QString wl_tmp_003;
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    wg_img_2->setPixmap(wl_tmp_003);
}

	/* Animation something !? */
void mainfrm::effmani7_stateChanged(int)
{
    if (effmani7->isChecked() == true) {
	textEdit5->hide();
	creation_menu_anim->setDisabled(true);
	SLMotion->setGeometry(345, 160, 310, 330);
	spin_start->setValue(0);
	spin_start->setMinValue(0);
	spin_start->setMaxValue(nbre_images - 1);
	spin_end->setValue(nbre_images - 1);
	spin_end->setMinValue(0);
	spin_end->setMaxValue(nbre_images - 1);
	spin_start_valueChanged(0);
	spin_end_valueChanged(nbre_images - 1);
	SLMotion->show();
	SLMotion->raise();
    }
}

	/* Animation something !? */
void mainfrm::bt_generer_2_clicked()
{
    SLMotion->hide();
    creation_menu_anim->setEnabled(true);
    effmani7->setChecked(false);
}

	/* Animation something !? */
void mainfrm::bt_generer_2_2_clicked()
{
    if (textEdit5->isShown() == true) {
	textEdit5->hide();
    } else {
	textEdit5->setGeometry(10, 11, 290, 270);
	textEdit5->show();
	textEdit5->raise();
    }
}

	/* Animation something !? */
void mainfrm::toolButton176_clicked()
{
    int wl_compteur_1 = spin_start->value();
    QString wl_tmp_001;
    QString wl_tmp_002;
    QString wl_tmp_003;
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    proc_001 = new QProcess(this);
    proc_001->addArgument("gimp");
    proc_001->addArgument(wl_tmp_003);
    connect(proc_001, SIGNAL(processExited()), this,
	    SLOT(slmo_fin_thegimp()));
    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + " The Gimp");
    } else {
	this->setDisabled(true);
    }
}

	/* Animation something !? */
void mainfrm::toolButton176_2_clicked()
{
    int wl_compteur_1 = spin_end->value();
    QString wl_tmp_001;
    QString wl_tmp_002;
    QString wl_tmp_003;
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    proc_001 = new QProcess(this);
    proc_001->addArgument("gimp");
    proc_001->addArgument(wl_tmp_003);
    connect(proc_001, SIGNAL(processExited()), this,
	    SLOT(slmo_fin_thegimp()));
    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + " The Gimp");
    } else {
	this->setDisabled(true);
    }
}

	/* Animation something !? */
void mainfrm::slmo_fin_thegimp()
{
    this->setEnabled(true);
    int wl_compteur_1 = spin_start->value();
    QString wl_tmp_001;
    QString wl_tmp_002;
    QString wl_tmp_003;
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    wg_img_1->setPixmap(wl_tmp_003);
    //
    wl_compteur_1 = spin_end->value();
    wl_tmp_001 = QString::number(wl_compteur_1);
    wl_tmp_002 = "gibmenanim000000";
    wl_tmp_002.replace(wl_tmp_002.length() - wl_tmp_001.length(),
		       wl_tmp_001.length(), wl_tmp_001);
    wl_tmp_003 = wpathtotalproj + "/" + wl_tmp_002 + ".jpg";
    wg_img_2->setPixmap(wl_tmp_003);
}
