package jdepend.framework;

import java.util.Comparator;

/**
 * The <code>PackageComparator</code> class is
 * a <code>Comparator</code> used to compare two 
 * <code>JavaPackage</code> instances for order 
 * using a sorting strategy.
 *
 * @author <b>Mike Clark</b> (mike@clarkware.com)
 * @author Clarkware Consulting, Inc.
 */

public class PackageComparator implements Comparator {

	//
	// Comparison strategy.
	//
	private PackageComparator byWhat;

	//
	// Comparison strategies.
	//
	private static PackageComparator byName;
	static {
		byName = new PackageComparator();
	}

	/**
	 * Returns a comparator for the package name.
	 *
	 * @return Package name comparator.
	 */
	public static PackageComparator byName() {
		return byName;
	}
	
	/*
	 * Constructs a <code>PackageComparator</code>.
	 */
	private PackageComparator() { 
	}
	
	/**
	 * Constructs a <code>PackageComparator</code> with
	 * the specified comparison strategy.
	 *
	 * @param byWhat Comparison strategy.
	 */
	public PackageComparator(PackageComparator byWhat) {
		this.byWhat = byWhat;
	}

	/**
	 * Returns the current comparison strategy.
	 *
	 * @return Comparison strategy.
	 */
	public PackageComparator byWhat() {
		return byWhat;
	}

	/**
	 * Compares the specified objects for order. 
	 *
	 * @param p1 First package.
	 * @param p2 Second package.
	 * @return A negative integer, zero, or a positive integer 
	 *         as the first object is less than, equal to, or 
	 *         greater than the second object.
	 */
	public int compare(Object p1, Object p2) {
	
		JavaPackage a = (JavaPackage)p1;
		JavaPackage b = (JavaPackage)p2;
		
		if (byWhat() == byName()) {
			return a.getName().compareTo(b.getName());
		} 
		
		return 0;
	}
}

