/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.detection.registry;

import junit.framework.TestCase;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.test.remoting.TestUtil;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class NetworkRegistryTestCase extends TestCase implements NotificationListener
{
   private String subSystem = null;
   private int numOfAdded = 0;
   private int numOfUpdated = 0;

   public void testRegistration() throws Exception
   {
//      org.apache.log4j.BasicConfigurator.configure();
//      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
//      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.INFO);
//      org.apache.log4j.Category.getInstance("org.jboss.remoting.detection").setLevel(XLevel.TRACE);
//      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.FATAL);


      MBeanServer server1 = MBeanServerFactory.createMBeanServer();

      NetworkRegistry networkRegistry = new NetworkRegistry();
      server1.registerMBean(networkRegistry, new ObjectName("remoting:type=NetworkRegistry"));

      server1.addNotificationListener(new ObjectName("remoting:type=NetworkRegistry"),
                                      this, null, null);

      MulticastDetector detector1 = new MulticastDetector();

      int port = TestUtil.getRandomPort();
      InvokerLocator locator1 = new InvokerLocator("socket://localhost:" + port);
      Connector connector1 = new Connector(locator1);
      ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator1.getProtocol());
      server1.registerMBean(connector1, obj);
      //connector1.create();
      connector1.start();

      server1.registerMBean(detector1, new ObjectName("remoting:type=MultiplexDetector"));
      // set config info for detector and start it.
      detector1.start();

      System.out.println("First set started.");

      Thread.sleep(3000);

      System.out.println("Starting second set.");

      MBeanServer server2 = MBeanServerFactory.createMBeanServer();
      server2.registerMBean(networkRegistry, new ObjectName("remoting:type=NetworkRegistry"));
      server2.addNotificationListener(new ObjectName("remoting:type=NetworkRegistry"),
                                      this, null, null);

      MulticastDetector detector2 = new MulticastDetector();

      port = TestUtil.getRandomPort();
      InvokerLocator locator2 = new InvokerLocator("socket://localhost:" + port);
      Connector connector2 = new Connector(locator2);
      ObjectName obj2 = new ObjectName("jboss.remoting:type=Connector,transport=" + locator2.getProtocol());
      server2.registerMBean(connector2, obj2);
      //connector2.create();
      connector2.start();

      server2.registerMBean(detector2, new ObjectName("remoting:type=MultiplexDetector"));
      // set config info for detector and start it.
      detector2.start();

      System.out.println("Second set started.");

      Thread.sleep(5000);

      // should have detected both new locators
      assertEquals(2, numOfAdded);

      System.out.println("Stopping first set.");
      connector1.stop();
      connector1.destroy();
      detector1.stop();
      System.out.println("First set stopped.");

      //DEBUG
//      Thread.sleep(6000000);

      Thread.sleep(15000);

      // should have detected first set stopped
      // thus leaving only one valid locator
      assertEquals(1, numOfUpdated);

      System.out.println("Stopping second set.");
      connector2.stop();
      connector2.destroy();
      detector2.stop();
      System.out.println("Stopped second set.");

      Thread.sleep(15000);

      // number of update locators should remain 1
      // as no detector left to tell network registry
      // of a change.
      assertEquals(1, numOfUpdated);

   }


   public void handleNotification(Notification notification, Object o)
   {
      System.out.println("Received notification: " + notification);
      if (notification instanceof NetworkNotification)
      {
         NetworkNotification netNot = (NetworkNotification) notification;
         if(NetworkNotification.SERVER_ADDED.equals(netNot.getType()))
         {
            numOfAdded = netNot.getLocator().length;
            //System.out.println("server added.  num of locators added = " + numOfAdded);
         }
         else if(NetworkNotification.SERVER_UPDATED.equals(netNot.getType()))
         {
            numOfUpdated = netNot.getLocator().length;
            //System.out.println("server updated.  num of locators in update = " + numOfAdded);
         }
         ServerInvokerMetadata[] serverMetadata = netNot.getServerInvokers();
         System.out.println(netNot.getIdentity());
         System.out.println(serverMetadata);
         InvokerLocator[] locators = netNot.getLocator();
         if (locators != null)
         {
            for (int x = 0; x < locators.length; x++)
            {
               System.out.println(locators[x]);
            }
         }
         subSystem = serverMetadata[0].getSubSystems()[0];

      }
   }

}