/* TotalEdgeAdjacencyEquality.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.chemical.indices;

import org.grinvin.GraphBundleView;
import org.grinvin.GraphView;
import org.grinvin.invariants.RealValue;
import org.grinvin.invariants.computers.AbstractInvariantComputer;

/**
 * computes the total information content on the edge adjacency equality of the graph.
 */
public class TotalEdgeAdjacencyEquality extends AbstractInvariantComputer {
    
    public RealValue compute(GraphBundleView bundle) {
        GraphView graph = bundle.getGraph();
        int[][] adjlist = bundle.adjacencyList();
        double e = graph.getNumberOfEdges();
        double plattNumber = -2*e;
        for(int[] neighbours : adjlist)
            plattNumber += neighbours.length * neighbours.length;
        double n2 = plattNumber/2; // n2 is the connection number
        double arg1 = e*e/(e*e-2*n2);
        double arg2 = 2*n2/(e*e-2*n2);
        double index = e*e*Math.log(arg1)/Math.log(2) - 2*n2*Math.log(arg2)/Math.log(2); 
        return new RealValue(index, this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.TotalEdgeAdjacencyEquality";
    }
}
