/* AntiPrismFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.Embedding;
import org.grinvin.Graph;
import org.grinvin.Vertex;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;


/**
 * Factory for antiprism graph with as base an cycle with given length.
 */
public class AntiPrismFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding) {
        int length = ((Integer)values[0]).intValue();
        embedding.setDimension(2);
        Vertex[] vertices = new Vertex[2*length];
        for(int i = 0; i < length; i++) {
            double angle = 2 * i * Math.PI / length;
            double[] coords = new double[2];
            coords[0] = Math.cos(angle);
            coords[1] = Math.sin(angle);
            vertices[2*i] = graph.addNewVertex(null);
            embedding.setCoordinates(vertices[2*i], coords);
            angle = (2 * i + 1) * Math.PI / length;
            coords[0] = Math.cos(angle)/3;
            coords[1] = Math.sin(angle)/3;
            vertices[2 * i + 1] = graph.addNewVertex(null);
            embedding.setCoordinates(vertices[2 * i + 1], coords);
        }
        for (int i=0; i < 2*length; i++) {
            graph.addNewEdge(vertices[i], vertices[(i+1)%(2*length)], null);
            graph.addNewEdge(vertices[i], vertices[(i+2)%(2*length)], null);
        }
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        if (((Integer)values[0]).intValue() < 3)
            throw new FactoryParameterException("The length of the base cycle should be at least 3");
    }
    
}
