/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.grinvin.splash;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

import org.grinvin.Grinvin;
import org.grinvin.Grinvin.LoadState;
import org.grinvin.gui.icons.SvgIconManager;

/**
 *
 * @author adpeeter
 */
public class SplashWindow extends JWindow {

    //
    private JProgressBar progressBar;
    
    public SplashWindow() {

        // create window contents
        ImageIcon icon = SvgIconManager.getInstance().getIcon("/org/grinvin/icons/grinvin-large.svg", 352, 96);
        JLabel iconLabel = new JLabel(icon);
        getContentPane().add(iconLabel, BorderLayout.CENTER);
        
        progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        getContentPane().add(progressBar, BorderLayout.SOUTH);

        // set location of window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = iconLabel.getPreferredSize();
        setLocation(screenSize.width / 2 - (labelSize.width / 2),
                screenSize.height / 2 - (labelSize.height / 2));

        // close window when clicked
        addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {
                setVisible(false);
                dispose();
            }
        });

        Runnable waitRunner = new Runnable() {
            public void run() {
                try {
                    while (Grinvin.getLoadState() != LoadState.FINISHED) {
                        progressBar.setValue(Grinvin.getLoadState().getPercent());
                        progressBar.setString(Grinvin.getLoadState().getDescription());
                        Thread.sleep(100);
                    }
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            setVisible(false);
                            dispose();
                        }});
                } catch (InterruptedException ex) {
                    //ignore
                }
            }
        };

        pack();

        setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}
