/* GraphRenamePanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

/**
 * Dialog panel for renaming a graph.
 */
public class GraphRenamePanel extends RenamePanel<GraphListElement> {
    
    private static final String BUNDLE_NAME = 
            "org.grinvin.list.actions.resources";
    
    /**
     * Construct a panel of this type.
     */
    public GraphRenamePanel() {
        super();
    }
    
    //
    protected String getOldLabelText() {
        return ResourceBundle.getBundle(BUNDLE_NAME).getString("GraphRenamePanel.name.old");
    }
    
    //
    protected String getNewLabelText() {
        return ResourceBundle.getBundle(BUNDLE_NAME).getString("GraphRenamePanel.name.new");
    }
    
    //
    protected String getPanelTitle() {
        return ResourceBundle.getBundle(BUNDLE_NAME).getString("GraphRenamePanel.title");
    }
    
    /**
     * Create and activate the dialog for the given graph list element.
     * When finished, the name of
     * the graph list element will be changed, except when the dialog was canceled
     * by the user.
     * @param gle GraphListElement of which the name can be changed by the user.
     * @param parent Parent of this dialog
     */
    @Override
    public void showDialog(GraphListElement gle, Component parent) {
        assert gle != null : "Dialog shown without corresponding graph list element";
        this.bundle = gle.getBundle();
        super.showDialog(gle, parent);
    }
    
    private GraphBundleView bundle;

    protected Icon getIcon() {
        int size = GrinvinPreferences.getInstance().getIntPreference(Preference.GRAPHICON_SIZE) - 10;
        return bundle.getGraphIconFactory().createIcon(bundle, size);
    }
    
}
