package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.CommonUtils;

import java.io.IOException;

/**
 * Performs an update through opening a web page, first prompting the user
 * for whether or not they would like to perform the update.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class WebPageUpdator extends AbstractUpdator {

	
	/**
	 * Sets the string identifier for this type of update.
	 */
	public WebPageUpdator() {
		_updateType = "WebPageUpdator";
	}

	/** 
	 * Implements the <tt>Updator</tt> interface
	 * Performs the update by opening a web page.
	 */
	public void doUpdate() {
		boolean update = UpdateCallback.showUpdatePrompt(_message);
		
		// if they do not want to update, simply return back to
		// the normal initialization process
		if(!update) return;
	   
		try {
			int launchCode = Launcher.openURL(_url);

			// either we have received a specific error from
			// windows, or we are on another platform
			if(launchCode <= 32 && CommonUtils.isWindows()) {
			    displayError();
			}
			
			// otherwise, the web page was successfully opened, so 
			// shutdown the application
			else {
			    GUIMediator.shutdown();		
			}
		} catch(IOException ioe) {
			// we could not launch the web page, so show the error and 
			// launch the older version
			displayError();
		}
	}

	/**
	 * Displays an error message to the user and starts the old version 
	 * of the application.
	 */
	private void displayError() {
		// the web page did not open successfully, so notify the user
		// and start the old version of LimeWire.
		String msg = "UPDATE_WEB_PAGE_ERROR_MESSAGE";
		UpdateCallback.displayMessage(msg);
	}
}
