package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.limegroup.gnutella.gui.GUIMediator;

/**
 * Displays a message to the user regarding the update.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class DisplayMessageUpdator extends AbstractUpdator {

	/**
	 * Sets the string identifier for this type of update.
	 */
	public DisplayMessageUpdator() {
		_updateType = "DisplayMessageUpdator";
	}

	/** 
	 * Implements the Updator interface.
	 * Displays the message to the user regarding the new version.  The 
	 * message informs the user of the new version, and then prompts them
	 * for whether or not they would like to continue starting the old 
	 * version now.
	 */
	public void doUpdate() {
		boolean go = UpdateCallback.showUpdatePrompt(_message);
		if(!go) GUIMediator.shutdown();
	}	
}
