package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.*; 
import com.limegroup.gnutella.settings.*; 
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;  
import com.limegroup.gnutella.util.CommonUtils; 
import javax.swing.*;
import java.awt.*;

/**
 * This class handles access to the tab that contains the shopping browser.
 */
public final class ShoppingBrowserTab extends AbstractTab {

	/**
	 * Constant for the <tt>Component</tt> instance containing the 
	 * elements of this tab.
	 */
	private final JComponent COMPONENT;

	/**
	 * Constructs the elements of the tab.
	 *
	 * @param shoppingView the <tt>ShoppingView</tt> instance 
	 */
	public ShoppingBrowserTab(final ShoppingView shoppingView) {
		super("SHOPPING", GUIMediator.SHOPPING_INDEX);
			COMPONENT = shoppingView;
	}

	public void storeState(boolean visible) {
        ApplicationSettings.SHOPPING_VIEW_ENABLED.setValue(visible);
	}

	public JComponent getComponent() {
		return COMPONENT;
	}
}
