package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class contains the buttons in the download window, allowing
 * classes in this package to enable or disable buttons at specific
 * indeces in the row.
 */
final class DownloadButtons {


	/**
	 * The row of buttons for the donwload window.
	 */
	private ButtonRow BUTTONS;

	/**
	 * The index of the kill button in the button row.
	 */
	static final int KILL_BUTTON   = 0;

	/**
	 * The index of the resume button in the button row.
	 */
	static final int RESUME_BUTTON = 1;

	/**
	 * The index of the launch button in the button row.
	 */
	static final int LAUNCH_BUTTON = 2;

	/**
	 * The index of the chat button in the button row.
	 */
	static final int CHAT_BUTTON = 3;

	/**
	 * The index of the clear button in the button row.
	 */
	static final int CLEAR_BUTTON  = 4;
	
    /**
     * The string for the resume button label...
     */
    private static final String RESUME_BUTTON_LABEL =
        GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_LABEL");

    /**
     * The string for the resume button tip...
     */
    private static final String RESUME_BUTTON_TIP =
        GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_TIP");
	

    /**
     * The string for the sources button label...
     */
    private static final String SOURCES_BUTTON_LABEL =
        GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_LABEL");

    /**
     * The string for the sources button tip...
     */
    private static final String SOURCES_BUTTON_TIP =
        GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_TIP");

	/**
	 * The constructor creates the row of buttons with their associated
	 * listeners.
	 */
	DownloadButtons(final DownloadMediator dm) {
        String[] buttonLabelKeys = {
			"DOWNLOAD_KILL_BUTTON_LABEL",
			"DOWNLOAD_SOURCES_BUTTON_LABEL",
			"GENERAL_LAUNCH_BUTTON_LABEL",
			"GENERAL_CHAT_BUTTON_LABEL",
			"DOWNLOAD_CLEAR_BUTTON_LABEL",
		};
        String[] buttonTipKeys = {
			"DOWNLOAD_KILL_BUTTON_TIP",
			"DOWNLOAD_SOURCES_BUTTON_TIP",
			"GENERAL_LAUNCH_BUTTON_TIP",
			"GENERAL_CHAT_BUTTON_TIP",
			"DOWNLOAD_CLEAR_BUTTON_TIP",
		};

		ActionListener[] buttonListeners = {
			dm.REMOVE_LISTENER,
			dm.RESUME_LISTENER,
			dm.LAUNCH_LISTENER,
			dm.CHAT_LISTENER,
			dm.CLEAR_LISTENER
		};

		BUTTONS = new ButtonRow(buttonLabelKeys,buttonTipKeys,buttonListeners,
		           ButtonRow.X_AXIS, ButtonRow.NO_GLUE);
	}
	
	ButtonRow getComponent() { return BUTTONS; }


    /**
     * Sets the mutable 'resume' button to the resume button.
     */
    void transformSourcesButton() {
        BUTTONS.transformButton(RESUME_BUTTON, RESUME_BUTTON_LABEL,
                                RESUME_BUTTON_TIP);
    }

    /**
     * Sets the mutable 'resume' button to the sources button.
     */
    void transformResumeButton() {
        BUTTONS.transformButton(RESUME_BUTTON, SOURCES_BUTTON_LABEL,
                                SOURCES_BUTTON_TIP);
    }

}
