package com.limegroup.gnutella.gui.connection;

import com.sun.java.util.collections.Comparable;


/**
 * Wrapper class that acts as a comparable for the messages i/o info.
 * @author sam berlin
 */
public final class MessagesHolder implements Comparable {
	
	/**
	 * Variable for the string representation
	 */
	private String _string;

	/**
	 * Variable for the info.
	 */
	private int _recieved, _sent;

	/**
	 * Constructor
	 */
	public MessagesHolder(int r, int s) {
		_string = Integer.toString(r) + " / " + Integer.toString(s);
		_recieved = r;
		_sent = s;
	}
	
	/**
	 * Add up the two things and see which is larger.
	 */
	public int compareTo(Object o) {
	    MessagesHolder other = (MessagesHolder)o;
	    return ( 
	      ( _recieved + _sent) -
	      (other._recieved + other._sent)
	    );
	}

	/**
	 *
	 * @return the formatted string
	 */
	public String toString() {
		return _string;
	}
}
