
package com.limegroup.gnutella.gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.util.collections.*;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.settings.*;
import com.limegroup.gnutella.ActivityCallback;

import com.limegroup.gnutella.settings.QuestionsHandler;

/**
 *  Control the monitoring of Query Requests and show the requests
 *
 * @version 1.0 07/22/2000
 * @author Greg Bildson
 */
public class MonitorView extends PaddedPanel implements ThemeObserver {

    private int                 listSize;
    private JTextField          showText;
    private JCheckBox           monitorCheckBox;
    private JList               listBox;
    private JScrollPane         scrollPane;
    private boolean             bypassCountChange = false;

    //GGGprivate DefaultListModel        model = new DefaultListModel();
    private BufferListModel     model = new BufferListModel(32);

    public MonitorView() {
        super(GUIMediator.getStringResource("MONITOR_VIEW_INCOMING_SEARCHES"));
		GUIMediator.setSplashScreenString(
		    GUIMediator.getStringResource("SPLASH_STATUS_MONITOR_WINDOW"));  
        listBox = new JList(model);
        //listBox.setFont(new Font("Dialog", Font.PLAIN, 12));
        listBox.setPrototypeCellValue("                                      ");
        listBox.setFixedCellHeight(16);

        // Create the controls
        JPanel controlPanel = new JPanel();
		controlPanel.setLayout(new BoxLayout(controlPanel, BoxLayout.X_AXIS));
        monitorCheckBox = 
			new JCheckBox(GUIMediator.
						  getStringResource("MONITOR_VIEW_ENABLE"));
        monitorCheckBox.addItemListener(new CheckBoxListener());
		controlPanel.add(monitorCheckBox);
		controlPanel.add(Box.createHorizontalGlue());
		controlPanel.add(new JLabel(GUIMediator.
									getStringResource("MONITOR_VIEW_SHOW_LAST")));
        showText = new WholeNumberField(32, 3);
		Dimension d = new Dimension(10,20);
		showText.setPreferredSize(d);
		showText.setMaximumSize(d);
		listSize = 32;
        controlPanel.add(showText);
        controlPanel.add(new JLabel(GUIMediator.getStringResource
                                    ("MONITOR_VIEW_SEARCHES")));

        // Add a scrollpane and build screen
        scrollPane = new JScrollPane(listBox);
        scrollPane.setPreferredSize(new Dimension(340, 180));
		add(controlPanel);
		add(scrollPane);


        // Setup the Show Count input handler
        showText.getDocument().addDocumentListener(
                                              new CountDocumentListener());

        // Handle a double click on the list - trigger a search
        MouseListener mouseListener = new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    int index = listBox.locationToIndex(e.getPoint());
                    String str = (String)model.getElementAt(index);
					triggerSearch(str);
                }
            }
        };
        listBox.addMouseListener(mouseListener);
		updateTheme();
		GUIMediator.addThemeObserver(this);
    }

	// inherit doc comment
	public void updateTheme() {
		Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
		scrollPane.getViewport().setBackground(tableColor);
		listBox.setBackground(tableColor);
	}

    private class CheckBoxListener implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            GUIMediator mediator=GUIMediator.instance();
            if (e.getStateChange()==ItemEvent.SELECTED
                    && mediator.getRouter().isShieldedLeaf()) {
                mediator.showMessage("MONITOR_VIEW_LEAF_MESSAGE",
                    QuestionsHandler.MONITOR_VIEW);
            }                
        }
    }

	// tells the mediator to kick off a new search
	private void triggerSearch(String str) {
		GUIMediator.instance().triggerSearch(str);
	}

    private class CountDocumentListener implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            handleCountChange();
        }
        public void removeUpdate(DocumentEvent e) {
            handleCountChange();
        }
        public void changedUpdate(DocumentEvent e) {
        }
    }   
    
    private void setShowCount(String count) {
        bypassCountChange = true;
        showText.setText(count);
        bypassCountChange = false;
    }

    private void handleCountChange() {
        if(bypassCountChange)
            return;
    
        String val = showText.getText();
        if(val != null && !val.equals("")) {
            int size = Integer.parseInt(val);
            if(size > 10000) {
                listSize = 32;
                delayedSetText("32");
            }
            else {
                listSize = size;
            }
			model.changeSize(listSize);
            scrollPane.validate();
        
        }
    }

    /** Need to set the count outside the document listener */
    private void delayedSetText(String val) {
        Runnable doWorkRunnable = new DelayedSetText(val);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    private class DelayedSetText implements Runnable {
        String val;
        public DelayedSetText(String val) {
            this.val = val;
        }
        public void run() {setShowCount(val);}
    }

    /**
     *  Fire off a seach based on a double click
     */
    private void doSearch() {
        String val = (String)listBox.getSelectedValue();
        if(val == null || val.equals(""))
            return;
                
    }

    /**
     *  Clear the monitor screen
     */
    private void clearAll() {
        model.removeAllElements();
        scrollPane.validate();
    }

    public void handleQueryString(String query) {
        if(monitorCheckBox.isSelected()) {
            if(query.length() == 0)
                return;

            char c = query.charAt(query.length()-1);
            if(Character.isISOControl(c) || 
			   !Character.isDefined(c)) {
                query = query.substring(0, query.length()-1);
            }
            model.addFirst( query );
            //scrollPane.validate();
        }
    }

//      public static void main(String args[])
//      {
//          JFrame f = new JFrame("Monitor View");
//          f.addWindowListener(new WindowAdapter() {
//              public void windowClosing(WindowEvent e) {System.exit(0);}});
//          MonitorView p = new MonitorView();
//          f.getContentPane().add(p);
//          f.pack();
//          f.show();
//      }
}


