/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.PrintWriter;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.CryptoException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.modes.DecryptCBC;
import org.logi.crypto.modes.DecryptCFB;
import org.logi.crypto.modes.DecryptECB;
import org.logi.crypto.modes.DecryptMode;
import org.logi.crypto.modes.DecryptOFB;
import org.logi.crypto.modes.EncryptCBC;
import org.logi.crypto.modes.EncryptCFB;
import org.logi.crypto.modes.EncryptECB;
import org.logi.crypto.modes.EncryptMode;
import org.logi.crypto.modes.EncryptOFB;
import org.logi.crypto.test.BitBucket;
import org.logi.crypto.test.TestIterate;
import org.logi.crypto.test.TestKey;

public class TestMode
extends Crypto {
    private static Random rand = new Random();

    private static void help(PrintWriter printWriter) {
        printWriter.println("Use: java org.logi.crypto.test.TestKey <key-type> <mode>");
        printWriter.println("  <key-type> ::= Caesar|DES|TriDES|Blowfish|RSA|DH");
        printWriter.println("  <mode>     ::= ECB|CBC|CFB|OFB.");
    }

    private static EncryptMode createEncrypt(String string, CipherKey cipherKey, CipherKey cipherKey2, PrintWriter printWriter, PrintWriter printWriter2) throws CryptoException {
        if (string.equals("ECB")) {
            return new EncryptECB(cipherKey);
        }
        if (string.equals("CBC")) {
            return new EncryptCBC(cipherKey);
        }
        if (string.equals("CFB")) {
            return new EncryptCFB(cipherKey2);
        }
        if (string.equals("OFB")) {
            return new EncryptOFB(cipherKey2, 1024);
        }
        TestMode.help(printWriter2);
        return null;
    }

    private static DecryptMode createDecrypt(String string, CipherKey cipherKey, CipherKey cipherKey2, PrintWriter printWriter, PrintWriter printWriter2) throws CryptoException {
        if (string.equals("ECB")) {
            return new DecryptECB(cipherKey2);
        }
        if (string.equals("CBC")) {
            return new DecryptCBC(cipherKey2);
        }
        if (string.equals("CFB")) {
            return new DecryptCFB(cipherKey2);
        }
        if (string.equals("OFB")) {
            return new DecryptOFB(cipherKey2, 1024);
        }
        TestMode.help(printWriter2);
        return null;
    }

    public static final byte[] ensureArrayLength(byte[] byArray, int n, int n2) {
        if (byArray.length >= n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[Math.max(2 * byArray.length, n2)];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static final byte[] trimArrayLength(byte[] byArray, int n) {
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static boolean test(EncryptMode encryptMode, DecryptMode decryptMode, int n, PrintWriter printWriter, PrintWriter printWriter2) {
        byte[] byArray;
        int n2;
        long l = System.currentTimeMillis();
        printWriter.println();
        printWriter2.println("TESTING MODE");
        printWriter.println("Plain/cipher block sizes = " + encryptMode.getKey().plainBlockSize() + " B, " + encryptMode.getKey().cipherBlockSize() + " B");
        printWriter.println("Buffer size = " + TestIterate.metricString(n, 1024) + "B");
        Random random = new Random();
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[8];
        random.nextBytes(byArray2);
        printWriter.print("Encrypting 0%\r");
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length) {
            n2 = Math.min(random.nextInt() % 32 + 32, byArray2.length - n3);
            byArray = n3 + n2 < byArray2.length ? encryptMode.encrypt(byArray2, n3, n2) : encryptMode.flush(byArray2, n3, n2);
            byArray4 = TestMode.ensureArrayLength(byArray4, n4, n4 + byArray.length);
            System.arraycopy(byArray, 0, byArray4, n4, byArray.length);
            n4 += byArray.length;
            printWriter.print("Encrypting " + 100 * (n3 += n2) / byArray2.length + "%\r");
            printWriter.flush();
        }
        byArray4 = TestMode.trimArrayLength(byArray4, n4);
        printWriter.println();
        printWriter.print("Decrypting 0%\r");
        n3 = 0;
        n4 = 0;
        while (n4 < byArray4.length) {
            n2 = Math.min(random.nextInt() % 32 + 32, byArray4.length - n4);
            byArray = decryptMode.decrypt(byArray4, n4, n2);
            byArray3 = TestMode.ensureArrayLength(byArray3, n3, n3 + byArray.length);
            System.arraycopy(byArray, 0, byArray3, n3, byArray.length);
            n3 += byArray.length;
            printWriter.print("Decrypting " + 100 * (n4 += n2) / byArray4.length + "%\r");
            printWriter.flush();
        }
        printWriter.println();
        printWriter.print("Checking 0%\r");
        printWriter.flush();
        n3 = 0;
        while (n3 < byArray2.length) {
            if (byArray2[n3] != byArray3[n3]) {
                printWriter2.println("Error at offset " + n3);
                return false;
            }
            if ((byArray2.length - n3 + 1) % Math.max(1, n / 100) == 0) {
                printWriter.print("Checking " + 100 * n4 / byArray4.length + "%\r");
                printWriter.flush();
            }
            ++n3;
        }
        long l2 = System.currentTimeMillis();
        printWriter.println("\nTime=" + (l2 - l) + "ms");
        return true;
    }

    public static boolean test(String string, String string2, PrintWriter printWriter, PrintWriter printWriter2) throws Exception {
        int n;
        Key key;
        if (printWriter == null) {
            printWriter = new PrintWriter(new BitBucket());
        }
        printWriter2.println("============================================================");
        printWriter2.println("TESTING KEYS OF TYPE " + string + " IN MODE " + string2);
        if (string.equals("DH") && (string2.equals("CFB") || string2.equals("OFB"))) {
            printWriter2.println("DH is a probabilistic encryption algorithm and");
            printWriter2.println("can't be used in OFB or CFB mode. This is not a bug.");
            return true;
        }
        KeyPair keyPair = TestKey.createKeys(string, printWriter, printWriter2);
        if (keyPair == null) {
            return false;
        }
        Key key2 = keyPair.getPublic();
        EncryptMode encryptMode = TestMode.createEncrypt(string2, (CipherKey)key2, (CipherKey)(key = keyPair.getPrivate()), printWriter, printWriter2);
        if (encryptMode == null) {
            return false;
        }
        DecryptMode decryptMode = TestMode.createDecrypt(string2, (CipherKey)key2, (CipherKey)key, printWriter, printWriter2);
        if (encryptMode == null) {
            return false;
        }
        int n2 = n = key2.isPrivate() ? 16384 : 4096;
        if (string2.equals("CFB")) {
            n /= Math.max(1, encryptMode.getKey().getSize() / 8);
        }
        boolean bl = TestMode.test(encryptMode, decryptMode, n, printWriter, printWriter2);
        encryptMode.close();
        decryptMode.close();
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        Crypto.initRandom();
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (stringArray.length < 2) {
            TestMode.help(printWriter);
            return;
        }
        boolean bl = TestMode.test(stringArray[0], stringArray[1], printWriter, printWriter);
        System.out.println();
        if (bl) {
            System.out.println("All tests passed");
        } else {
            System.out.println("Some tests failed");
        }
        Thread.sleep(100L);
    }

    private TestMode() {
    }
}

