/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.DESKey;
import org.logi.crypto.keys.SymmetricKey;

public class TriDESKey
extends SymmetricKey
implements CipherKey {
    private DESKey k1;
    private DESKey k2;
    private DESKey k3;

    public static TriDESKey parseCDS(String string) throws InvalidCDSException {
        int n = 0;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n == string.length()) {
            throw new InvalidCDSException("Empty argument in TriDESKey(String)");
        }
        int n2 = string.length() - 1;
        while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
            --n2;
        }
        if (n2 == n && string.charAt(n) == '?') {
            return new TriDESKey();
        }
        byte[] byArray = Crypto.fromHexString(string);
        return new TriDESKey(byArray);
    }

    public int plainBlockSize() {
        return 8;
    }

    public int cipherBlockSize() {
        return 8;
    }

    public int getSize() {
        return 168;
    }

    public String getAlgorithm() {
        return "TriDES";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TriDESKey triDESKey = (TriDESKey)object;
        return this.k1.equals(triDESKey.k1) && this.k2.equals(triDESKey.k2) && this.k3.equals(triDESKey.k3);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[24];
        System.arraycopy(this.k1.getKey(), 0, byArray, 0, 8);
        System.arraycopy(this.k2.getKey(), 0, byArray, 8, 8);
        System.arraycopy(this.k3.getKey(), 0, byArray, 16, 8);
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(56);
        stringBuffer.append("TriDESKey(");
        stringBuffer.append(Crypto.hexString(this.k1.getKey()));
        stringBuffer.append(Crypto.hexString(this.k2.getKey()));
        stringBuffer.append(Crypto.hexString(this.k3.getKey()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        long l = Crypto.makeLong(byArray, n, 8);
        l = Crypto.pickBits(l, DESKey.IP);
        l = this.k1.subCrypt(l);
        l = this.k2.subDecrypt(l);
        l = this.k3.subCrypt(l);
        l = Crypto.pickBits(l, DESKey.FP);
        Crypto.writeBytes(l, byArray2, n2, 8);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        long l = Crypto.makeLong(byArray, n, 8);
        l = Crypto.pickBits(l, DESKey.IP);
        l = this.k3.subDecrypt(l);
        l = this.k2.subCrypt(l);
        l = this.k1.subDecrypt(l);
        l = Crypto.pickBits(l, DESKey.FP);
        Crypto.writeBytes(l, byArray2, n2, 8);
    }

    public TriDESKey() {
        this.k1 = new DESKey();
        this.k2 = new DESKey();
        this.k3 = new DESKey();
    }

    public TriDESKey(byte[] byArray) {
        if (byArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Creating a zero-length triple-DES key");
        }
        if (byArray.length < 24) {
            byte[] byArray2 = new byte[24];
            int n = 0;
            while (n < 24) {
                System.arraycopy(byArray, 0, byArray2, n, Math.min(byArray.length, 24 - n));
                n += byArray.length;
            }
            byArray = byArray2;
        }
        this.k1 = new DESKey(Crypto.makeLong(byArray, 0, 8));
        this.k2 = new DESKey(Crypto.makeLong(byArray, 8, 8));
        this.k3 = new DESKey(Crypto.makeLong(byArray, 16, 8));
    }
}

