/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;
import org.logi.crypto.modes.OFBProducer;

public class DecryptOFB
extends DecryptMode {
    private OFBProducer producer;
    private int bufSize;
    private byte[] keyStream;
    private int keyPos;
    private byte[] IV;
    private int IVPos = 0;
    private CipherKey key;

    public CipherKey getKey() {
        return this.key;
    }

    public synchronized void setKey(CipherKey cipherKey) {
        if (this.producer != null) {
            this.producer.kill();
            this.producer = null;
        }
        this.key = cipherKey;
        this.IV = new byte[cipherKey.plainBlockSize()];
    }

    public int plainBlockSize() {
        return 1;
    }

    public synchronized byte[] decrypt(byte[] byArray, int n, int n2) {
        if (this.IV != null) {
            if (this.IVPos == 0 && n2 >= this.IV.length) {
                this.producer = new OFBProducer(this.key, this.bufSize, byArray, n);
                n2 -= this.producer.ibs;
                n += this.producer.ibs;
                this.IV = null;
            } else {
                int n3 = Math.min(this.IV.length - this.IVPos, n2);
                System.arraycopy(byArray, n, this.IV, this.IVPos, n3);
                this.IVPos += n3;
                if (this.IVPos == this.IV.length) {
                    this.producer = new OFBProducer(this.key, this.bufSize, this.IV, 0);
                    this.IV = null;
                }
                if ((n2 -= n3) == 0) {
                    return new byte[0];
                }
                n += n3;
            }
        }
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        if (this.keyStream == null) {
            this.keyStream = this.producer.nextBuffer();
            this.keyPos = 0;
        }
        while (n2 > 0) {
            if (this.keyPos == this.keyStream.length) {
                this.keyStream = this.producer.nextBuffer();
                this.keyPos = 0;
            }
            int n5 = Math.min(n2, this.keyStream.length - this.keyPos);
            n2 -= n5;
            int n6 = n + n5;
            while (n < n6) {
                byArray2[n4++] = (byte)(byArray[n++] ^ this.keyStream[this.keyPos++]);
            }
        }
        return byArray2;
    }

    public void close() {
        if (this.producer == null) {
            return;
        }
        this.producer.kill();
        this.producer = null;
    }

    public DecryptOFB(CipherKey cipherKey, int n) {
        this.bufSize = n;
        this.setKey(cipherKey);
    }

    public DecryptOFB(int n) {
        this.bufSize = n;
    }
}

