/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class BooleanControl
extends Control {
    private final String trueStateLabel;
    private final String falseStateLabel;
    private boolean value;

    protected BooleanControl(Type type, boolean initialValue) {
        this(type, initialValue, "true", "false");
    }

    protected BooleanControl(Type type, boolean initialValue, String trueStateLabel, String falseStateLabel) {
        super(type);
        this.value = initialValue;
        this.trueStateLabel = trueStateLabel;
        this.falseStateLabel = falseStateLabel;
    }

    public String getStateLabel(boolean state) {
        return state ? this.trueStateLabel : this.falseStateLabel;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public String toString() {
        return new String(String.valueOf(super.toString()) + " with current value: " + this.getStateLabel(this.value));
    }

    public static class Type
    extends Control.Type {
        public static final Type MUTE = new Type("Mute");
        public static final Type APPLY_REVERB = new Type("Apply Reverb");

        protected Type(String name) {
            super(name);
        }
    }
}

