/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractPlayer;
import com.sun.media.sound.Printer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

class MixerSequencer
extends AbstractPlayer
implements Sequencer {
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    static final MixerSequencerInfo info;
    private static Sequencer.SyncMode[] masterSyncModes;
    private static Sequencer.SyncMode[] slaveSyncModes;
    private static Sequencer.SyncMode masterSyncMode;
    private static Sequencer.SyncMode slaveSyncMode;
    private long timeStamp = -1L;
    private Sequence sequence = null;
    private byte[] midiData = null;
    private boolean runningInEngine = false;
    private boolean newSequenceStarted = false;
    private long tick = -1L;
    private float tempoInBPM = -1.0f;
    private float tempoInMPQ = -1.0f;
    private boolean running = false;
    private boolean recording = false;
    private boolean sequenceChanged = false;
    private long startTime = 0L;
    private long startMillisecondTime = 0L;
    private long lastTempoChangeTime = 0L;
    private long lastTempoChangeTick = 0L;
    private long recordTempoInMPQ = 500000L;
    private long startTick = 0L;
    private float divisionType = 0.0f;
    private int resolution = 0;
    private SequencerReceiver sequencerReceiver = null;
    private Vector recordingTracks = new Vector();
    private Vector metaEventListeners = new Vector();
    private Vector controllerEventListeners = new Vector();

    static {
        class Com_sun_media_sound_MixerSequencer$1 {
            /* synthetic */ Com_sun_media_sound_MixerSequencer$1() {
            }
        }
        info = new MixerSequencerInfo();
        masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
        slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
        masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
        slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    }

    protected MixerSequencer() throws MidiUnavailableException {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer CONSTRUCTOR completed");
        }
    }

    public int[] addControllerEventListener(ControllerEventListener listener, int[] controllers) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement cve = null;
            boolean flag = false;
            int i = 0;
            while (i < this.controllerEventListeners.size()) {
                cve = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
                if (cve.listener.equals(listener)) {
                    cve.addControllers(controllers);
                    flag = true;
                    break;
                }
                ++i;
            }
            if (!flag) {
                cve = new ControllerVectorElement(null, listener, controllers);
                this.controllerEventListeners.addElement(cve);
            }
            if (this.id != 0) {
                int i2 = 0;
                while (i2 < controllers.length) {
                    this.nAddControllerEventCallback(this.id, controllers[i2]);
                    ++i2;
                }
            }
            int[] nArray = cve.getControllers();
            Object var5_9 = null;
            return nArray;
        }
    }

    public boolean addMetaEventListener(MetaEventListener listener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            if (!this.metaEventListeners.contains(listener)) {
                this.metaEventListeners.addElement(listener);
            }
            boolean bl = true;
            Object var4_4 = null;
            return bl;
        }
    }

    private long calculateTickPosition(long elapsedTime) {
        if (this.divisionType == 0.0f) {
            long ppqelapsed = elapsedTime - this.lastTempoChangeTime;
            long tick = ppqelapsed >= 0L ? this.lastTempoChangeTick + ppqelapsed * (long)this.resolution * 1000L / this.recordTempoInMPQ : elapsedTime * (long)this.resolution * 1000L / this.recordTempoInMPQ;
            return tick;
        }
        return (long)((float)elapsedTime * this.divisionType * (float)this.resolution / 1000.0f);
    }

    private void callbackControllerEvent(int channel, int track, int controller, int value) {
        block4: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackControllerEvent()");
            }
            ShortMessage newMessage = new ShortMessage();
            try {
                newMessage.setMessage(176 + channel, controller, value);
                this.sendControllerEvents(newMessage, controller);
            }
            catch (InvalidMidiDataException e1) {
                if (!Printer.debug) break block4;
                Printer.debug("invalid midi data: " + e1);
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackControllerEvent() completed");
        }
    }

    private void callbackMetaEvent(int type, int msgLength, int channel, byte[] data) {
        block6: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackMetaEvent()");
            }
            if (Printer.debug) {
                Printer.debug("    type = " + type + ", msgLength = " + msgLength + ", channel = " + channel);
            }
            MetaMessage newMessage = new MetaMessage();
            try {
                newMessage.setMessage(type, data, msgLength);
                if (Printer.debug) {
                    Printer.debug("new meta message: " + newMessage);
                }
                this.sendMetaEvents(newMessage);
            }
            catch (InvalidMidiDataException e1) {
                if (!Printer.debug) break block6;
                Printer.debug("invalid midi data: " + e1);
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackMetaEvent() completed");
        }
    }

    private synchronized void callbackSongEnd() {
        MetaMessage message;
        block8: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackSongEnd()");
            }
            this.implStop();
            this.runningInEngine = false;
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                this.notifyAll();
            }
            message = new MetaMessage();
            try {
                message.setMessage(47, new byte[0], 0);
                if (Printer.debug) {
                    Printer.debug("new meta message: " + message);
                }
            }
            catch (InvalidMidiDataException e1) {
                if (!Printer.debug) break block8;
                Printer.debug("invalid midi data: " + e1);
            }
        }
        this.sendMetaEvents(message);
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackSongEnd completed()");
        }
    }

    private void callbackSongStart() {
        if (Printer.trace) {
            Printer.trace("MixerSequencer: callbackSongStart()");
        }
    }

    private void callbackSongStop() {
        if (Printer.trace) {
            Printer.trace("MixerSequencer: callbackSongStop()");
        }
    }

    private boolean findTrack(Track track) {
        boolean found = false;
        if (this.sequence != null) {
            Track[] tracks = this.sequence.getTracks();
            int i = 0;
            while (i < tracks.length) {
                if (track == tracks[i]) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    protected byte[] getBytesFromFileStream(InputStream stream, MidiFileFormat format) throws IOException {
        byte[] data;
        if (stream == null) {
            throw new IOException("Stream is null");
        }
        long length = format.getByteLength();
        if (length != -1L) {
            data = new byte[(int)length];
            if ((long)stream.read(data) != length) {
                throw new IOException("Read failure: expected " + length + " bytes");
            }
        } else {
            int MAX_READ_LIMIT = 2048;
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(ba);
            int readCount = MAX_READ_LIMIT;
            byte[] tmp = new byte[readCount];
            int num = 0;
            int readByte = 0;
            while (true) {
                if ((readByte = stream.read(tmp, 0, readCount)) == -1) {
                    if (num != 0) break;
                    throw new IOException("No data found in stream");
                }
                dos.write(tmp, 0, readByte);
                num += readByte;
                Thread.currentThread();
                Thread.yield();
            }
            data = ba.toByteArray();
        }
        return data;
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, returnedModes, 0, masterSyncModes.length);
        return returnedModes;
    }

    public long getMicrosecondLength() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getMicrosecondLength() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequenceMicrosecondLength(this.id);
    }

    public long getMicrosecondPosition() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getMicrosecondPosition() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequencerMicrosecondPosition(this.id);
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        if (this.sequencerReceiver == null) {
            this.sequencerReceiver = new SequencerReceiver();
        }
        return this.sequencerReceiver;
    }

    public Sequence getSequence() {
        block3: {
            if (this.sequence != null || this.midiData == null || this.midiData.length <= 0) break block3;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.midiData);
            try {
                this.sequence = MidiSystem.getSequence(bais);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
            catch (IOException iOException) {}
        }
        return this.sequence;
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, returnedModes, 0, slaveSyncModes.length);
        return returnedModes;
    }

    public float getTempoFactor() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoFactor() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        return this.nGetMasterTempo(this.id);
    }

    public float getTempoInBPM() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoInBPM() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInBPM != -1.0f) {
            return this.tempoInBPM;
        }
        return this.nGetTempoInBPM(this.id);
    }

    public float getTempoInMPQ() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoInMPQ() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInMPQ != -1.0f) {
            return this.tempoInMPQ;
        }
        return this.nGetTempoInMPQ(this.id);
    }

    public long getTickLength() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTickLength() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequenceTickLength(this.id);
    }

    public synchronized long getTickPosition() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTickPosition() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequencerTickPosition(this.id) / 64L;
    }

    public long getTimeStamp() {
        return this.getMicrosecondPosition();
    }

    public boolean getTrackMute(int track) {
        if (this.id == 0) {
            return false;
        }
        return this.nGetTrackMute(this.id, track);
    }

    public boolean getTrackSolo(int track) {
        if (this.id == 0) {
            return false;
        }
        return this.nGetTrackSolo(this.id, track);
    }

    public synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: implClose() ");
        }
        this.implStop();
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.newSequenceStarted = false;
        while (this.runningInEngine) {
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: implClose() completed");
        }
    }

    public void implOpen() throws MidiUnavailableException {
        this.openInternalSynth();
    }

    protected void implStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: implStop()");
        }
        this.nPauseSequencer(this.id);
        this.running = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected native void nAddControllerEventCallback(int var1, int var2);

    protected native float nGetMasterTempo(int var1);

    protected native long nGetSequenceMicrosecondLength(int var1);

    protected native long nGetSequenceTickLength(int var1);

    protected native long nGetSequencerMicrosecondPosition(int var1);

    protected native long nGetSequencerTickPosition(int var1);

    protected native int nGetTempoInBPM(int var1);

    protected native int nGetTempoInMPQ(int var1);

    protected native boolean nGetTrackMute(int var1, int var2);

    protected native boolean nGetTrackSolo(int var1, int var2);

    protected native int nOpenMidiSequencer(byte[] var1, int var2);

    protected native int nOpenRmfSequencer(byte[] var1, int var2);

    protected native void nPauseSequencer(int var1);

    protected native void nResumeSequencer(int var1);

    protected native float nSetMasterTempo(int var1, float var2);

    protected native long nSetSequencerMicrosecondPosition(int var1, long var2);

    protected native long nSetSequencerTickPosition(int var1, long var2);

    protected native int nSetTempoInBPM(int var1, int var2);

    protected native int nSetTempoInMPQ(int var1, int var2);

    protected native void nSetTrackMute(int var1, int var2, boolean var3);

    protected native void nSetTrackSolo(int var1, int var2, boolean var3);

    protected native void nStartSequencer(int var1);

    public void recordDisable(Track track) {
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack rc = RecordingTrack.get(this.recordingTracks, track);
            if (rc != null) {
                this.recordingTracks.removeElement(rc);
            }
        }
    }

    public void recordEnable(Track track, int channel) {
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack rc = RecordingTrack.get(this.recordingTracks, track);
            if (rc != null) {
                rc.channel = channel;
            } else {
                this.recordingTracks.addElement(new RecordingTrack(track, channel));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] removeControllerEventListener(ControllerEventListener listener, int[] controllers) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement cve = null;
            boolean flag = false;
            int i = 0;
            while (i < this.controllerEventListeners.size()) {
                cve = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
                if (cve.listener.equals(listener)) {
                    cve.removeControllers(controllers);
                    flag = true;
                    break;
                }
                ++i;
            }
            if (!flag) {
                return new int[0];
            }
            if (controllers != null) return cve.getControllers();
            this.controllerEventListeners.removeElement(cve);
            return new int[0];
        }
    }

    public void removeMetaEventListener(MetaEventListener listener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            this.metaEventListeners.removeElement(listener);
        }
    }

    protected void sendControllerEvents(ShortMessage message, int controller) {
        if (Printer.debug) {
            Printer.debug("sending a controller event");
        }
        Vector<ControllerEventListener> sendToListeners = new Vector<ControllerEventListener>();
        int i = 0;
        while (i < this.controllerEventListeners.size()) {
            ControllerVectorElement cve = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
            int j = 0;
            while (j < cve.controllers.length) {
                if (cve.controllers[j] == controller) {
                    sendToListeners.addElement(cve.listener);
                    break;
                }
                ++j;
            }
            ++i;
        }
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(message, sendToListeners);
    }

    protected void sendMetaEvents(MetaMessage message) {
        if (Printer.debug) {
            Printer.debug("sending a meta event");
        }
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(message, this.metaEventListeners);
    }

    public void setMasterSyncMode(Sequencer.SyncMode sync) {
    }

    public void setMicrosecondPosition(long microseconds) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setMicrosecondPosition() ");
        }
        if (this.id == 0) {
            return;
        }
        this.nSetSequencerMicrosecondPosition(this.id, microseconds);
        this.tick = -1L;
    }

    public synchronized void setSequence(InputStream stream) throws IOException, InvalidMidiDataException {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setSequence(" + stream + ")");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        MidiFileFormat fileFormat = MidiSystem.getMidiFileFormat(stream);
        int type = fileFormat.getType();
        if (type == 2) {
            throw new InvalidMidiDataException("Unsupported file type: " + type + ". Only type 0 and type 1 MIDI files are supported.");
        }
        if (this.id != 0) {
            this.stop();
            this.implClose();
            try {
                this.implOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {}
        }
        this.midiData = this.getBytesFromFileStream(stream, fileFormat);
        if (this.midiData == null || this.midiData.length == 0) {
            throw new IOException("Failed to read data from stream.");
        }
        if (type == 0 || type == 1) {
            this.id = this.nOpenMidiSequencer(this.midiData, this.midiData.length);
            if (this.id == 0) {
                this.id = this.nOpenRmfSequencer(this.midiData, this.midiData.length);
            }
        }
        if (this.id == 0) {
            throw new InvalidMidiDataException("Failed to load sequence");
        }
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i].setId(this.id);
            ++i;
        }
        this.connectToInternalSynth();
        i = 0;
        while (i < this.controllerEventListeners.size()) {
            ControllerVectorElement cve = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
            int z = 0;
            while (z < cve.controllers.length) {
                this.nAddControllerEventCallback(this.id, cve.controllers[z]);
                ++z;
            }
            ++i;
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: setSequence(" + stream + ") completed");
        }
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setSequence(" + sequence + ")");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        int[] midiFileTypes = MidiSystem.getMidiFileTypes(sequence);
        if (midiFileTypes.length == 0) {
            throw new InvalidMidiDataException("Unsupported sequence: " + sequence);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MidiSystem.write(sequence, midiFileTypes[0], baos);
            baos.close();
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Unable to get file stream from sequence: " + sequence);
        }
        byte[] fileByteArray = baos.toByteArray();
        ByteArrayInputStream fileStream = new ByteArrayInputStream(fileByteArray);
        try {
            this.setSequence(fileStream);
            this.sequence = sequence;
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Failed to load sequence: " + sequence);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: setSequence(" + sequence + ") completed");
        }
    }

    public void setSlaveSyncMode(Sequencer.SyncMode sync) {
    }

    public void setTempoFactor(float factor) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoFactor() ");
        }
        if (this.id == 0) {
            return;
        }
        this.nSetMasterTempo(this.id, factor);
    }

    public void setTempoInBPM(float bpm) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoInBPM() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInBPM = bpm;
            this.tempoInMPQ = 6.0E7f / bpm;
        } else {
            this.nSetTempoInBPM(this.id, (int)bpm);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public void setTempoInMPQ(float mpq) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoInMPQ() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInMPQ = mpq;
            this.tempoInBPM = 6.0E7f / mpq;
        } else {
            this.nSetTempoInMPQ(this.id, (int)mpq);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public synchronized void setTickPosition(long tick) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTickPosition() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.running) {
            this.tick = tick * 64L;
        } else {
            this.nSetSequencerTickPosition(this.id, tick * 64L);
            this.tick = -1L;
        }
    }

    public void setTimeStamp(long timeStamp) {
    }

    public void setTrackMute(int track, boolean mute) {
        if (this.id == 0) {
            return;
        }
        this.nSetTrackMute(this.id, track, mute);
    }

    public void setTrackSolo(int track, boolean solo) {
        if (this.id == 0) {
            return;
        }
        this.nSetTrackSolo(this.id, track, solo);
    }

    public synchronized void start() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: start()");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.id == 0) {
            return;
        }
        if (this.running) {
            return;
        }
        if (this.sequenceChanged) {
            try {
                this.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {}
            this.sequenceChanged = false;
        }
        this.running = true;
        if (!this.newSequenceStarted) {
            this.nStartSequencer(this.id);
            this.newSequenceStarted = true;
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            }
            if (this.tempoInBPM != -1.0f) {
                this.setTempoInBPM(this.tempoInBPM);
            }
            if (this.tempoInMPQ != -1.0f) {
                this.setTempoInMPQ(this.tempoInMPQ);
            }
        } else {
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            } else if (!this.runningInEngine) {
                this.setMicrosecondPosition(0L);
            }
            this.nResumeSequencer(this.id);
        }
        this.runningInEngine = true;
        this.callbackSongStart();
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: start() completed");
        }
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = true;
        this.divisionType = this.sequence.getDivisionType();
        this.resolution = this.sequence.getResolution();
        this.startTime = System.currentTimeMillis();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
        this.startTick = 0L;
        this.lastTempoChangeTime = 0L;
        this.lastTempoChangeTick = this.startTick;
        this.recordTempoInMPQ = (long)this.getTempoInMPQ();
        this.start();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
    }

    public synchronized void stop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: stop()");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.stopRecording();
        if (this.id == 0) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.implStop();
        this.callbackSongStop();
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: stop() completed");
        }
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.recording) {
            this.sequenceChanged = true;
        }
        this.recording = false;
    }

    class SequencerReceiver
    extends AbstractPlayer.PlayerReceiver {
        SequencerReceiver() {
        }

        public void send(MidiMessage message, long timeStamp) {
            super.send(message, timeStamp);
            if (MixerSequencer.this.recording) {
                Vector v = null;
                long tickPos = timeStamp < 0L ? (MixerSequencer.this.running ? MixerSequencer.this.calculateTickPosition(MixerSequencer.this.getMicrosecondPosition() / 1000L) : MixerSequencer.this.calculateTickPosition(MixerSequencer.this.startMillisecondTime + (System.currentTimeMillis() - MixerSequencer.this.startTime))) : MixerSequencer.this.calculateTickPosition(timeStamp);
                MidiEvent me = new MidiEvent(message, tickPos);
                v = message instanceof ShortMessage ? RecordingTrack.get(MixerSequencer.this.recordingTracks, ((ShortMessage)message).getChannel()) : RecordingTrack.get(MixerSequencer.this.recordingTracks, 0);
                int i = 0;
                while (i < v.size()) {
                    ((Track)v.elementAt(i)).add(me);
                    ++i;
                }
            }
        }
    }

    private static class MixerSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer / synthesizer module";
        private static final String version = "Version 1.0";

        private MixerSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    private class ControllerVectorElement {
        int[] controllers;
        ControllerEventListener listener;

        /* synthetic */ ControllerVectorElement(1 $0, ControllerEventListener $1, int[] $2) {
            this($1, $2);
        }

        private ControllerVectorElement(ControllerEventListener listener, int[] controllers) {
            this.listener = listener;
            this.controllers = controllers;
        }

        private void addControllers(int[] c) {
            if (c == null) {
                return;
            }
            int[] temp = new int[this.controllers.length + c.length];
            int i = 0;
            while (i < this.controllers.length) {
                temp[i] = this.controllers[i];
                ++i;
            }
            int elements = this.controllers.length;
            int i2 = 0;
            while (i2 < c.length) {
                boolean flag = false;
                int j = 0;
                while (j < this.controllers.length) {
                    if (c[i2] == this.controllers[j]) {
                        flag = true;
                        break;
                    }
                    ++j;
                }
                if (!flag) {
                    temp[elements++] = c[i2];
                }
                ++i2;
            }
            int[] newc = new int[elements];
            int i3 = 0;
            while (i3 < elements) {
                newc[i3] = temp[i3];
                ++i3;
            }
            this.controllers = newc;
        }

        private int[] getControllers() {
            int[] c = new int[this.controllers.length];
            int i = 0;
            while (i < this.controllers.length) {
                c[i] = this.controllers[i];
                ++i;
            }
            return c;
        }

        private void removeControllers(int[] c) {
            if (c == null) {
                this.controllers = new int[0];
            } else {
                int[] temp = new int[this.controllers.length];
                int elements = 0;
                int i = 0;
                while (i < this.controllers.length) {
                    boolean flag = false;
                    int j = 0;
                    while (j < c.length) {
                        if (this.controllers[i] == c[j]) {
                            flag = true;
                            break;
                        }
                        ++j;
                    }
                    if (!flag) {
                        temp[elements++] = this.controllers[i];
                    }
                    ++i;
                }
                int[] newc = new int[elements];
                int i2 = 0;
                while (i2 < elements) {
                    newc[i2] = temp[i2];
                    ++i2;
                }
                this.controllers = newc;
            }
        }
    }

    static class RecordingTrack {
        Track track;
        int channel;

        RecordingTrack(Track track, int channel) {
            this.track = track;
            this.channel = channel;
        }

        static Vector get(Vector vector, int channel) {
            Vector<Track> newV = new Vector<Track>();
            Vector vector2 = vector;
            synchronized (vector2) {
                int size = vector.size();
                int i = 0;
                while (i < size) {
                    RecordingTrack current = (RecordingTrack)vector.elementAt(i);
                    if (current.channel == channel || current.channel == -1) {
                        newV.addElement(current.track);
                    }
                    ++i;
                }
            }
            return newV;
        }

        static RecordingTrack get(Vector vector, Track track) {
            Vector vector2 = vector;
            synchronized (vector2) {
                int size = vector.size();
                int i = 0;
                while (i < size) {
                    RecordingTrack current = (RecordingTrack)vector.elementAt(i);
                    if (current.track == track) {
                        RecordingTrack recordingTrack = current;
                        Object var4_7 = null;
                        return recordingTrack;
                    }
                    ++i;
                }
            }
            return null;
        }
    }
}

