/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Printer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

class HeadspaceSoundbank
implements Soundbank {
    String name;
    String version;
    String vendor;
    String description;
    Vector instruments = new Vector();
    Vector samples = new Vector();
    Vector sequences = new Vector();
    private int id = 0;

    HeadspaceSoundbank(File file) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: file: " + file);
        }
        FileInputStream fis = new FileInputStream(file);
        this.initialize(fis);
    }

    HeadspaceSoundbank(InputStream stream) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: stream: " + stream);
        }
        this.initialize(stream);
    }

    HeadspaceSoundbank(String path) {
        this.initialize(path);
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: path: " + path + " completed");
        }
    }

    HeadspaceSoundbank(URL url) throws IOException {
        String protocol;
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: url: " + url);
        }
        if (!(protocol = url.getProtocol()).equals("file")) {
            this.initialize(url.openStream());
        } else {
            String path = url.getFile();
            this.initialize(path);
        }
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: url: " + url + " completed");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Instrument getInstrument(Patch patch) {
        Vector vector = this.instruments;
        synchronized (vector) {
            int i = 0;
            while (i < this.instruments.size()) {
                Instrument returnedInstrument = (Instrument)this.instruments.elementAt(i);
                if (returnedInstrument.getPatch().getBank() == patch.getBank() && returnedInstrument.getPatch().getProgram() == patch.getProgram()) {
                    Instrument instrument = returnedInstrument;
                    Object var5_6 = null;
                    return instrument;
                }
                ++i;
            }
        }
        return null;
    }

    public Instrument[] getInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            int i = 0;
            while (i < instrumentArray.length) {
                instrumentArray[i] = (Instrument)this.instruments.elementAt(i);
                ++i;
            }
        }
        return instrumentArray;
    }

    public String getName() {
        return this.name;
    }

    public SoundbankResource[] getResources() {
        SoundbankResource[] sampleArray;
        Vector vector = this.samples;
        synchronized (vector) {
            sampleArray = new SoundbankResource[this.samples.size()];
            int i = 0;
            while (i < sampleArray.length) {
                sampleArray[i] = (SoundbankResource)this.samples.elementAt(i);
                ++i;
            }
        }
        return sampleArray;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    private void initialize(InputStream stream) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: stream: " + stream);
        }
        HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        byte[] loadedbank = null;
        int bytesRead = 0;
        while (true) {
            if ((bytesRead = stream.read(buffer, 0, buffer.length)) <= 0) break;
            baos.write(buffer, 0, bytesRead);
        }
        stream.close();
        loadedbank = baos.toByteArray();
        if (Printer.debug) {
            Printer.debug("> calling nOpenResourceFromByteArray with length: " + loadedbank.length);
        }
        this.id = this.nOpenResourceFromByteArray(loadedbank, loadedbank.length);
        if (Printer.debug) {
            Printer.debug("> returned from nOpenResourceFromByteArray; id = " + this.id);
        }
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: stream: " + stream + " completed");
        }
    }

    private void initialize(String path) {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: path: " + path);
        }
        HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
        if (Printer.debug) {
            Printer.debug("> calling nOpenResource with path: " + path);
        }
        this.id = this.nOpenResource(path);
        if (Printer.debug) {
            Printer.debug("> returned from nOpenResource; id = " + this.id);
        }
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: path: " + path + " completed");
        }
    }

    private native boolean nCloseResource(int var1);

    private native void nGetInstruments(int var1, Vector var2);

    private native String nGetName(int var1);

    private native void nGetSamples(int var1, Vector var2);

    private native int nGetVersionMajor(int var1);

    private native int nGetVersionMinor(int var1);

    private native int nGetVersionSubMinor(int var1);

    private native int nOpenResource(String var1);

    private native int nOpenResourceFromByteArray(byte[] var1, int var2);

    private void setupInformation() {
        this.name = this.nGetName(this.id);
        if (this.name == null) {
            this.name = "Untitled Headspace Soundbank";
        }
        int versionMajor = this.nGetVersionMajor(this.id);
        int versionMinor = this.nGetVersionMinor(this.id);
        int versionSubMinor = this.nGetVersionSubMinor(this.id);
        this.version = new String(String.valueOf(versionMajor) + "." + versionMinor + "." + versionSubMinor);
        this.vendor = "Sun Microsystems, Headspace Corporation";
        this.description = "Soundbank for use with Headspace Mixer.";
        this.nGetInstruments(this.id, this.instruments);
        this.nGetSamples(this.id, this.samples);
    }
}

