/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Printer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;
    private int position = 0;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer mixer, Control[] controls, AudioFormat format, int bufferSize) {
        super(info, mixer, controls);
        this.defaultFormat = format;
        this.defaultBufferSize = bufferSize;
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    public int available() {
        return 0;
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.stop();
            this.setOpen(false);
            this.implClose();
            this.mixer.close(this);
            this.format = this.defaultFormat;
            this.bufferSize = this.defaultBufferSize;
        }
    }

    public void drain() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: drain");
        }
    }

    public void flush() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: flush");
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public float getLevel() {
        return -1.0f;
    }

    public long getMicrosecondPosition() {
        long microseconds = -1L;
        int frames = this.getFramePosition();
        if (frames != -1) {
            microseconds = (long)((double)frames * 1000000.0 / (double)this.getFormat().getFrameRate());
        }
        return microseconds;
    }

    abstract void implClose();

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implStart();

    abstract void implStop();

    public boolean isActive() {
        return this.active;
    }

    public boolean isRunning() {
        return this.started;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    public synchronized void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: open()");
        }
        this.open(this.format, this.bufferSize);
    }

    public void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, -1);
    }

    public synchronized void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: open(format, bufferSize)");
        }
        if (!this.isOpen()) {
            this.mixer.open(this, format, bufferSize);
            try {
                this.implOpen(format, bufferSize);
                this.setOpen(true);
            }
            catch (LineUnavailableException e) {
                this.mixer.close(this);
                throw e;
            }
        } else if (!format.matches(this.getFormat()) || bufferSize != -1 && bufferSize != this.getBufferSize()) {
            throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: open(format, bufferSize) completed");
        }
    }

    protected void setActive(boolean active) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setActive(" + active + ")");
        }
        boolean sendEvents = false;
        int position = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setActive: this.active: " + this.active);
            }
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setActive: active: " + active);
            }
            if (this.active != active) {
                this.active = active;
                sendEvents = true;
            }
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setActive: this.active: " + this.active);
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setActive: sendEvents: " + sendEvents);
        }
    }

    protected void setEOM() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setEOM()");
        }
        int position = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.started = false;
        }
        this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, position));
    }

    protected void setStarted(boolean started) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setStarted(" + started + ")");
        }
        boolean sendEvents = false;
        int position = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setStarted: this.started: " + this.started);
            }
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setStarted: started: " + started);
            }
            if (this.started != started) {
                this.started = started;
                sendEvents = true;
            }
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setStarted: this.started: " + this.started);
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setStarted: sendEvents: " + sendEvents);
        }
        if (sendEvents) {
            if (started) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, position));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, position));
            }
        }
    }

    public void start() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: start()");
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.isOpen() && !this.isStartedRunning()) {
                if (this.mixer != this) {
                    this.mixer.start(this);
                }
                this.implStart();
                this.running = true;
            }
        }
        abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: start() completed");
        }
    }

    public void stop() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: stop()");
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: stop() completed");
        }
    }
}

