/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class SwingPropertyChangeSupport
extends PropertyChangeSupport {
    private transient Vector listeners;
    private Hashtable children;
    private Object source;
    static final long serialVersionUID = 7162625831330845068L;

    public SwingPropertyChangeSupport(Object object) {
        super(object);
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) == null) {
            swingPropertyChangeSupport = new SwingPropertyChangeSupport(this.source);
            this.children.put(string, swingPropertyChangeSupport);
        }
        swingPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = null;
        SwingPropertyChangeSupport swingPropertyChangeSupport2 = this;
        synchronized (swingPropertyChangeSupport2) {
            if (this.children != null && string != null) {
                swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
            }
        }
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.listeners.elementAt(n2);
                propertyChangeListener.propertyChange(propertyChangeEvent);
                ++n2;
            }
        }
        if (swingPropertyChangeSupport != null) {
            swingPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.children != null && string != null) {
                swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
            }
        }
        if (this.listeners != null || swingPropertyChangeSupport != null) {
            serializable = new PropertyChangeEvent(this.source, string, object, object2);
            if (this.listeners != null) {
                int n = 0;
                while (n < this.listeners.size()) {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.listeners.elementAt(n);
                    propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
                    ++n;
                }
            }
            if (swingPropertyChangeSupport != null) {
                swingPropertyChangeSupport.firePropertyChange((PropertyChangeEvent)serializable);
            }
        }
    }

    public synchronized boolean hasListeners(String string) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) != null) {
            return swingPropertyChangeSupport.listeners.isEmpty() ^ true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
        if (swingPropertyChangeSupport == null) {
            return;
        }
        swingPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = null;
        SwingPropertyChangeSupport swingPropertyChangeSupport = this;
        synchronized (swingPropertyChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n2);
                if (propertyChangeListener instanceof Serializable) {
                    objectOutputStream.writeObject(propertyChangeListener);
                }
                ++n2;
            }
        }
        objectOutputStream.writeObject(null);
    }
}

