/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JWindow
extends Window
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JWindow() {
        this(null);
    }

    public JWindow(Frame frame) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame);
        this.windowInit();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJWindow();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected String paramString() {
        String string = this.rootPaneCheckingEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",rootPaneCheckingEnabled=" + string;
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    protected void windowInit() {
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected class AccessibleJWindow
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleJWindow() {
        }

        public void addFocusListener(FocusListener focusListener) {
            JWindow.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return JWindow.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JWindow.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JWindow.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JWindow.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JWindow.this);
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JWindow.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JWindow.this);
            if (JWindow.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            return ((Component)JWindow.this).getBackground();
        }

        public Rectangle getBounds() {
            return JWindow.this.getBounds();
        }

        public Cursor getCursor() {
            return JWindow.this.getCursor();
        }

        public Font getFont() {
            return JWindow.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return JWindow.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return JWindow.this.getForeground();
        }

        public Locale getLocale() {
            return JWindow.this.getLocale();
        }

        public Point getLocation() {
            return JWindow.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return JWindow.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return JWindow.this.getSize();
        }

        public boolean isEnabled() {
            return JWindow.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return JWindow.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return JWindow.this.isShowing();
        }

        public boolean isVisible() {
            return JWindow.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            JWindow.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            JWindow.this.requestFocus();
        }

        public void setBackground(Color color) {
            ((Component)JWindow.this).setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JWindow.this).setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            ((Component)JWindow.this).setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            JWindow.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            ((Component)JWindow.this).setFont(font);
        }

        public void setForeground(Color color) {
            JWindow.this.setForeground(color);
        }

        public void setLocation(Point point) {
            ((Component)JWindow.this).setLocation(point);
        }

        public void setSize(Dimension dimension) {
            ((Component)JWindow.this).setSize(dimension);
        }

        public void setVisible(boolean bl) {
            ((Component)JWindow.this).setVisible(bl);
        }
    }
}

