/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final String uiClassID = "ScrollBarUI";
    private ChangeListener fwdAdjustmentEvents = new ModelListener();
    protected BoundedRangeModel model;
    protected int orientation;
    protected int unitIncrement;
    protected int blockIncrement;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    public JScrollBar() {
        this(1);
    }

    public JScrollBar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public JScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.checkOrientation(n);
        this.unitIncrement = 1;
        this.blockIncrement = n3 == 0 ? 1 : n3;
        this.orientation = n;
        this.model = new DefaultBoundedRangeModel(n2, n3, n4, n5);
        this.model.addChangeListener(this.fwdAdjustmentEvents);
        this.updateUI();
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = JScrollBar.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireAdjustmentValueChanged(int n, int n2, int n3) {
        Object[] objectArray = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = null;
        int n4 = objectArray.length - 2;
        while (n4 >= 0) {
            if (objectArray[n4] == (class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : JScrollBar.class$("java.awt.event.AdjustmentListener"))) {
                if (adjustmentEvent == null) {
                    adjustmentEvent = new AdjustmentEvent(this, n, n2, n3);
                }
                ((AdjustmentListener)objectArray[n4 + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            n4 -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar();
        }
        return this.accessibleContext;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getBlockIncrement(int n) {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getOrientation() == 1) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.orientation == 1) {
            return new Dimension(dimension.width, 5);
        }
        return new Dimension(5, dimension.height);
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getUnitIncrement(int n) {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public int getVisibleAmount() {
        return this.getModel().getExtent();
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return String.valueOf(super.paramString()) + ",blockIncrement=" + this.blockIncrement + ",orientation=" + string + ",unitIncrement=" + this.unitIncrement;
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = JScrollBar.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    public void setBlockIncrement(int n) {
        int n2 = this.blockIncrement;
        this.blockIncrement = n;
        this.firePropertyChange("blockIncrement", n2, n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        Integer n = null;
        BoundedRangeModel boundedRangeModel2 = this.model;
        if (this.model != null) {
            this.model.removeChangeListener(this.fwdAdjustmentEvents);
            n = new Integer(this.model.getValue());
        }
        this.model = boundedRangeModel;
        if (this.model != null) {
            this.model.addChangeListener(this.fwdAdjustmentEvents);
        }
        this.firePropertyChange("model", boundedRangeModel2, this.model);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n, new Integer(this.model.getValue()));
        }
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        if (n2 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n != n2) {
            this.revalidate();
        }
    }

    public void setUnitIncrement(int n) {
        int n2 = this.unitIncrement;
        this.unitIncrement = n;
        this.firePropertyChange("unitIncrement", n2, n);
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n2), new Integer(boundedRangeModel.getValue()));
        }
    }

    public void setValueIsAdjusting(boolean bl) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl2 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl);
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    public void setValues(int n, int n2, int n3, int n4) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n5 = boundedRangeModel.getValue();
        boundedRangeModel.setRangeProperties(n, n2, n3, n4, boundedRangeModel.getValueIsAdjusting());
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n5), new Integer(boundedRangeModel.getValue()));
        }
    }

    public void setVisibleAmount(int n) {
        this.getModel().setExtent(n);
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = 601;
            int n2 = 5;
            JScrollBar.this.fireAdjustmentValueChanged(n, n2, JScrollBar.this.getValue());
        }
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJScrollBar() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JScrollBar.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JScrollBar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JScrollBar.this.getValue());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JScrollBar.this.getMaximum());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JScrollBar.this.getMinimum());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JScrollBar.this.setValue(number.intValue());
                return true;
            }
            return false;
        }
    }
}

