/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuBarUI";
    private transient SingleSelectionModel selectionModel;
    private boolean paintBorder = true;
    private Insets margin = null;

    public JMenuBar() {
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public JMenu add(JMenu jMenu) {
        super.add(jMenu);
        return jMenu;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getCurrentManager().registerMenuBar(this);
    }

    JComponent.KeyboardBinding bindingForKeyStroke(KeyStroke keyStroke, int n) {
        JComponent.KeyboardBinding keyboardBinding = super.bindingForKeyStroke(keyStroke, n);
        if (keyboardBinding != null) {
            return keyboardBinding;
        }
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof JMenu) {
                keyboardBinding = JMenuBar.bindingForKeyStrokeRecursive(componentArray[n2], keyStroke, n);
            }
            if (keyboardBinding != null) {
                return keyboardBinding;
            }
            ++n2;
        }
        return null;
    }

    static JComponent.KeyboardBinding bindingForKeyStrokeRecursive(Component component, KeyStroke keyStroke, int n) {
        JMenu jMenu;
        Component[] componentArray;
        JComponent.KeyboardBinding keyboardBinding = null;
        if (component == null) {
            return null;
        }
        if (component instanceof JComponent && (keyboardBinding = ((JComponent)component).bindingForKeyStroke(keyStroke, n)) != null) {
            return keyboardBinding;
        }
        if (component instanceof JMenu && (componentArray = (jMenu = (JMenu)component).getMenuComponents()) != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof JMenuItem) {
                    keyboardBinding = JMenuBar.bindingForKeyStrokeRecursive(componentArray[n2], keyStroke, n);
                }
                if (keyboardBinding != null) {
                    return keyboardBinding;
                }
                ++n2;
            }
        }
        return keyboardBinding;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() not yet implemented.");
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public JMenu getMenu(int n) {
        Component component = this.getComponentAtIndex(n);
        if (component instanceof JMenu) {
            return (JMenu)component;
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        Vector<Component> vector = new Vector<Component>();
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n2;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = 0;
        n = vector.size();
        while (n2 < n) {
            menuElementArray[n2] = (MenuElement)vector.elementAt(n2);
            ++n2;
        }
        return menuElementArray;
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public void menuSelectionChanged(boolean bl) {
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        return String.valueOf(super.paramString()) + ",margin=" + string2 + ",paintBorder=" + string;
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) break;
            if (objectArray[n].equals("selectionModel")) {
                this.selectionModel = (SingleSelectionModel)objectArray[n + 1];
            }
            n += 2;
        }
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getCurrentManager().unregisterMenuBar(this);
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange("borderPainted", bl2, this.paintBorder);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        if (insets2 == null || !insets.equals(insets2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.selectionModel;
        this.selectionModel = singleSelectionModel;
        this.firePropertyChange("selectionModel", singleSelectionModel2, this.selectionModel);
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = new Object[4];
        int n = 0;
        if (this.selectionModel instanceof Serializable) {
            objectArray[n++] = "selectionModel";
            objectArray[n++] = this.selectionModel;
        }
        objectOutputStream.writeObject(objectArray);
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
        }

        public void addAccessibleSelection(int n) {
            JMenu jMenu;
            int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n == n2) {
                return;
            }
            if (n2 >= 0 && n2 < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n2)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(n);
            jMenu = JMenuBar.this.getMenu(n);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{JMenuBar.this, jMenu, jMenu.getPopupMenu()};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }

        public void clearAccessibleSelection() {
            JMenu jMenu;
            int n = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n >= 0 && n < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            if (JMenuBar.this.isSelected()) {
                if (n != 0) {
                    return null;
                }
                int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
                if (JMenuBar.this.getComponentAtIndex(n2) instanceof Accessible) {
                    return (Accessible)((Object)JMenuBar.this.getComponentAtIndex(n2));
                }
            }
            return null;
        }

        public int getAccessibleSelectionCount() {
            if (JMenuBar.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JMenuBar.this.getSelectionModel().getSelectedIndex();
        }

        public void removeAccessibleSelection(int n) {
            if (n >= 0 && n < JMenuBar.this.getMenuCount()) {
                JMenu jMenu = JMenuBar.this.getMenu(n);
                if (jMenu != null) {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
                JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

