/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.SwingGraphics;
import javax.swing.SwingUtilities;

public class CellRendererPane
extends Container
implements Accessible {
    protected AccessibleContext accessibleContext = null;

    public CellRendererPane() {
        this.setLayout(null);
        this.setVisible(false);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component.getParent() == this) {
            return;
        }
        super.addImpl(component, object, n);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCellRendererPane();
        }
        return this.accessibleContext;
    }

    public void invalidate() {
    }

    public void paint(Graphics graphics) {
    }

    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        this.paintComponent(graphics, component, container, n, n2, n3, n4, false);
    }

    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
        if (component == null) {
            if (container != null) {
                Color color = graphics.getColor();
                graphics.setColor(container.getBackground());
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(color);
            }
            return;
        }
        if (component.getParent() != this) {
            this.add(component);
        }
        component.setBounds(n, n2, n3, n4);
        if (bl) {
            component.validate();
        }
        boolean bl2 = false;
        if (component instanceof JComponent && ((JComponent)component).isDoubleBuffered()) {
            bl2 = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics, n, n2, n3, n4);
        try {
            component.paint(graphics2);
        }
        finally {
            Object var12_12 = null;
            graphics2.dispose();
        }
        if (component instanceof JComponent && bl2) {
            ((JComponent)component).setDoubleBuffered(true);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setDoubleBuffered(bl2);
        }
        component.setBounds(-n3, -n4, 0, 0);
    }

    public void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        this.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void update(Graphics graphics) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeAll();
        objectOutputStream.defaultWriteObject();
    }

    protected class AccessibleCellRendererPane
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleCellRendererPane() {
        }

        public void addFocusListener(FocusListener focusListener) {
            CellRendererPane.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return CellRendererPane.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(CellRendererPane.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(CellRendererPane.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(CellRendererPane.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(CellRendererPane.this);
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = CellRendererPane.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(CellRendererPane.this);
        }

        public Color getBackground() {
            return CellRendererPane.this.getBackground();
        }

        public Rectangle getBounds() {
            return CellRendererPane.this.getBounds();
        }

        public Cursor getCursor() {
            return CellRendererPane.this.getCursor();
        }

        public Font getFont() {
            return CellRendererPane.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return CellRendererPane.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return CellRendererPane.this.getForeground();
        }

        public Locale getLocale() {
            return CellRendererPane.this.getLocale();
        }

        public Point getLocation() {
            return CellRendererPane.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return CellRendererPane.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return CellRendererPane.this.getSize();
        }

        public boolean isEnabled() {
            return CellRendererPane.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return CellRendererPane.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return CellRendererPane.this.isShowing();
        }

        public boolean isVisible() {
            return CellRendererPane.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            CellRendererPane.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            CellRendererPane.this.requestFocus();
        }

        public void setBackground(Color color) {
            CellRendererPane.this.setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            CellRendererPane.this.setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            CellRendererPane.this.setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            CellRendererPane.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            ((Component)CellRendererPane.this).setFont(font);
        }

        public void setForeground(Color color) {
            CellRendererPane.this.setForeground(color);
        }

        public void setLocation(Point point) {
            CellRendererPane.this.setLocation(point);
        }

        public void setSize(Dimension dimension) {
            CellRendererPane.this.setSize(dimension);
        }

        public void setVisible(boolean bl) {
            CellRendererPane.this.setVisible(bl);
        }
    }
}

