/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleState;

public class AccessibleStateSet {
    protected Vector states = null;

    public AccessibleStateSet() {
        this.states = null;
    }

    public AccessibleStateSet(AccessibleState[] accessibleStateArray) {
        if (accessibleStateArray.length != 0) {
            this.states = new Vector(accessibleStateArray.length);
            int n = 0;
            while (n < accessibleStateArray.length) {
                if (!this.states.contains(accessibleStateArray[n])) {
                    this.states.addElement(accessibleStateArray[n]);
                }
                ++n;
            }
        }
    }

    public boolean add(AccessibleState accessibleState) {
        if (this.states == null) {
            this.states = new Vector();
        }
        if (!this.states.contains(accessibleState)) {
            this.states.addElement(accessibleState);
            return true;
        }
        return false;
    }

    public void addAll(AccessibleState[] accessibleStateArray) {
        if (accessibleStateArray.length != 0) {
            if (this.states == null) {
                this.states = new Vector(accessibleStateArray.length);
            }
            int n = 0;
            while (n < accessibleStateArray.length) {
                if (!this.states.contains(accessibleStateArray[n])) {
                    this.states.addElement(accessibleStateArray[n]);
                }
                ++n;
            }
        }
    }

    public void clear() {
        if (this.states != null) {
            this.states.removeAllElements();
        }
    }

    public boolean contains(AccessibleState accessibleState) {
        if (this.states == null) {
            return false;
        }
        return this.states.contains(accessibleState);
    }

    public boolean remove(AccessibleState accessibleState) {
        if (this.states == null) {
            return false;
        }
        return this.states.removeElement(accessibleState);
    }

    public AccessibleState[] toArray() {
        if (this.states == null) {
            return new AccessibleState[0];
        }
        AccessibleState[] accessibleStateArray = new AccessibleState[this.states.size()];
        int n = 0;
        while (n < accessibleStateArray.length) {
            accessibleStateArray[n] = (AccessibleState)this.states.elementAt(n);
            ++n;
        }
        return accessibleStateArray;
    }

    public String toString() {
        String string = null;
        if (this.states != null && this.states.size() > 0) {
            string = ((AccessibleState)this.states.elementAt(0)).toDisplayString();
            int n = 1;
            while (n < this.states.size()) {
                string = String.valueOf(string) + "," + ((AccessibleState)this.states.elementAt(n)).toDisplayString();
                ++n;
            }
        }
        return string;
    }
}

