/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class LineNumberTableEntry
extends AbstractStructure {
    public static final int LENGTH = 4;
    private int startPc;
    private int lineNumber;

    public static LineNumberTableEntry create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        LineNumberTableEntry lineNumberTableEntry = new LineNumberTableEntry();
        lineNumberTableEntry.setClassFile(classFile);
        lineNumberTableEntry.read(dataInput);
        return lineNumberTableEntry;
    }

    public int getStartPc() {
        return this.startPc;
    }

    public void setStartPc(int n) {
        this.startPc = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.startPc = dataInput.readUnsignedShort();
        this.lineNumber = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.startPc);
        dataOutput.writeShort(this.lineNumber);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "LineNumberTable entry with start_pc " + this.startPc + ", line_number " + this.lineNumber);
    }
}

