/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.InnerClassesEntry;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "InnerClasses";
    private static final int INITIAL_LENGTH = 2;
    private InnerClassesEntry[] classes;

    public InnerClassesEntry[] getClasses() {
        return this.classes;
    }

    public void setClasses(InnerClassesEntry[] innerClassesEntryArray) {
        this.classes = innerClassesEntryArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.classes = new InnerClassesEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.classes[n2] = InnerClassesEntry.create(dataInput, this.classFile);
            ++n2;
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.classes);
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            this.classes[n2].write(dataOutput);
            ++n2;
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 2 + this.getLength(this.classes) * 8;
    }

    protected void debug(String string) {
        super.debug(string + "InnerClasses attribute with " + this.getLength(this.classes) + " classes");
    }
}

