/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.ClassVariable;
import org.jruby.embed.variable.Constant;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.embed.variable.LocalGlobalVariable;
import org.jruby.embed.variable.PersistentLocalVariable;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableInterceptor {
    private LocalVariableBehavior behavior;

    public VariableInterceptor(LocalVariableBehavior behavior) {
        this.behavior = behavior;
    }

    public BiVariable getVariableInstance(Ruby runtime, String name, Object ... value) {
        if (value == null || value.length < 1) {
            return null;
        }
        switch (this.behavior) {
            case GLOBAL: {
                return LocalGlobalVariable.getInstance(runtime, name, value);
            }
            case BSF: {
                BiVariable[] bEntries = new BiVariable[]{PersistentLocalVariable.getInstance(runtime, name, value), GlobalVariable.getInstance(runtime, name, value)};
                return this.resolve(bEntries);
            }
            case PERSISTENT: {
                BiVariable[] pEntries = new BiVariable[]{GlobalVariable.getInstance(runtime, name, value), InstanceVariable.getInstance(runtime, name, value), ClassVariable.getInstance(runtime, name, value), Constant.getInstance(runtime, name, value), PersistentLocalVariable.getInstance(runtime, name, value)};
                return this.resolve(pEntries);
            }
        }
        BiVariable[] tEntries = new BiVariable[]{GlobalVariable.getInstance(runtime, name, value), InstanceVariable.getInstance(runtime, name, value), ClassVariable.getInstance(runtime, name, value), Constant.getInstance(runtime, name, value), TransientLocalVariable.getInstance(runtime, name, value)};
        return this.resolve(tEntries);
    }

    private BiVariable resolve(BiVariable[] entries) {
        for (BiVariable e : entries) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public void inject(BiVariableMap map, Ruby runtime, ManyVarsDynamicScope scope, int depth, IRubyObject receiver) {
        int i;
        IRubyObject[] values4Injection;
        if (scope != null && (values4Injection = map.getLocalVarValues()) != null && values4Injection.length > 0) {
            for (i = 0; i < values4Injection.length; ++i) {
                scope.setValue(i, values4Injection[i], depth);
            }
        }
        List<BiVariable> variables = map.getVariables();
        for (i = 0; i < variables.size(); ++i) {
            variables.get(i).inject(runtime, receiver);
        }
    }

    public void retrieve(BiVariableMap map, Ruby runtime, IRubyObject receiver) {
        switch (this.behavior) {
            case GLOBAL: {
                LocalGlobalVariable.retrieve(runtime, receiver, map);
                break;
            }
            case BSF: {
                PersistentLocalVariable.retrieve(runtime, receiver, map);
                break;
            }
            case PERSISTENT: {
                PersistentLocalVariable.retrieve(runtime, receiver, map);
            }
            default: {
                InstanceVariable.retrieve(runtime, receiver, map);
                GlobalVariable.retrieve(runtime, receiver, map);
                ClassVariable.retrieve(runtime, receiver, map);
                Constant.retrieve(runtime, receiver, map);
            }
        }
    }

    public void terminateGlobalVariables(List<BiVariable> variables, Ruby runtime) {
        if (LocalVariableBehavior.GLOBAL == this.behavior) {
            for (int i = 0; i < variables.size(); ++i) {
                if (BiVariable.Type.GlobalVariable != variables.get(i).getType()) continue;
                IRubyObject irobj = JavaEmbedUtils.javaToRuby((Ruby)runtime, null);
                runtime.getGlobalVariables().set("$" + variables.get(i).getName(), irobj);
            }
        }
    }

    public void terminateLocalVariables(List<String> varNames, List<BiVariable> variables) {
        if (LocalVariableBehavior.TRANSIENT == this.behavior) {
            for (int i = 0; i < variables.size(); ++i) {
                if (BiVariable.Type.LocalVariable != variables.get(i).getType()) continue;
                varNames.remove(i);
                variables.remove(i);
            }
        }
    }
}

