/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiVariableMap<K, V>
implements Map<K, V> {
    private Ruby runtime;
    private List<String> varNames;
    private List<BiVariable> variables;
    private VariableInterceptor interceptor;

    public BiVariableMap(Ruby runtime) {
        this(runtime, LocalVariableBehavior.TRANSIENT);
    }

    public BiVariableMap(Ruby runtime, LocalVariableBehavior behavior) {
        this.runtime = runtime;
        this.varNames = Collections.synchronizedList(new ArrayList());
        this.variables = Collections.synchronizedList(new ArrayList());
        this.interceptor = new VariableInterceptor(behavior);
    }

    public List<String> getNames() {
        return this.varNames;
    }

    public List<BiVariable> getVariables() {
        return this.variables;
    }

    public VariableInterceptor getVariableInterceptor() {
        return this.interceptor;
    }

    public Map getMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (BiVariable v : this.variables) {
            m.put(v.getName(), v.getJavaObject());
        }
        return m;
    }

    @Override
    public int size() {
        return this.varNames.size();
    }

    @Override
    public boolean isEmpty() {
        return this.varNames.isEmpty();
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is NOT String");
        }
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("key is empty");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.varNames.contains((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (BiVariable v : this.variables) {
            if (value != v.getJavaObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.containsKey(key)) {
            return (V)this.getVariable((String)key).getJavaObject();
        }
        return null;
    }

    public BiVariable getVariable(String key) {
        if (this.containsKey(key)) {
            int index = this.varNames.indexOf(key);
            return this.variables.get(index);
        }
        return null;
    }

    public void setVariable(BiVariable var) {
        if (var == null) {
            return;
        }
        String key = var.getName();
        BiVariable old = this.getVariable(key);
        if (old != null) {
            old.setJavaObject(this.runtime, var.getJavaObject());
        } else {
            this.varNames.add(key);
            this.variables.add(var);
        }
    }

    @Override
    public V put(K key, V value) {
        String name = (String)key;
        BiVariable v = this.getVariable(name);
        Object oldValue = null;
        if (v != null) {
            oldValue = v.getJavaObject();
            v.setJavaObject(this.runtime, value);
        } else {
            v = this.interceptor.getVariableInstance(this.runtime, name, value);
            if (v != null) {
                this.varNames.add(name);
                this.variables.add(v);
            }
        }
        return (V)oldValue;
    }

    public String[] getLocalVarNames() {
        ArrayList<String> localVarNames = new ArrayList<String>();
        for (BiVariable v : this.variables) {
            if (v.getType() != BiVariable.Type.LocalVariable) continue;
            localVarNames.add(v.getName());
        }
        if (localVarNames.size() > 0) {
            return localVarNames.toArray(new String[localVarNames.size()]);
        }
        return null;
    }

    public IRubyObject[] getLocalVarValues() {
        ArrayList<IRubyObject> localVarValues = new ArrayList<IRubyObject>();
        for (BiVariable v : this.variables) {
            if (v.getType() != BiVariable.Type.LocalVariable) continue;
            localVarValues.add(v.getRubyObject());
        }
        if (localVarValues.size() > 0) {
            return localVarValues.toArray(new IRubyObject[localVarValues.size()]);
        }
        return null;
    }

    void inject(ManyVarsDynamicScope scope, int depth, IRubyObject receiver) {
        this.interceptor.inject(this, this.runtime, scope, depth, receiver);
    }

    void retrieve(IRubyObject receiver) {
        this.interceptor.retrieve(this, this.runtime, receiver);
    }

    void terminate() {
        this.interceptor.terminateGlobalVariables(this.variables, this.runtime);
        this.interceptor.terminateLocalVariables(this.varNames, this.variables);
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            int index = this.varNames.indexOf(key);
            this.varNames.remove(index);
            BiVariable v = this.variables.remove(index);
            v.remove(this.runtime);
            return (V)v.getJavaObject();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new NullPointerException("map is null");
        }
        if (t.isEmpty()) {
            throw new IllegalArgumentException("map is empty");
        }
        Set<Map.Entry<K, V>> set = t.entrySet();
        for (Map.Entry<K, V> entry : set) {
            if (entry.getKey() instanceof String) {
                K key = entry.getKey();
                V value = entry.getValue();
                this.put(key, value);
                continue;
            }
            throw new ClassCastException("key is NOT String");
        }
    }

    @Override
    public void clear() {
        this.varNames.clear();
        for (BiVariable v : this.variables) {
            if (v == null) continue;
            v.remove(this.runtime);
        }
        this.variables.clear();
    }

    @Override
    public Set keySet() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        HashSet<String> s = new HashSet<String>();
        for (String name : this.varNames) {
            s.add(name);
        }
        return s;
    }

    @Override
    public Collection values() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (BiVariable v : this.variables) {
            l.add(v.getJavaObject());
        }
        return l;
    }

    @Override
    public Set entrySet() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        return this.getMap().entrySet();
    }

    public void update(String name, BiVariable value) {
        this.varNames.add(name);
        this.variables.add(value);
    }
}

