package jfractionlab.jflDialogs;

import info.clearthought.layout.TableLayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jfractionlab.JFractionLab;

public class WorkSheetDialog extends JDialog implements ActionListener, KeyListener {
	static final long serialVersionUID = JFractionLab.serialVersionUID;
	
	protected Container content;
	protected JLabel lbTitle = new JLabel("", JLabel.CENTER);
	protected JPanel pnFile = new JPanel();
		protected JLabel lbFileText = new JLabel();
		protected JTextField jtfFile = new JTextField();
		protected JButton btnChooseFile = new JButton();
	protected JPanel pnOptions = new JPanel();
	protected JButton btnOK = new JButton();
	protected JButton btnCancel = new JButton();
	private double sizes_main[][];
	MyOwnFocusTraversalPolicy newPolicy = new MyOwnFocusTraversalPolicy();
	
	protected File exerciseFile;
	protected File solutionsFile;
	
	public WorkSheetDialog(boolean withOptions){
		super();
		setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
		createGUI(withOptions);
	}
	
	protected void createGUI(boolean withOptions){
		setTitle(lang.Messages.getString("generate_worksheets"));
		if(withOptions){
			sizes_main = new double[][]{{
				5,
				TableLayout.FILL,
				TableLayout.FILL,
				5
			},{
				5,
				0.15,
				TableLayout.FILL,
				TableLayout.FILL,
				0.15,
				5
			}}; //Spalten / Zeilen
		}else{
			sizes_main = new double[][] {{
				5,
				TableLayout.FILL,
				TableLayout.FILL,
				5
			},{
				5,
				0.15,
				TableLayout.FILL,
				0.15,
				5
			}}; //Spalten / Zeilen
		}
		content = getContentPane();
		content.setLayout(new TableLayout(sizes_main));
		content.add(lbTitle,"1,1,2,1");
		
		double sizes_file[][] = {{
			5,
			0.8,
			TableLayout.FILL,
			5
		},{
			5,
			TableLayout.FILL,
			TableLayout.FILL,
			TableLayout.FILL,
			5
		}}; //Spalten / Zeilen
		pnFile.setLayout(new TableLayout(sizes_file));
		pnFile.setBorder(BorderFactory.createEtchedBorder());
			lbFileText.setText("<html><body>"
					+lang.Messages.getString("file")
					+"<br>"
					+lang.Messages.getString("choose_exercisefilename")
					+"</body></html>"
			);
		pnFile.add(lbFileText, "1,1,2,2");
			jtfFile.setText(System.getProperty("user.home")
					+System.getProperty("file.separator")
			);
			jtfFile.addKeyListener(this);
		pnFile.add(jtfFile, "1,3");
			btnChooseFile.setText(lang.Messages.getString("choose_file"));
			btnChooseFile.addActionListener(this);
		pnFile.add(btnChooseFile, "2,3");
		content.add(pnFile, "1,2,2,2");

//		content.add(pnOptions, "1,3,2,3");

		btnCancel.setText(lang.Messages.getString("cancel"));
		btnCancel.addActionListener(this);
		btnCancel.addKeyListener(this);
		
		btnOK.setText(lang.Messages.getString("save"));
		btnOK.addActionListener(this);
		btnOK.addKeyListener(this);
		if(withOptions){
			content.add(btnCancel,"1,4");
			content.add(btnOK, "2,4");
		}else{
			content.add(btnCancel,"1,3");
			content.add(btnOK, "2,3");
		}
		
		setFocusTraversalPolicy(newPolicy);
//		jtfFile.requestFocusInWindow();
	}
	
	protected String chooseFileName(){
		String strReturn = "";
		JFileChooser fc = new JFileChooser();
		fc.setLocale(lang.Messages.getLocale());
		int returnVal = fc.showSaveDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
				strReturn = fc.getSelectedFile().toString();
		}else{
			strReturn = System.getProperty("user.home")
				+System.getProperty("file.separator");
		}
		return strReturn;
	}
	
	protected boolean filesAreCreatedSuccessfully(String str){
		exerciseFile = new File(str+"_"+lang.Messages.getString("exercises.tex"));
		solutionsFile = new File(str+"_"+lang.Messages.getString("solutions.tex"));
		if(exerciseFile.exists() || solutionsFile.exists()){
			String[] options = {
					lang.Messages.getString("yes"),
					lang.Messages.getString("no"),
			};
			int n = JOptionPane.showOptionDialog(
					null,
					lang.Messages.getString("file_exists_overwrite?"),
					"",//title
					JOptionPane.YES_NO_OPTION,
					JOptionPane.WARNING_MESSAGE,
					null,//icon
					options,
					options[1]);
			if(n == JOptionPane.YES_OPTION){
				//overwrite
				return true;
			}else if (n == JOptionPane.NO_OPTION){
				//do not overwrite
				return false;
			}else{
				//this should be impossible
				return false;
			}
		}else{
			return true;
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {}
	@Override
	public void keyPressed(KeyEvent event){}
	@Override
	public void keyTyped(KeyEvent event){}
	@Override
	public void keyReleased(KeyEvent event){}

	public class MyOwnFocusTraversalPolicy extends FocusTraversalPolicy {
		@Override
		public Component getComponentAfter(Container aContainer,Component aComponent) {
			//soll: btn_yes, btn_no,
			if(aComponent.equals(btnOK)) {
				return btnCancel;
			}else if(aComponent.equals(btnCancel)){
				return btnOK;
			}else{
				return btnOK;
			}
		}

		@Override
		public Component getComponentBefore(Container aContainer,Component aComponent) {
			//soll: btn_yes, btn_no
			if(aComponent.equals(btnOK)) {
				return btnCancel;
			}else if(aComponent.equals(btnCancel)){
				return btnOK;
			}else{
				return btnOK;
			}
		}

		@Override
		public Component getDefaultComponent(Container aContainer) {
			return btnOK;
		}

		@Override
		public Component getFirstComponent(Container aContainer) {
			return btnOK;
		}

		@Override
		public Component getLastComponent(Container aContainer) {return null;}
	}//MyOwnFocusTraversalPolicy
	
	protected void close(){
		setVisible(false);
		dispose();
	}
}