/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.objectweb.carol.cmi.ConfigException;
import org.objectweb.carol.util.configuration.RMIConfigurationException;

public class Config {
    private static boolean configured = false;
    private static String multicastAddress = null;
    private static String multicastItf = null;
    private static int multicastPort = -1;
    private static String multicastGroupName = null;
    private static String localHost = null;
    public static final int DEFAULT_RR_FACTOR = 100;
    private static int loadFactor = 100;
    private static boolean stubDebug = false;
    public static final String MULTICAST_ADDRESS_PROPERTY = "carol.cmi.multicast.address";
    public static final String MULTICAST_ITF_PROPERTY = "carol.cmi.multicast.itf";
    public static final String MULTICAST_GROUPNAME_PROPERTY = "carol.cmi.multicast.groupname";
    public static final String RR_FACTOR_PROPERTY = "carol.cmi.rr.factor";
    public static final String STUB_DEBUG_PROPERTY = "carol.cmi.stub.debug";

    public static synchronized void setProperties(Properties pr) throws RMIConfigurationException {
        if (configured) {
            throw new RMIConfigurationException("Cmi already configured");
        }
        Iterator<Map.Entry<Object, Object>> i = pr.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            String s = (String)e.getValue();
            Object k = e.getKey();
            if (k.equals(MULTICAST_ADDRESS_PROPERTY)) {
                s = s.trim();
                try {
                    int l = s.indexOf(58);
                    s.substring(0, l);
                    String a = InetAddress.getByName(s.substring(0, l)).getHostAddress();
                    int p = new Integer(s.substring(l + 1));
                    multicastAddress = a;
                    multicastPort = p;
                    continue;
                }
                catch (Exception ex) {
                    throw new RMIConfigurationException("Invalid multicast address (" + s + ")");
                }
            }
            if (k.equals(MULTICAST_GROUPNAME_PROPERTY)) {
                multicastGroupName = s.trim();
                continue;
            }
            if (k.equals(MULTICAST_ITF_PROPERTY)) {
                multicastItf = s.trim();
                continue;
            }
            if (k.equals(RR_FACTOR_PROPERTY)) {
                loadFactor = new Integer(s.trim());
                continue;
            }
            if (!k.equals(STUB_DEBUG_PROPERTY)) continue;
            stubDebug = new Boolean(s.trim());
        }
        configured = true;
    }

    public static String getMulticastGroupName() throws ConfigException {
        if (multicastGroupName == null) {
            throw new ConfigException("Property carol.cmi.multicast.groupname not defined");
        }
        return multicastGroupName;
    }

    public static String getMulticastAddress() throws ConfigException {
        if (multicastAddress == null) {
            throw new ConfigException("Property carol.cmi.multicast.address not defined");
        }
        return multicastAddress;
    }

    public static int getMulticastPort() {
        return multicastPort;
    }

    public static String getMulticastItf() {
        return multicastItf;
    }

    public static int getLoadFactor() {
        return loadFactor;
    }

    public static boolean isStubDebug() {
        return stubDebug;
    }
}

