/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.jmx;

import java.util.EventListener;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpServer;
import org.mortbay.http.Version;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ComponentEvent;
import org.mortbay.util.ComponentListener;
import org.mortbay.util.jmx.LifeCycleMBean;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class HttpServerMBean
extends LifeCycleMBean
implements ComponentListener {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$jmx$HttpServerMBean == null ? (class$org$mortbay$http$jmx$HttpServerMBean = HttpServerMBean.class$("org.mortbay.http.jmx.HttpServerMBean")) : class$org$mortbay$http$jmx$HttpServerMBean));
    private HttpServer _httpServer;
    private HashMap _mbeanMap = new HashMap();
    static /* synthetic */ Class class$org$mortbay$http$jmx$HttpServerMBean;

    protected HttpServerMBean(HttpServer httpServer) throws MBeanException, InstanceNotFoundException {
        this._httpServer = httpServer;
        this._httpServer.addEventListener((EventListener)((Object)this));
        try {
            super.setManagedResource(this._httpServer, "objectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public HttpServerMBean() throws MBeanException, InstanceNotFoundException {
        this(new HttpServer());
    }

    public void setManagedResource(Object o, String s) throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (o != null) {
            ((HttpServer)o).addEventListener((EventListener)((Object)this));
        }
        super.setManagedResource(o, s);
    }

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("listeners", false);
        this.defineAttribute("contexts", false);
        this.defineAttribute("version", false, true);
        this.defineAttribute("components", false, true);
        this.defineAttribute("requestLog");
        this.defineAttribute("trace");
        this.defineOperation("addListener", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addListener", new String[]{"org.mortbay.util.InetAddrPort"}, 1);
        this.defineOperation("addListener", new String[]{"org.mortbay.http.HttpListener"}, 1);
        this.defineOperation("removeListener", new String[]{"org.mortbay.http.HttpListener"}, 1);
        this.defineOperation("addContext", new String[]{"org.mortbay.http.HttpContext"}, 1);
        this.defineOperation("removeContext", new String[]{"org.mortbay.http.HttpContext"}, 1);
        this.defineOperation("addContext", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addContext", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineAttribute("requestsPerGC");
        this.defineAttribute("statsOn");
        this.defineAttribute("statsOnMs");
        this.defineOperation("statsReset", 1);
        this.defineAttribute("connections");
        this.defineAttribute("connectionsOpen");
        this.defineAttribute("connectionsOpenMin");
        this.defineAttribute("connectionsOpenMax");
        this.defineAttribute("connectionsDurationAve");
        this.defineAttribute("connectionsDurationMin");
        this.defineAttribute("connectionsDurationMax");
        this.defineAttribute("connectionsDurationTotal");
        this.defineAttribute("connectionsRequestsAve");
        this.defineAttribute("connectionsRequestsMin");
        this.defineAttribute("connectionsRequestsMax");
        this.defineAttribute("errors");
        this.defineAttribute("requests");
        this.defineAttribute("requestsActive");
        this.defineAttribute("requestsActiveMin");
        this.defineAttribute("requestsActiveMax");
        this.defineAttribute("requestsDurationAve");
        this.defineAttribute("requestsDurationMin");
        this.defineAttribute("requestsDurationMax");
        this.defineOperation("stop", new String[]{"java.lang.Boolean.TYPE"}, 1);
        this.defineOperation("save", new String[]{"java.lang.String"}, 1);
        this.defineOperation("destroy", 1);
    }

    public synchronized void addComponent(ComponentEvent event) {
        try {
            Object o;
            ModelMBean mbean;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Component added " + event));
            }
            if ((mbean = ModelMBeanImpl.mbeanFor(o = event.getComponent())) == null) {
                log.warn((Object)("No MBean for " + o));
            } else {
                ObjectName oName = null;
                if (mbean instanceof ModelMBeanImpl) {
                    ((ModelMBeanImpl)mbean).setBaseObjectName(this.getObjectName().toString());
                    oName = this.getMBeanServer().registerMBean(mbean, null).getObjectName();
                } else {
                    oName = this.uniqueObjectName(this.getMBeanServer(), o, this.getObjectName().toString());
                    oName = this.getMBeanServer().registerMBean(mbean, oName).getObjectName();
                }
                Holder holder = new Holder(oName, mbean);
                this._mbeanMap.put(o, holder);
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public String getVersion() {
        return Version.getDetail();
    }

    public ObjectName[] getComponents() {
        Holder[] h = this._mbeanMap.values().toArray(new Holder[this._mbeanMap.size()]);
        ObjectName[] on = new ObjectName[h.length];
        for (int i = 0; i < on.length; ++i) {
            on[i] = h[i].oName;
        }
        return on;
    }

    public synchronized void removeComponent(ComponentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component removed " + event));
        }
        try {
            Object o = event.getComponent();
            Holder holder = (Holder)this._mbeanMap.remove(o);
            if (holder != null) {
                this.getMBeanServer().unregisterMBean(holder.oName);
            } else if (o == this._httpServer) {
                this.getMBeanServer().unregisterMBean(this.getObjectName());
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public void postRegister(Boolean ok) {
        super.postRegister(ok);
    }

    public void postDeregister() {
        this._httpServer.removeEventListener((EventListener)((Object)this));
        this._httpServer = null;
        if (this._mbeanMap != null) {
            this._mbeanMap.clear();
        }
        this._mbeanMap = null;
        super.postDeregister();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Holder {
        ObjectName oName;
        Object mbean;

        Holder(ObjectName oName, Object mbean) {
            this.oName = oName;
            this.mbean = mbean;
        }
    }
}

