/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.plugins;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.shared.Manager;
import org.codehaus.wadi.shared.ManagerProxy;
import org.codehaus.wadi.shared.RoutingStrategy;

public class JkRoutingStrategy
implements RoutingStrategy {
    protected Log _log = LogFactory.getLog(this.getClass());
    protected String _name;

    public JkRoutingStrategy(String name) {
        this._name = name;
    }

    public String strip(String session) {
        int index = session.lastIndexOf(46);
        return index > -1 ? session.substring(0, index) : session;
    }

    public String augment(String session) {
        return this._name == null ? session : String.valueOf(session) + "." + this._name;
    }

    public String getInfo() {
        return "." + this._name;
    }

    public boolean canReroute() {
        return true;
    }

    public boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, Manager manager, String id) {
        return this.rerouteCookie(req, res, manager, id, this._name);
    }

    public boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, Manager manager, String id, String route) {
        int routeLen;
        int i = id.lastIndexOf(".") + 1;
        if (i < 1) {
            return false;
        }
        int idlen = id.length();
        int sufLen = idlen - i;
        if (sufLen == (routeLen = route.length()) && id.regionMatches(i, route, 0, sufLen)) {
            return false;
        }
        this._log.info((Object)("switching routing info on " + id + " to " + route));
        String newId = this.augment(this.strip(id));
        ManagerProxy.rerouteSessionCookie(req, res, manager, id, newId);
        return true;
    }

    public boolean rerouteURL() {
        return this.rerouteURL(this._name);
    }

    public boolean rerouteURL(String route) {
        this._log.warn((Object)"rerouting via url NYI:-(");
        return false;
    }
}

