/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.jetty;

import java.io.Serializable;
import java.net.InetAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionContext;
import org.codehaus.wadi.jetty.HttpSession;
import org.codehaus.wadi.jetty.HttpSessionImpl;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionContext;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class Manager
extends org.codehaus.wadi.shared.Manager
implements SessionManager,
Serializable {
    protected boolean _reuseIds = false;
    protected Thread _housekeeper;
    protected int _housekeepingInterval = 30;
    protected WebApplicationHandler _handler;
    protected WebApplicationContext _context;
    boolean _initialized = false;
    static /* synthetic */ Class class$0;

    public javax.servlet.http.HttpSession getHttpSession(String id) {
        HttpSession session;
        HttpSessionImpl impl = (HttpSessionImpl)this.get(this.getRoutingStrategy().strip(id));
        HttpSession httpSession = session = impl == null ? null : (HttpSession)impl.getFacade();
        HttpSession answer = session == null ? null : (session.isValid() ? session : null);
        return answer;
    }

    public javax.servlet.http.HttpSession newHttpSession() {
        return this.acquireImpl(this).getFacade();
    }

    public javax.servlet.http.HttpSession newHttpSession(HttpServletRequest request) {
        return this.acquireImpl(this, this._reuseIds ? this.getRoutingStrategy().strip(request.getRequestedSessionId()) : null).getFacade();
    }

    public void setHouseKeepingInterval(int seconds) {
        this._housekeepingInterval = seconds;
    }

    public int getHouseKeepingInterval() {
        return this._housekeepingInterval;
    }

    public synchronized void initialize(ServletHandler handler) {
        if (!this._initialized) {
            this._handler = (WebApplicationHandler)handler;
            String filterName = "WadiFilter";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.codehaus.wadi.shared.Filter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._handler.defineFilter(filterName, clazz.getName());
            this._handler.mapPathToFilter("/*", filterName);
            this._context = (WebApplicationContext)this._handler.getHttpContext();
            boolean distributable = this._context.isDistributable();
            if (distributable && !this._distributable) {
                this.setDistributable(distributable);
            }
            this._initialized = true;
        } else {
            this._log.warn((Object)"multiple initialisation");
        }
    }

    public synchronized void start() throws Exception {
        super.start();
        this._housekeeper = new Thread(new HouseKeeper());
        this._housekeeper.start();
    }

    public synchronized boolean isStarted() {
        return this._running;
    }

    public synchronized void stop() throws InterruptedException {
        this._running = false;
        this._housekeeper.interrupt();
        this._housekeeper.join();
        this._housekeeper = null;
        try {
            super.stop();
        }
        catch (Exception e) {
            this._log.warn((Object)"unexpected", (Throwable)e);
        }
    }

    public String getSessionCookieName() {
        return SessionManager.__SessionCookie;
    }

    public String getSessionCookiePath(HttpServletRequest req) {
        String path = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionPath");
        if (path == null) {
            path = req.getContextPath();
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return path;
    }

    public String getSessionCookieDomain() {
        return this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
    }

    public String getSessionUrlParamName() {
        return SessionManager.__SessionURL;
    }

    public boolean isServing(InetAddress address, int port) {
        return true;
    }

    public int getHttpPort() {
        return Integer.parseInt(System.getProperty("http.port"));
    }

    public ServletContext getServletContext() {
        return this._handler.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return SessionContext.NULL_IMPL;
    }

    protected org.codehaus.wadi.shared.HttpSessionImpl createImpl() {
        return new HttpSessionImpl();
    }

    protected void destroyImpl(org.codehaus.wadi.shared.HttpSessionImpl impl) {
    }

    class HouseKeeper
    implements Runnable {
        HouseKeeper() {
        }

        public void run() {
            Thread.currentThread().setContextClassLoader(Manager.this._loader);
            Manager.this._log.debug((Object)"beginning housekeeping thread");
            while (Manager.this._running) {
                try {
                    Thread.sleep(Manager.this._housekeepingInterval * 1000);
                    Manager.this.housekeeper();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    Manager.this._log.trace((Object)"housekeeper thread interrupted");
                }
                catch (Throwable t) {
                    Manager.this._log.warn((Object)"housekeeping problem", t);
                }
            }
            Manager.this._log.debug((Object)"ending housekeeping thread");
        }
    }
}

